/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.testing;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.testing.PerfMetric;
import com.apple.foundationdb.testing.Promise;
import com.apple.foundationdb.testing.WorkloadContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractWorkload {
    protected WorkloadContext context;
    private ThreadPoolExecutor executorService;
    private static long logger;

    public AbstractWorkload(final WorkloadContext workloadContext) {
        this.context = workloadContext;
        final long l = workloadContext.getProcessID();
        this.executorService = new ThreadPoolExecutor(1, 2, 10L, TimeUnit.SECONDS, new SynchronousQueue()){

            @Override
            protected void beforeExecute(Thread thread, Runnable runnable) {
                workloadContext.setProcessID(l);
                super.beforeExecute(thread, runnable);
            }
        };
    }

    protected Executor getExecutor() {
        return this.executorService;
    }

    protected abstract void setup(Database var1, Promise var2);

    protected abstract void start(Database var1, Promise var2);

    protected abstract void check(Database var1, Promise var2);

    protected List<PerfMetric> getMetrics() {
        return new ArrayList<PerfMetric>();
    }

    protected double getCheckTimeout() {
        return 3000.0;
    }

    private void shutdown() {
        this.executorService.shutdown();
    }

    public static void log(int n, String string, Map<String, String> map) {
        AbstractWorkload.log(logger, n, string, map);
    }

    private static native void log(long var0, int var2, String var3, Map<String, String> var4);
}

