/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.DirectBufferPool;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.NativeFuture;
import com.apple.foundationdb.RangeResult;
import com.apple.foundationdb.RangeResultDirectBufferIterator;
import com.apple.foundationdb.RangeResultInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;

class FutureResults
extends NativeFuture<RangeResultInfo> {
    private final EventKeeper eventKeeper;
    private boolean enableDirectBufferQueries = false;

    FutureResults(long l, boolean bl, Executor executor, EventKeeper eventKeeper) {
        super(l);
        this.registerMarshalCallback(executor);
        this.enableDirectBufferQueries = bl;
        this.eventKeeper = eventKeeper;
    }

    @Override
    protected void postMarshal(RangeResultInfo rangeResultInfo) {
    }

    @Override
    protected RangeResultInfo getIfDone_internal(long l) throws FDBException {
        FDBException fDBException;
        if (this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        }
        if ((fDBException = this.Future_getError(l)) != null && !fDBException.isSuccess()) {
            throw fDBException;
        }
        return new RangeResultInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeResult getResults() {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this.enableDirectBufferQueries ? DirectBufferPool.getInstance().poll() : null;
        if (byteBuffer != null && this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_DIRECT_BUFFER_HIT);
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        } else if (this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_DIRECT_BUFFER_MISS);
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        }
        try {
            this.pointerReadLock.lock();
            if (byteBuffer != null) {
                try (RangeResultDirectBufferIterator rangeResultDirectBufferIterator = new RangeResultDirectBufferIterator(byteBuffer);){
                    this.FutureResults_getDirect(this.getPtr(), rangeResultDirectBufferIterator.getBuffer(), rangeResultDirectBufferIterator.getBuffer().capacity());
                    RangeResult rangeResult = new RangeResult(rangeResultDirectBufferIterator);
                    return rangeResult;
                }
            }
            RangeResult rangeResult = this.FutureResults_get(this.getPtr());
            return rangeResult;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    private native RangeResult FutureResults_get(long var1) throws FDBException;

    private native void FutureResults_getDirect(long var1, ByteBuffer var3, int var4) throws FDBException;
}

