/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.DirectBufferPool;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.MappedRangeResult;
import com.apple.foundationdb.MappedRangeResultDirectBufferIterator;
import com.apple.foundationdb.MappedRangeResultInfo;
import com.apple.foundationdb.NativeFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;

class FutureMappedResults
extends NativeFuture<MappedRangeResultInfo> {
    private final EventKeeper eventKeeper;
    private boolean enableDirectBufferQueries = false;

    FutureMappedResults(long l, boolean bl, Executor executor, EventKeeper eventKeeper) {
        super(l);
        this.registerMarshalCallback(executor);
        this.enableDirectBufferQueries = bl;
        this.eventKeeper = eventKeeper;
    }

    @Override
    protected void postMarshal(MappedRangeResultInfo mappedRangeResultInfo) {
    }

    @Override
    protected MappedRangeResultInfo getIfDone_internal(long l) throws FDBException {
        FDBException fDBException;
        if (this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        }
        if ((fDBException = this.Future_getError(l)) != null && !fDBException.isSuccess()) {
            throw fDBException;
        }
        return new MappedRangeResultInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedRangeResult getResults() {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this.enableDirectBufferQueries ? DirectBufferPool.getInstance().poll() : null;
        if (byteBuffer != null && this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_DIRECT_BUFFER_HIT);
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        } else if (this.eventKeeper != null) {
            this.eventKeeper.increment(EventKeeper.Events.RANGE_QUERY_DIRECT_BUFFER_MISS);
            this.eventKeeper.increment(EventKeeper.Events.JNI_CALL);
        }
        try {
            this.pointerReadLock.lock();
            if (byteBuffer != null) {
                try (MappedRangeResultDirectBufferIterator mappedRangeResultDirectBufferIterator = new MappedRangeResultDirectBufferIterator(byteBuffer);){
                    this.FutureMappedResults_getDirect(this.getPtr(), mappedRangeResultDirectBufferIterator.getBuffer(), mappedRangeResultDirectBufferIterator.getBuffer().capacity());
                    MappedRangeResult mappedRangeResult = new MappedRangeResult(mappedRangeResultDirectBufferIterator);
                    return mappedRangeResult;
                }
            }
            MappedRangeResult mappedRangeResult = this.FutureMappedResults_get(this.getPtr());
            return mappedRangeResult;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    private native MappedRangeResult FutureMappedResults_get(long var1) throws FDBException;

    private native void FutureMappedResults_getDirect(long var1, ByteBuffer var3, int var4) throws FDBException;
}

