/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MappedKeyValue
extends KeyValue {
    private final byte[] rangeBegin;
    private final byte[] rangeEnd;
    private final List<KeyValue> rangeResult;

    MappedKeyValue(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, List<KeyValue> list) {
        super(byArray, byArray2);
        this.rangeBegin = byArray3;
        this.rangeEnd = byArray4;
        this.rangeResult = list;
    }

    public byte[] getRangeBegin() {
        return this.rangeBegin;
    }

    public byte[] getRangeEnd() {
        return this.rangeEnd;
    }

    public List<KeyValue> getRangeResult() {
        return this.rangeResult;
    }

    public static MappedKeyValue fromBytes(byte[] byArray, int[] nArray) {
        if (nArray.length < 4) {
            throw new IllegalArgumentException("There needs to be at least 4 lengths to cover the metadata");
        }
        Offset offset = new Offset();
        byte[] byArray2 = MappedKeyValue.takeBytes(offset, byArray, nArray);
        byte[] byArray3 = MappedKeyValue.takeBytes(offset, byArray, nArray);
        byte[] byArray4 = MappedKeyValue.takeBytes(offset, byArray, nArray);
        byte[] byArray5 = MappedKeyValue.takeBytes(offset, byArray, nArray);
        if ((nArray.length - 4) % 2 != 0) {
            throw new IllegalArgumentException("There needs to be an even number of lengths!");
        }
        int n = (nArray.length - 4) / 2;
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>(n);
        for (int i = 0; i < n; ++i) {
            byte[] byArray6 = MappedKeyValue.takeBytes(offset, byArray, nArray);
            byte[] byArray7 = MappedKeyValue.takeBytes(offset, byArray, nArray);
            arrayList.add(new KeyValue(byArray6, byArray7));
        }
        return new MappedKeyValue(byArray2, byArray3, byArray4, byArray5, arrayList);
    }

    static byte[] takeBytes(Offset offset, byte[] byArray, int[] nArray) {
        int n = nArray[offset.lengths];
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, offset.bytes, byArray2, 0, n);
        ++offset.lengths;
        offset.bytes += n;
        return byArray2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MappedKeyValue)) {
            return false;
        }
        MappedKeyValue mappedKeyValue = (MappedKeyValue)object;
        return Arrays.equals(this.rangeBegin, mappedKeyValue.rangeBegin) && Arrays.equals(this.rangeEnd, mappedKeyValue.rangeEnd) && Objects.equals(this.rangeResult, mappedKeyValue.rangeResult);
    }

    @Override
    public int hashCode() {
        int n = this.rangeResult == null ? 0 : this.rangeResult.hashCode();
        return 17 + (29 * n + 37 * Arrays.hashCode(this.rangeBegin) + Arrays.hashCode(this.rangeEnd));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MappedKeyValue{");
        stringBuilder.append("rangeBegin=").append(ByteArrayUtil.printable(this.rangeBegin));
        stringBuilder.append(", rangeEnd=").append(ByteArrayUtil.printable(this.rangeEnd));
        stringBuilder.append(", rangeResult=").append(this.rangeResult);
        stringBuilder.append('}');
        return super.toString() + "->" + stringBuilder.toString();
    }

    static class Offset {
        int bytes = 0;
        int lengths = 0;

        Offset() {
        }
    }
}

