/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.annotation;

import com.apple.foundationdb.annotation.GenerateVisitor;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class GenerateVisitorAnnotationHelper {
    private static final String parameterName = "element";

    private GenerateVisitorAnnotationHelper() {
    }

    static boolean process(ProcessingEnvironment processingEnv, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = processingEnv.getElementUtils();
        Types typeUtils = processingEnv.getTypeUtils();
        Messager messager = processingEnv.getMessager();
        Filer filer = processingEnv.getFiler();
        for (Element element2 : roundEnv.getElementsAnnotatedWith(GenerateVisitor.class)) {
            if (!element2.getKind().isClass() && !element2.getKind().isInterface()) {
                GenerateVisitorAnnotationHelper.error(messager, element2, "only classes and interfaces can be annotated with %s", GenerateVisitor.class.getSimpleName());
                return true;
            }
            TypeElement rootTypeElement = (TypeElement)element2;
            ModuleElement moduleElement = elementUtils.getModuleOf(element2);
            if (moduleElement == null) {
                GenerateVisitorAnnotationHelper.error(messager, element2, "cannot annotate class with  %s in null-module", GenerateVisitor.class.getSimpleName());
                return true;
            }
            if (!GenerateVisitorAnnotationHelper.isValidClass(rootTypeElement)) {
                GenerateVisitorAnnotationHelper.error(messager, rootTypeElement, "The class %s cannot be annotated with this annotation.", rootTypeElement.getQualifiedName().toString());
                return true;
            }
            GenerateVisitor generateVisitor = element2.getAnnotation(GenerateVisitor.class);
            TypeMirror rootTypeMirror = rootTypeElement.asType();
            PackageElement packageOfRoot = elementUtils.getPackageOf(rootTypeElement);
            List<TypeMirror> subClassTypeMirrors = moduleElement.getEnclosedElements().stream().flatMap(packageElement -> packageElement.getEnclosedElements().stream()).filter(element -> element.getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.ABSTRACT)).map(Element::asType).filter(mirror -> mirror.getKind() == TypeKind.DECLARED).filter(mirror -> typeUtils.isSubtype((TypeMirror)mirror, rootTypeMirror)).collect(Collectors.toList());
            try {
                GenerateVisitorAnnotationHelper.generateCode(typeUtils, filer, generateVisitor, packageOfRoot, rootTypeElement, subClassTypeMirrors);
            }
            catch (Exception exception) {
                Objects.requireNonNull(messager).printMessage(Diagnostic.Kind.ERROR, "unable to generate visitor in " + String.valueOf(packageOfRoot.getQualifiedName()) + "[" + exception.getMessage() + "]");
            }
        }
        return true;
    }

    private static void generateCode(@Nonnull Types typeUtils, @Nonnull Filer filer, @Nonnull GenerateVisitor generateVisitor, @Nonnull PackageElement packageElement, @Nonnull TypeElement rootTypeElement, @Nonnull List<TypeMirror> subClassTypeMirrors) throws IOException {
        TypeMirror rootTypeMirror = rootTypeElement.asType();
        String interfaceName = String.valueOf(rootTypeElement.getSimpleName()) + generateVisitor.classSuffix();
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T");
        String defaultMethodName = generateVisitor.methodPrefix() + "Default";
        GenerateVisitorAnnotationHelper.generateInterface(typeUtils, filer, generateVisitor, packageElement, subClassTypeMirrors, rootTypeMirror, interfaceName, typeVariableName, defaultMethodName);
        String className = String.valueOf(rootTypeElement.getSimpleName()) + generateVisitor.classSuffix() + "WithDefaults";
        GenerateVisitorAnnotationHelper.generateImplementationWithDefaults(typeUtils, filer, generateVisitor, packageElement, subClassTypeMirrors, className, interfaceName, typeVariableName, defaultMethodName);
    }

    private static void generateInterface(@Nonnull Types typeUtils, @Nonnull Filer filer, @Nonnull GenerateVisitor generateVisitor, @Nonnull PackageElement packageElement, @Nonnull List<TypeMirror> subClassTypeMirrors, @Nonnull TypeMirror rootTypeMirror, @Nonnull String interfaceName, @Nonnull TypeVariableName typeVariableName, @Nonnull String defaultMethodName) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVariableName);
        FieldSpec.Builder jumpMapBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), ParameterizedTypeName.get((ClassName)ClassName.get(BiFunction.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)packageElement.getQualifiedName().toString(), (String)interfaceName, (String[])new String[0]), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), TypeName.get((TypeMirror)rootTypeMirror), WildcardTypeName.subtypeOf(Object.class)})}), (String)"jumpMap", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        String initializerStrings = subClassTypeMirrors.stream().map(typeMirror -> {
            TypeElement typeElement = (TypeElement)typeUtils.asElement((TypeMirror)typeMirror);
            return "Map.entry(" + String.valueOf(typeElement.getSimpleName()) + ".class, (visitor, element) -> visitor." + GenerateVisitorAnnotationHelper.methodNameOfVisitMethod(generateVisitor, typeElement) + "((" + String.valueOf(typeElement.getSimpleName()) + ")element))";
        }).collect(Collectors.joining(", \n"));
        CodeBlock initializerBlock = CodeBlock.builder().add("$T.ofEntries(" + initializerStrings + ")", new Object[]{ClassName.get(Map.class)}).build();
        typeBuilder.addField(jumpMapBuilder.initializer(initializerBlock).build());
        for (TypeMirror typeMirror2 : subClassTypeMirrors) {
            TypeElement typeElement = (TypeElement)typeUtils.asElement(typeMirror2);
            String methodName = GenerateVisitorAnnotationHelper.methodNameOfVisitMethod(generateVisitor, typeElement);
            MethodSpec.Builder specificVisitMethodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Nonnull.class).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)typeMirror2), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build()).returns((TypeName)typeVariableName);
            typeBuilder.addMethod(specificVisitMethodBuilder.build());
        }
        MethodSpec.Builder visitDefaultMethodBuilder = MethodSpec.methodBuilder((String)defaultMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Nonnull.class).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)rootTypeMirror), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build()).returns((TypeName)typeVariableName);
        typeBuilder.addMethod(visitDefaultMethodBuilder.build());
        MethodSpec.Builder visitMethodBuilder = MethodSpec.methodBuilder((String)generateVisitor.methodPrefix()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)rootTypeMirror), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build()).returns((TypeName)typeVariableName).addCode(CodeBlock.builder().addStatement("final var visitFn = jumpMap.get(element.getClass())", new Object[0]).addStatement("return visitFn == null ? visitDefault(element) : (" + String.valueOf(typeVariableName) + ")visitFn.apply(this, element)", new Object[0]).build());
        typeBuilder.addMethod(visitMethodBuilder.build());
        JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeBuilder.build()).skipJavaLangImports(true).build().writeTo(Objects.requireNonNull(filer));
    }

    private static void generateImplementationWithDefaults(@Nonnull Types typeUtils, @Nonnull Filer filer, @Nonnull GenerateVisitor generateVisitor, @Nonnull PackageElement packageElement, @Nonnull List<TypeMirror> subClassTypeMirrors, @Nonnull String className, @Nonnull String interfaceName, @Nonnull TypeVariableName typeVariableName, @Nonnull String defaultMethodName) throws IOException {
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(typeVariableName).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)packageElement.getQualifiedName().toString(), (String)interfaceName, (String[])new String[0]), (TypeName[])new TypeName[]{typeVariableName}));
        for (TypeMirror typeMirror : subClassTypeMirrors) {
            TypeElement typeElement = (TypeElement)typeUtils.asElement(typeMirror);
            String methodName = GenerateVisitorAnnotationHelper.methodNameOfVisitMethod(generateVisitor, typeElement);
            MethodSpec.Builder specificVisitMethodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addAnnotation(Nonnull.class).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)typeMirror), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build()).returns((TypeName)typeVariableName).addCode(CodeBlock.builder().addStatement("return " + defaultMethodName + "(element)", new Object[0]).build());
            typeBuilder.addMethod(specificVisitMethodBuilder.build());
        }
        JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeBuilder.build()).skipJavaLangImports(true).build().writeTo(Objects.requireNonNull(filer));
    }

    private static String methodNameOfVisitMethod(@Nonnull GenerateVisitor generateVisitor, @Nonnull TypeElement typeElement) {
        return generateVisitor.methodPrefix() + typeElement.getSimpleName().toString().replace(generateVisitor.stripPrefix(), "");
    }

    private static boolean isValidClass(TypeElement annotatedClassElement) {
        return annotatedClassElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static void error(Messager messager, Element e, String msg, Object ... args) {
        Objects.requireNonNull(messager).printMessage(Diagnostic.Kind.ERROR, String.format(Locale.ROOT, msg, args), e);
    }
}

