/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.util.LoggableException;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class MoreAsyncUtil {
    private static final Supplier<ScheduledThreadPoolExecutor> scheduledExecutorSupplier = Suppliers.memoize(() -> {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fdb-scheduled-executor-%d").build();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        scheduledThreadPoolExecutor.setKeepAliveTime(30L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        return scheduledThreadPoolExecutor;
    });

    public static <T> CompletableFuture<T> alreadyCancelled() {
        CompletableFuture alreadyCancelled = new CompletableFuture();
        alreadyCancelled.cancel(false);
        return alreadyCancelled;
    }

    @Nonnull
    public static <T> AsyncIterable<T> limitIterable(final @Nonnull AsyncIterable<T> iterable, final int limit) {
        return new AsyncIterable<T>(){

            @Override
            @Nonnull
            public CloseableAsyncIterator<T> iterator() {
                return new CloseableAsyncIterator<T>(){
                    final AsyncIterator<T> iterator;
                    int count;
                    {
                        this.iterator = iterable.iterator();
                        this.count = 0;
                    }

                    @Override
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.count < limit) {
                            return this.iterator.onHasNext();
                        }
                        return AsyncUtil.READY_FALSE;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.count < limit && this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.count;
                        return this.iterator.next();
                    }

                    @Override
                    public void close() {
                        MoreAsyncUtil.closeIterator(this.iterator);
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public CompletableFuture<List<T>> asList() {
                return AsyncUtil.collect(this);
            }
        };
    }

    @Nonnull
    public static <T> AsyncIterable<T> filterIterable(@Nonnull AsyncIterable<T> iterable, @Nonnull Function<T, Boolean> filter) {
        return MoreAsyncUtil.filterIterable(ForkJoinPool.commonPool(), iterable, filter);
    }

    @Nonnull
    public static <T> AsyncIterable<T> filterIterable(final @Nonnull Executor executor, final @Nonnull AsyncIterable<T> iterable, final @Nonnull Function<T, Boolean> filter) {
        return new AsyncIterable<T>(){

            @Override
            @Nonnull
            public CloseableAsyncIterator<T> iterator() {
                return new CloseableAsyncIterator<T>(){
                    final AsyncIterator<T> iterator;
                    T next;
                    boolean haveNext;
                    @Nullable
                    CompletableFuture<Boolean> nextFuture;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    @Nonnull
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.nextFuture != null) {
                            return this.nextFuture;
                        }
                        if (this.haveNext) {
                            return AsyncUtil.READY_TRUE;
                        }
                        this.nextFuture = AsyncUtil.whileTrue(() -> this.iterator.onHasNext().thenApply(hasNext -> {
                            if (!hasNext.booleanValue()) {
                                return false;
                            }
                            this.next = this.iterator.next();
                            this.haveNext = (Boolean)filter.apply(this.next);
                            return !this.haveNext;
                        }), executor).thenApply(v -> this.haveNext);
                        return this.nextFuture;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.nextFuture != null) {
                            this.nextFuture.join();
                            this.nextFuture = null;
                        }
                        while (!this.haveNext && this.iterator.hasNext()) {
                            this.next = this.iterator.next();
                            this.haveNext = (Boolean)filter.apply(this.next);
                        }
                        return this.haveNext;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.haveNext = false;
                        return this.next;
                    }

                    @Override
                    public void close() {
                        if (this.nextFuture != null) {
                            this.nextFuture.cancel(false);
                            this.nextFuture = null;
                        }
                        MoreAsyncUtil.closeIterator(this.iterator);
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public CompletableFuture<List<T>> asList() {
                return AsyncUtil.collect(this, executor);
            }
        };
    }

    @Nonnull
    public static <T> AsyncIterable<T> dedupIterable(@Nonnull AsyncIterable<T> iterable) {
        return MoreAsyncUtil.dedupIterable(ForkJoinPool.commonPool(), iterable);
    }

    @Nonnull
    public static <T> AsyncIterable<T> dedupIterable(@Nonnull Executor executor, @Nonnull AsyncIterable<T> iterable) {
        return MoreAsyncUtil.filterIterable(executor, iterable, new Function<T, Boolean>(){
            private Object lastObj;

            @Override
            @Nonnull
            public Boolean apply(T obj) {
                if (this.lastObj != null && this.lastObj.equals(obj)) {
                    return false;
                }
                this.lastObj = obj;
                return true;
            }
        });
    }

    @Nonnull
    public static <T> AsyncIterable<T> concatIterables(AsyncIterable<T> ... iterables) {
        return MoreAsyncUtil.concatIterables(ForkJoinPool.commonPool(), iterables);
    }

    @Nonnull
    public static <T> AsyncIterable<T> concatIterables(final @Nonnull Executor executor, final AsyncIterable<T> ... iterables) {
        return new AsyncIterable<T>(){

            @Override
            @Nonnull
            public CloseableAsyncIterator<T> iterator() {
                return new CloseableAsyncIterator<T>(){
                    int index = 0;
                    @Nullable
                    AsyncIterator<T> current;
                    AsyncIterator<T> removeFrom;
                    @Nullable
                    CompletableFuture<Boolean> nextFuture;

                    @Override
                    @Nonnull
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.nextFuture != null) {
                            return this.nextFuture;
                        }
                        if (this.index >= iterables.length) {
                            return AsyncUtil.READY_FALSE;
                        }
                        this.nextFuture = AsyncUtil.whileTrue(() -> {
                            if (this.current == null) {
                                this.current = iterables[this.index].iterator();
                            }
                            return this.current.onHasNext().thenApply(hasNext -> {
                                if (hasNext.booleanValue()) {
                                    return false;
                                }
                                this.current = null;
                                return ++this.index < iterables.length;
                            });
                        }, executor).thenApply(v -> this.index < iterables.length);
                        return this.nextFuture;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.nextFuture != null) {
                            this.nextFuture.join();
                            this.nextFuture = null;
                        }
                        while (this.index < iterables.length) {
                            if (this.current == null) {
                                this.current = iterables[this.index].iterator();
                            }
                            if (this.current.hasNext()) {
                                return true;
                            }
                            this.current = null;
                            ++this.index;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.removeFrom = this.current;
                        return this.current.next();
                    }

                    @Override
                    public void close() {
                        if (this.nextFuture != null) {
                            this.nextFuture.cancel(false);
                            this.nextFuture = null;
                        }
                        MoreAsyncUtil.closeIterator(this.current);
                    }

                    @Override
                    public void remove() {
                        if (this.removeFrom == null) {
                            throw new IllegalStateException("Nothing to remove");
                        }
                        this.removeFrom.remove();
                        this.removeFrom = null;
                    }
                };
            }

            @Override
            public CompletableFuture<List<T>> asList() {
                if (iterables.length == 0) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                if (iterables.length == 1) {
                    return iterables[0].asList();
                }
                final ArrayList result = new ArrayList();
                return AsyncUtil.tag(AsyncUtil.whileTrue(new Supplier<CompletableFuture<Boolean>>(){
                    int index = 0;

                    @Override
                    public CompletableFuture<Boolean> get() {
                        return iterables[this.index++].asList().thenApply(asList -> {
                            result.addAll(asList);
                            return this.index < iterables.length;
                        });
                    }
                }, executor), result);
            }
        };
    }

    @Nonnull
    public static <T1, T2> AsyncIterable<T2> mapConcatIterable(@Nonnull AsyncIterable<T1> iterable, @Nonnull Function<T1, AsyncIterable<T2>> func, int pipelineSize) {
        return MoreAsyncUtil.mapConcatIterable(ForkJoinPool.commonPool(), iterable, func, pipelineSize);
    }

    @Nonnull
    public static <T1, T2> AsyncIterable<T2> mapConcatIterable(final @Nonnull Executor executor, final @Nonnull AsyncIterable<T1> iterable, final @Nonnull Function<T1, AsyncIterable<T2>> func, final int pipelineSize) {
        return new AsyncIterable<T2>(){

            @Override
            @Nonnull
            public CloseableAsyncIterator<T2> iterator() {
                CloseableAsyncIterator it = new CloseableAsyncIterator<T2>(){
                    final AsyncIterator<T1> iterator;
                    final Queue<AsyncIterator<T2>> pipeline;
                    @Nullable
                    AsyncIterator<T2> removeFrom;
                    @Nullable
                    CompletableFuture<Boolean> nextFuture;
                    {
                        this.iterator = iterable.iterator();
                        this.pipeline = new ArrayDeque(pipelineSize);
                    }

                    @Override
                    @Nonnull
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.nextFuture != null) {
                            return this.nextFuture;
                        }
                        this.nextFuture = AsyncUtil.whileTrue(() -> {
                            AsyncIterator current;
                            ArrayList<CompletableFuture<Boolean>> waitOn = new ArrayList<CompletableFuture<Boolean>>(2);
                            CompletableFuture<Boolean> outer = this.iterator.onHasNext();
                            if (MoreAsyncUtil.isCompletedNormally(outer)) {
                                if (outer.getNow(false).booleanValue() && this.pipeline.size() < pipelineSize) {
                                    Iterator next = ((AsyncIterable)func.apply(this.iterator.next())).iterator();
                                    this.pipeline.add((AsyncIterator)next);
                                    next.onHasNext();
                                    return AsyncUtil.READY_TRUE;
                                }
                            } else {
                                waitOn.add(outer);
                            }
                            if ((current = this.pipeline.peek()) != null) {
                                CompletableFuture<Boolean> inner = current.onHasNext();
                                if (MoreAsyncUtil.isCompletedNormally(inner)) {
                                    if (inner.getNow(false).booleanValue()) {
                                        return AsyncUtil.READY_FALSE;
                                    }
                                    this.pipeline.remove();
                                    return AsyncUtil.READY_TRUE;
                                }
                                waitOn.add(inner);
                            }
                            if (waitOn.size() == 1) {
                                return ((CompletableFuture)waitOn.get(0)).thenApply((Function)new AlwaysTrue());
                            }
                            return AsyncUtil.whenAny(waitOn).thenApply((Function)new AlwaysTrue());
                        }, executor).thenApply(v -> !this.pipeline.isEmpty());
                        return this.nextFuture;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.onHasNext().join();
                    }

                    @Override
                    public T2 next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.nextFuture = null;
                        AsyncIterator current = this.pipeline.peek();
                        this.removeFrom = current;
                        return current.next();
                    }

                    @Override
                    public void close() {
                        if (this.nextFuture != null) {
                            this.nextFuture.cancel(false);
                            this.nextFuture = null;
                        }
                        for (AsyncIterator asyncIterator : this.pipeline) {
                            MoreAsyncUtil.closeIterator(asyncIterator);
                        }
                        MoreAsyncUtil.closeIterator(this.iterator);
                    }

                    @Override
                    public void remove() {
                        if (this.removeFrom == null) {
                            throw new IllegalStateException("Nothing to remove");
                        }
                        this.removeFrom.remove();
                        this.removeFrom = null;
                    }
                };
                it.onHasNext();
                return it;
            }

            @Override
            public CompletableFuture<List<T2>> asList() {
                final ArrayList result = new ArrayList();
                return AsyncUtil.tag(AsyncUtil.whileTrue(new Supplier<CompletableFuture<Boolean>>(){
                    final AsyncIterator<T1> iterator;
                    boolean more;
                    {
                        this.iterator = iterable.iterator();
                        this.more = false;
                    }

                    @Override
                    public CompletableFuture<Boolean> get() {
                        if (this.more) {
                            this.more = false;
                            return ((AsyncIterable)func.apply(this.iterator.next())).asList().thenApply(items -> {
                                result.addAll(items);
                                return true;
                            });
                        }
                        this.more = true;
                        return this.iterator.onHasNext();
                    }
                }, executor), result);
            }
        };
    }

    @Nonnull
    static <T> AsyncIterable<T> filterToIterable(final T item, final @Nonnull Function<T, CompletableFuture<Boolean>> filter) {
        return new AsyncIterable<T>(){

            @Override
            @Nullable
            public CloseableAsyncIterator<T> iterator() {
                return new CloseableAsyncIterator<T>(){
                    boolean used = false;
                    @Nullable
                    CompletableFuture<Boolean> nextFuture;

                    @Override
                    @Nullable
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.used) {
                            return AsyncUtil.READY_FALSE;
                        }
                        if (this.nextFuture == null) {
                            this.nextFuture = (CompletableFuture)filter.apply(item);
                        }
                        return this.nextFuture;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.used) {
                            return false;
                        }
                        if (this.nextFuture != null) {
                            return this.nextFuture.join();
                        }
                        return (Boolean)((CompletableFuture)filter.apply(item)).join();
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.used = true;
                        return item;
                    }

                    @Override
                    public void close() {
                        if (this.nextFuture != null) {
                            this.nextFuture.cancel(false);
                            this.nextFuture = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public CompletableFuture<List<T>> asList() {
                return ((CompletableFuture)filter.apply(item)).thenApply(match -> match != false ? Collections.singletonList(item) : Collections.emptyList());
            }
        };
    }

    @Nonnull
    public static <T> AsyncIterable<T> filterIterablePipelined(@Nonnull AsyncIterable<T> iterable, @Nonnull Function<T, CompletableFuture<Boolean>> filter, int pipelineSize) {
        return MoreAsyncUtil.filterIterablePipelined(ForkJoinPool.commonPool(), iterable, filter, pipelineSize);
    }

    @Nonnull
    public static <T> AsyncIterable<T> filterIterablePipelined(@Nonnull Executor executor, @Nonnull AsyncIterable<T> iterable, @Nonnull Function<T, CompletableFuture<Boolean>> filter, int pipelineSize) {
        return MoreAsyncUtil.mapConcatIterable(iterable, item -> MoreAsyncUtil.filterToIterable(item, filter), pipelineSize);
    }

    @Nonnull
    static <T1, T2> AsyncIterable<T2> mapToIterable(final T1 item, final @Nonnull Function<T1, CompletableFuture<T2>> func) {
        return new AsyncIterable<T2>(){

            @Override
            @Nullable
            public CloseableAsyncIterator<T2> iterator() {
                return new CloseableAsyncIterator<T2>(){
                    T2 result;
                    boolean used = false;
                    @Nullable
                    CompletableFuture<Boolean> nextFuture;

                    @Override
                    @Nullable
                    public CompletableFuture<Boolean> onHasNext() {
                        if (this.used) {
                            return AsyncUtil.READY_FALSE;
                        }
                        if (this.nextFuture == null) {
                            this.nextFuture = ((CompletableFuture)func.apply(item)).thenApply(r -> {
                                this.result = r;
                                return true;
                            });
                        }
                        return this.nextFuture;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.used;
                    }

                    @Override
                    public T2 next() {
                        if (this.used) {
                            throw new NoSuchElementException();
                        }
                        if (this.nextFuture != null) {
                            this.nextFuture.join();
                        } else {
                            this.result = ((CompletableFuture)func.apply(item)).join();
                        }
                        this.used = true;
                        return this.result;
                    }

                    @Override
                    public void close() {
                        if (this.nextFuture != null) {
                            this.nextFuture.cancel(false);
                            this.nextFuture = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public CompletableFuture<List<T2>> asList() {
                return ((CompletableFuture)func.apply(item)).thenApply(result -> Collections.singletonList(result));
            }
        };
    }

    @Nonnull
    public static <T1, T2> AsyncIterable<T2> mapIterablePipelined(@Nonnull AsyncIterable<T1> iterable, @Nonnull Function<T1, CompletableFuture<T2>> func, int pipelineSize) {
        return MoreAsyncUtil.mapConcatIterable(iterable, item -> MoreAsyncUtil.mapToIterable(item, func), pipelineSize);
    }

    @Nullable
    public static <U, T> CompletableFuture<U> reduce(@Nonnull AsyncIterator<T> iterator, U identity, BiFunction<U, ? super T, U> accumulator) {
        return MoreAsyncUtil.reduce(ForkJoinPool.commonPool(), iterator, identity, accumulator);
    }

    @Nullable
    public static <U, T> CompletableFuture<U> reduce(@Nonnull Executor executor, @Nonnull AsyncIterator<T> iterator, U identity, BiFunction<U, ? super T, U> accumulator) {
        Holder<U> holder = new Holder<U>(identity);
        return AsyncUtil.whileTrue(() -> iterator.onHasNext().thenApply(hasNext -> {
            if (hasNext.booleanValue()) {
                holder.value = accumulator.apply((Object)holder.value, (Object)iterator.next());
            }
            return hasNext;
        }), executor).thenApply(vignore -> holder.value);
    }

    @API(value=API.Status.UNSTABLE)
    public static boolean isCompletedNormally(@Nonnull CompletableFuture<?> future) {
        return future.isDone() && !future.isCompletedExceptionally();
    }

    @Nonnull
    public static ScheduledExecutorService getDefaultScheduledExecutor() {
        return scheduledExecutorSupplier.get();
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public static CompletableFuture<Void> delayedFuture(long delay, @Nonnull TimeUnit unit) {
        return MoreAsyncUtil.delayedFuture(delay, unit, MoreAsyncUtil.getDefaultScheduledExecutor());
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    public static CompletableFuture<Void> delayedFuture(long delay, @Nonnull TimeUnit unit, @Nonnull ScheduledExecutorService scheduledExecutor) {
        if (delay <= 0L) {
            return AsyncUtil.DONE;
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        scheduledExecutor.schedule(() -> future.complete(null), delay, unit);
        return future;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static <T> CompletableFuture<T> getWithDeadline(long deadlineTimeMillis, @Nonnull Supplier<CompletableFuture<T>> supplier, @Nonnull ScheduledExecutorService scheduledExecutor) {
        CompletableFuture valueFuture = supplier.get();
        if (deadlineTimeMillis == Long.MAX_VALUE) {
            return valueFuture;
        }
        return CompletableFuture.anyOf(MoreAsyncUtil.delayedFuture(deadlineTimeMillis, TimeUnit.MILLISECONDS, scheduledExecutor), valueFuture).thenCompose(ignore -> {
            if (!valueFuture.isDone()) {
                valueFuture.completeExceptionally(new DeadlineExceededException(deadlineTimeMillis));
            }
            return valueFuture;
        });
    }

    @API(value=API.Status.UNSTABLE)
    public static void closeIterator(@Nonnull Iterator<?> iterator) {
        if (iterator instanceof CloseableAsyncIterator) {
            ((CloseableAsyncIterator)iterator).close();
        } else if (iterator instanceof AsyncIterator) {
            ((AsyncIterator)iterator).cancel();
        } else if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public static <V> CompletableFuture<V> composeWhenComplete(@Nonnull CompletableFuture<V> future, @Nonnull BiFunction<V, Throwable, CompletableFuture<Void>> handler, @Nullable Function<Throwable, RuntimeException> exceptionMapper) {
        return MoreAsyncUtil.composeWhenCompleteAndHandle(future, (result, exception) -> ((CompletableFuture)handler.apply((Object)result, (Throwable)exception)).thenApply(vignore -> result), exceptionMapper);
    }

    public static <V, T> CompletableFuture<T> composeWhenCompleteAndHandle(@Nonnull CompletableFuture<V> future, @Nonnull BiFunction<V, Throwable, ? extends CompletableFuture<T>> handler, @Nullable Function<Throwable, RuntimeException> exceptionMapper) {
        return AsyncUtil.composeHandle(future, (futureResult, futureException) -> {
            try {
                return ((CompletableFuture)handler.apply((Object)futureResult, (Throwable)futureException)).handle((handlerResult, handlerAsyncException) -> {
                    if (futureException != null) {
                        throw MoreAsyncUtil.getRuntimeException(futureException, exceptionMapper);
                    }
                    if (handlerAsyncException != null) {
                        throw MoreAsyncUtil.getRuntimeException(handlerAsyncException, exceptionMapper);
                    }
                    return handlerResult;
                });
            }
            catch (Exception handlerSyncException) {
                throw MoreAsyncUtil.getRuntimeException(handlerSyncException, exceptionMapper);
            }
        });
    }

    public static <V> CompletableFuture<V> handleOnException(Supplier<CompletableFuture<V>> futureSupplier, Function<Throwable, CompletableFuture<V>> handlerOnException) {
        try {
            return AsyncUtil.composeHandle(futureSupplier.get(), (futureResult, futureException) -> {
                if (futureException != null) {
                    return (CompletableFuture)handlerOnException.apply((Throwable)futureException);
                }
                return CompletableFuture.completedFuture(futureResult);
            });
        }
        catch (Exception e) {
            return handlerOnException.apply(e);
        }
    }

    private static RuntimeException getRuntimeException(@Nonnull Throwable exception, @Nullable Function<Throwable, RuntimeException> exceptionMapper) {
        return exceptionMapper == null ? new RuntimeException(exception) : exceptionMapper.apply(exception);
    }

    public static <T, U, R> CompletableFuture<R> combineAndFailFast(CompletableFuture<T> future1, CompletableFuture<U> future2, BiFunction<T, U, R> combiner) {
        return CompletableFuture.anyOf(future1, future2).thenCompose(vignore -> future1.thenCombine((CompletionStage)future2, combiner));
    }

    public static CompletableFuture<Void> swallowException(@Nonnull CompletableFuture<Void> future, @Nonnull Predicate<Throwable> shouldSwallow) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        future.whenComplete((vignore, err) -> {
            if (err == null || shouldSwallow.test((Throwable)err) || err instanceof CompletionException && err.getCause() != null && shouldSwallow.test(err.getCause())) {
                result.complete(null);
            } else {
                result.completeExceptionally((Throwable)err);
            }
        });
        return result;
    }

    private MoreAsyncUtil() {
    }

    public static class Holder<T> {
        public T value;

        public Holder(T value) {
            this.value = value;
        }
    }

    public static class DeadlineExceededException
    extends LoggableException {
        private DeadlineExceededException(long deadlineTimeMillis) {
            super("deadline exceeded");
            this.addLogInfo("deadlineTimeMillis", (Object)deadlineTimeMillis);
        }
    }

    public static class AlwaysTrue<T>
    implements Function<T, Boolean> {
        @Override
        @Nonnull
        public Boolean apply(T t2) {
            return true;
        }
    }
}

