/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RangeSet {
    @Nonnull
    private Subspace subspace;
    @Nonnull
    private static final byte[] FIRST_KEY = new byte[]{0};
    @Nonnull
    private static final byte[] FINAL_KEY = new byte[]{-1};
    private static final Range COMPLETE_RANGE = new Range(FIRST_KEY, FINAL_KEY);
    public static final int UNLIMITED = Integer.MAX_VALUE;

    public RangeSet(@Nonnull Subspace subspace) {
        this.subspace = subspace;
    }

    private static void checkKey(@Nonnull byte[] key) {
        if (key.length == 0 || ByteArrayUtil.compareUnsigned(key, FINAL_KEY) >= 0) {
            throw new IllegalArgumentException("Key " + ByteArrayUtil.printable(key) + " outside of accepted key range of [\\x00,\\xff)");
        }
    }

    private static void checkRange(@Nonnull byte[] begin, @Nonnull byte[] end) {
        if (ByteArrayUtil.compareUnsigned(begin, end) > 0) {
            throw new IllegalArgumentException("Inverted range; " + ByteArrayUtil.printable(begin) + " is greater than " + ByteArrayUtil.printable(end));
        }
    }

    public static boolean isFirstKey(@Nonnull byte[] key) {
        return Arrays.equals(key, FIRST_KEY);
    }

    public static boolean isFinalKey(@Nonnull byte[] key) {
        return Arrays.equals(key, FINAL_KEY);
    }

    @Nonnull
    private byte[] keyAfter(@Nonnull byte[] key) {
        byte[] ret = new byte[key.length + 1];
        System.arraycopy(key, 0, ret, 0, key.length);
        ret[key.length] = 0;
        return ret;
    }

    @Nonnull
    public CompletableFuture<Boolean> contains(@Nonnull TransactionContext tc, @Nonnull byte[] key) {
        RangeSet.checkKey(key);
        return tc.runAsync(tr -> {
            byte[] frobnicated = this.subspace.pack(key);
            tr.addReadConflictKey(frobnicated);
            Iterator iterator = tr.snapshot().getRange(this.subspace.range().begin, this.keyAfter(frobnicated), 1, true).iterator();
            return iterator.onHasNext().thenApply(arg_0 -> RangeSet.lambda$contains$0((AsyncIterator)iterator, key, arg_0));
        });
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRange(@Nonnull TransactionContext tc, @Nonnull Range r) {
        return this.insertRange(tc, r.begin, r.end);
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRange(@Nonnull TransactionContext tc, @Nonnull Range r, boolean requireEmpty) {
        return this.insertRange(tc, r.begin, r.end, requireEmpty);
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRange(@Nonnull TransactionContext tc, @Nullable byte[] begin, @Nullable byte[] end) {
        return this.insertRange(tc, begin, end, false);
    }

    @Nonnull
    public CompletableFuture<Boolean> insertRange(@Nonnull TransactionContext tc, @Nullable byte[] begin, @Nullable byte[] end, boolean requireEmpty) {
        byte[] beginNonNull = begin == null ? FIRST_KEY : begin;
        byte[] endNonNull = end == null ? FINAL_KEY : end;
        RangeSet.checkKey(beginNonNull);
        RangeSet.checkRange(beginNonNull, endNonNull);
        if (ByteArrayUtil.compareUnsigned(beginNonNull, endNonNull) == 0) {
            return AsyncUtil.READY_FALSE;
        }
        return tc.runAsync(tr -> {
            byte[] frobnicatedBegin = this.subspace.pack(beginNonNull);
            byte[] frobnicatedEnd = this.subspace.pack(endNonNull);
            tr.addReadConflictRange(frobnicatedBegin, frobnicatedEnd);
            byte[] keyAfterBegin = this.keyAfter(frobnicatedBegin);
            ReadTransaction snapshot = tr.snapshot();
            Iterator beforeIterator = snapshot.getRange(this.subspace.range().begin, keyAfterBegin, 1, true).iterator();
            Iterator afterIterator = snapshot.getRange(keyAfterBegin, frobnicatedEnd, requireEmpty ? 1 : 0, false).iterator();
            return beforeIterator.onHasNext().thenCompose(arg_0 -> this.lambda$insertRange$5(frobnicatedBegin, (AsyncIterator)beforeIterator, beginNonNull, requireEmpty, (AsyncIterator)afterIterator, tr, endNonNull, frobnicatedEnd, tc, arg_0));
        });
    }

    @Nonnull
    public CompletableFuture<List<Range>> missingRanges(@Nonnull ReadTransactionContext tc) {
        return tc.readAsync(tr -> {
            AsyncIterable<Range> ranges = this.missingRanges((ReadTransaction)tr);
            return ranges.asList();
        });
    }

    @Nonnull
    public AsyncIterable<Range> missingRanges(@Nonnull ReadTransaction tr) {
        return this.missingRanges(tr, null, null);
    }

    @Nonnull
    public CompletableFuture<List<Range>> missingRanges(@Nonnull ReadTransactionContext tc, @Nonnull Range superRange) {
        return tc.readAsync(tr -> {
            AsyncIterable<Range> ranges = this.missingRanges((ReadTransaction)tr, superRange);
            return ranges.asList();
        });
    }

    @Nonnull
    public AsyncIterable<Range> missingRanges(@Nonnull ReadTransaction tr, @Nonnull Range superRange) {
        return this.missingRanges(tr, superRange.begin, superRange.end);
    }

    @Nonnull
    public CompletableFuture<List<Range>> missingRanges(@Nonnull ReadTransactionContext tc, @Nullable byte[] begin, @Nullable byte[] end) {
        return tc.readAsync(tr -> {
            AsyncIterable<Range> ranges = this.missingRanges((ReadTransaction)tr, begin, end);
            return ranges.asList();
        });
    }

    @Nonnull
    public AsyncIterable<Range> missingRanges(@Nonnull ReadTransaction tr, @Nullable byte[] begin, @Nullable byte[] end) {
        return this.missingRanges(tr, begin, end, Integer.MAX_VALUE);
    }

    @Nonnull
    public CompletableFuture<List<Range>> missingRanges(@Nonnull ReadTransactionContext tc, @Nullable byte[] begin, @Nullable byte[] end, int limit) {
        return tc.readAsync(tr -> {
            AsyncIterable<Range> ranges = this.missingRanges((ReadTransaction)tr, begin, end, limit);
            return ranges.asList();
        });
    }

    @Nonnull
    public AsyncIterable<Range> missingRanges(final @Nonnull ReadTransaction tr, @Nullable byte[] begin, @Nullable byte[] end, final int limit) {
        final byte[] beginNonNull = begin == null ? FIRST_KEY : begin;
        final byte[] endNonNull = end == null ? FINAL_KEY : end;
        RangeSet.checkKey(beginNonNull);
        RangeSet.checkRange(beginNonNull, endNonNull);
        return new AsyncIterable<Range>(){

            @Override
            public AsyncIterator<Range> iterator() {
                return new MissingRangeIterator(tr, beginNonNull, endNonNull, limit);
            }

            @Override
            public CompletableFuture<List<Range>> asList() {
                return AsyncUtil.collect(this);
            }
        };
    }

    public CompletableFuture<Boolean> isEmpty(@Nonnull ReadTransactionContext rtc) {
        return rtc.readAsync(this::isEmpty);
    }

    public CompletableFuture<Boolean> isEmpty(@Nonnull ReadTransaction rtr) {
        Iterator missing = this.missingRanges(rtr, null, null, 1).iterator();
        return missing.onHasNext().thenApply(arg_0 -> RangeSet.lambda$isEmpty$11((AsyncIterator)missing, arg_0));
    }

    public void clear(@Nonnull Transaction tr) {
        tr.clear(this.subspace.range());
    }

    @Nonnull
    public CompletableFuture<Void> clear(@Nonnull TransactionContext tc) {
        return tc.runAsync(tr -> {
            this.clear((Transaction)tr);
            return AsyncUtil.DONE;
        });
    }

    @Nonnull
    public CompletableFuture<String> rep(@Nonnull ReadTransactionContext tc) {
        return tc.readAsync(tr -> {
            StringBuilder sb = new StringBuilder();
            AsyncIterable<KeyValue> iterable = tr.getRange(this.subspace.range());
            return iterable.asList().thenApply(list -> {
                for (KeyValue kv : list) {
                    byte[] key = this.subspace.unpack(kv.getKey()).getBytes(0);
                    byte[] value = kv.getValue();
                    sb.append(ByteArrayUtil.printable(key));
                    sb.append(" -> ");
                    sb.append(ByteArrayUtil.printable(value));
                    sb.append('\n');
                }
                return sb.toString();
            });
        });
    }

    private static /* synthetic */ Boolean lambda$isEmpty$11(AsyncIterator missing, Boolean doesHaveNext) {
        if (doesHaveNext.booleanValue()) {
            Range firstMissing = (Range)missing.next();
            return firstMissing.equals(COMPLETE_RANGE);
        }
        return false;
    }

    private /* synthetic */ CompletionStage lambda$insertRange$5(byte[] frobnicatedBegin, AsyncIterator beforeIterator, byte[] beginNonNull, boolean requireEmpty, AsyncIterator afterIterator, Transaction tr, byte[] endNonNull, byte[] frobnicatedEnd, TransactionContext tc, Boolean hasBefore) {
        byte[] beforeEnd;
        KeyValue before;
        AtomicReference<byte[]> lastSeen = new AtomicReference<byte[]>(frobnicatedBegin);
        KeyValue keyValue = before = hasBefore != false ? (KeyValue)beforeIterator.next() : null;
        if (hasBefore.booleanValue() && ByteArrayUtil.compareUnsigned(beginNonNull, beforeEnd = before.getValue()) < 0) {
            if (requireEmpty) {
                return AsyncUtil.READY_FALSE;
            }
            lastSeen.set(this.subspace.pack(beforeEnd));
        }
        if (requireEmpty) {
            return afterIterator.onHasNext().thenApply(hasNext -> {
                if (hasNext.booleanValue()) {
                    return false;
                }
                if (before != null && ByteArrayUtil.compareUnsigned(beginNonNull, before.getValue()) == 0) {
                    tr.addReadConflictKey(before.getKey());
                    tr.set(before.getKey(), endNonNull);
                } else {
                    tr.set(frobnicatedBegin, endNonNull);
                }
                tr.addWriteConflictRange(frobnicatedBegin, frobnicatedEnd);
                return true;
            });
        }
        AtomicBoolean changed = new AtomicBoolean(false);
        return AsyncUtil.whileTrue(() -> {
            byte[] lastSeenBytes = (byte[])lastSeen.get();
            if (MoreAsyncUtil.isCompletedNormally(afterIterator.onHasNext()) && afterIterator.hasNext()) {
                KeyValue kv = (KeyValue)afterIterator.next();
                if (ByteArrayUtil.compareUnsigned(lastSeenBytes, kv.getKey()) < 0) {
                    tr.set(lastSeenBytes, this.subspace.unpack(kv.getKey()).getBytes(0));
                    tr.addWriteConflictRange(lastSeenBytes, kv.getKey());
                    changed.set(true);
                }
                lastSeen.set(this.subspace.pack(kv.getValue()));
            }
            return afterIterator.onHasNext();
        }, tc.getExecutor()).thenApply(vignore -> {
            byte[] lastSeenBytes = (byte[])lastSeen.get();
            if (ByteArrayUtil.compareUnsigned(lastSeenBytes, frobnicatedEnd) < 0) {
                tr.set(lastSeenBytes, endNonNull);
                tr.addWriteConflictRange(lastSeenBytes, frobnicatedEnd);
                changed.set(true);
            }
            return changed.get();
        });
    }

    private static /* synthetic */ Boolean lambda$contains$0(AsyncIterator iterator, byte[] key, Boolean hasNext) {
        if (!hasNext.booleanValue()) {
            return false;
        }
        byte[] endRange = ((KeyValue)iterator.next()).getValue();
        return ByteArrayUtil.compareUnsigned(key, endRange) < 0;
    }

    private class MissingRangeIterator
    implements CloseableAsyncIterator<Range> {
        @Nonnull
        private final byte[] endNonNull;
        @Nonnull
        private AsyncIterator<KeyValue> before;
        @Nonnull
        private AsyncIterator<KeyValue> after;
        @Nonnull
        private byte[] currBegin;
        @Nullable
        private Range next;
        private boolean found;
        private int limit;
        private int numFound;
        private final Executor executor;
        @Nonnull
        private CompletableFuture<Boolean> nextFuture;

        public MissingRangeIterator(@Nonnull ReadTransaction tr, @Nonnull byte[] beginNonNull, byte[] endNonNull, int limit) {
            this.endNonNull = endNonNull;
            this.numFound = 0;
            this.limit = limit;
            byte[] frobnicatedBegin = RangeSet.this.subspace.pack(beginNonNull);
            byte[] frobnicatedEnd = RangeSet.this.subspace.pack(endNonNull);
            tr.addReadConflictRangeIfNotSnapshot(frobnicatedBegin, frobnicatedEnd);
            this.before = tr.snapshot().getRange(RangeSet.this.subspace.range().begin, RangeSet.this.keyAfter(frobnicatedBegin), 1, true).iterator();
            this.after = tr.snapshot().getRange(RangeSet.this.keyAfter(frobnicatedBegin), frobnicatedEnd).iterator();
            this.next = null;
            this.currBegin = beginNonNull;
            this.found = false;
            this.executor = tr.getExecutor();
            this.nextFuture = ((CompletableFuture)this.before.onHasNext().thenAccept(hasBefore -> {
                byte[] lastEnd;
                if (hasBefore.booleanValue() && ByteArrayUtil.compareUnsigned(beginNonNull, lastEnd = this.before.next().getValue()) < 0) {
                    this.currBegin = lastEnd;
                }
            })).thenCompose(vignore -> this.getNext());
        }

        private CompletableFuture<Boolean> getNext() {
            return AsyncUtil.whileTrue(() -> {
                if (MoreAsyncUtil.isCompletedNormally(this.after.onHasNext())) {
                    if (this.after.hasNext()) {
                        byte[] currBeg = this.currBegin;
                        KeyValue kv = this.after.next();
                        byte[] nextBeg = RangeSet.this.subspace.unpack(kv.getKey()).getBytes(0);
                        if (ByteArrayUtil.compareUnsigned(currBeg, nextBeg) < 0) {
                            this.next = new Range(currBeg, nextBeg);
                            this.found = true;
                        }
                        this.currBegin = kv.getValue();
                        if (this.found) {
                            return AsyncUtil.READY_FALSE;
                        }
                        return this.after.onHasNext();
                    }
                    return AsyncUtil.READY_FALSE;
                }
                return this.after.onHasNext();
            }, this.executor).thenApply(vignore -> {
                if (this.found) {
                    ++this.numFound;
                    return true;
                }
                if (ByteArrayUtil.compareUnsigned(this.currBegin, this.endNonNull) < 0) {
                    this.next = new Range(this.currBegin, this.endNonNull);
                    this.currBegin = this.endNonNull;
                    return true;
                }
                this.close();
                return false;
            });
        }

        @Override
        public CompletableFuture<Boolean> onHasNext() {
            return this.nextFuture;
        }

        @Override
        public boolean hasNext() {
            return this.nextFuture.join();
        }

        @Override
        public Range next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Attempted to get next missing range when none were present");
            }
            Range ret = this.next;
            this.found = false;
            if (this.limit == Integer.MAX_VALUE || this.numFound < this.limit) {
                this.nextFuture = this.getNext();
            } else {
                this.close();
                this.nextFuture = AsyncUtil.READY_FALSE;
            }
            return ret;
        }

        @Override
        public void close() {
            MoreAsyncUtil.closeIterator(this.before);
            MoreAsyncUtil.closeIterator(this.after);
        }
    }
}

