/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.CRC32;

@API(value=API.Status.UNSTABLE)
public class RankedSet {
    public static final HashFunction JDK_ARRAY_HASH = Arrays::hashCode;
    public static final HashFunction CRC_HASH = key -> {
        CRC32 crc = new CRC32();
        crc.update(key);
        return (int)crc.getValue();
    };
    public static final HashFunction RANDOM_HASH = kignore -> ThreadLocalRandom.current().nextInt();
    public static final HashFunction DEFAULT_HASH_FUNCTION = JDK_ARRAY_HASH;
    private static final int LEVEL_FAN_POW = 4;
    private static final int[] LEVEL_FAN_VALUES;
    public static final int MAX_LEVELS = 8;
    public static final int DEFAULT_LEVELS = 6;
    public static final Config DEFAULT_CONFIG;
    protected final Subspace subspace;
    protected final Executor executor;
    protected final Config config;
    private static final byte[] EMPTY_ARRAY;
    private static final byte[] ZERO_ARRAY;

    private static byte[] encodeLong(long count) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(count).array();
    }

    private static long decodeLong(byte[] v) {
        return ByteBuffer.wrap(v).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static ConfigBuilder newConfigBuilder() {
        return new ConfigBuilder();
    }

    public RankedSet(Subspace subspace, Executor executor, Config config) {
        this.subspace = subspace;
        this.executor = executor;
        this.config = config;
    }

    public RankedSet(Subspace subspace, Executor executor, HashFunction hashFunction, int nlevels) {
        this(subspace, executor, RankedSet.newConfigBuilder().setHashFunction(hashFunction).setNLevels(nlevels).build());
    }

    public RankedSet(Subspace subspace, Executor executor, int nlevels) {
        this(subspace, executor, RankedSet.newConfigBuilder().setNLevels(nlevels).build());
    }

    public RankedSet(Subspace subspace, Executor executor) {
        this(subspace, executor, DEFAULT_CONFIG);
    }

    public CompletableFuture<Void> init(TransactionContext tc) {
        return this.initLevels(tc);
    }

    public CompletableFuture<Boolean> initNeeded(ReadTransactionContext tc) {
        return this.countCheckedKey(tc, EMPTY_ARRAY).thenApply(Objects::isNull);
    }

    public Subspace getSubspace() {
        return this.subspace;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Config getConfig() {
        return this.config;
    }

    public CompletableFuture<Boolean> add(TransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        int keyHash = this.getKeyHash(key);
        return tc.runAsync(tr -> this.countCheckedKey((ReadTransactionContext)tr, key).thenCompose(count -> {
            boolean duplicate;
            boolean bl = duplicate = count != null && count > 0L;
            if (duplicate && !this.config.isCountDuplicates()) {
                return AsyncUtil.READY_FALSE;
            }
            int nlevels = this.config.getNLevels();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(nlevels);
            for (int li = 0; li < nlevels; ++li) {
                CompletionStage<Void> future;
                int level = li;
                if (level == 0) {
                    future = this.addLevelZeroKey((Transaction)tr, key, level, duplicate);
                } else if (duplicate || (keyHash & LEVEL_FAN_VALUES[level]) != 0) {
                    future = this.addIncrementLevelKey((Transaction)tr, key, level, duplicate);
                } else {
                    future = AsyncUtil.whenAll(futures);
                    futures = new ArrayList(nlevels - li);
                    future = future.thenCompose(vignore -> this.addInsertLevelKey((Transaction)tr, key, level));
                }
                futures.add((CompletableFuture<Void>)future);
            }
            return AsyncUtil.whenAll(futures).thenApply(vignore -> true);
        }));
    }

    protected int getKeyHash(byte[] key) {
        return this.config.getHashFunction().hash(key);
    }

    protected CompletableFuture<Void> addLevelZeroKey(Transaction tr, byte[] key, int level, boolean increment) {
        byte[] k = this.subspace.pack(Tuple.from(level, key));
        byte[] v = RankedSet.encodeLong(1L);
        if (increment) {
            tr.mutate(MutationType.ADD, k, v);
        } else {
            tr.set(k, v);
        }
        return AsyncUtil.DONE;
    }

    protected CompletableFuture<Void> addIncrementLevelKey(Transaction tr, byte[] key, int level, boolean orEqual) {
        return this.getPreviousKey(tr, level, key, orEqual).thenAccept(prevKey -> tr.mutate(MutationType.ADD, this.subspace.pack(Tuple.from(level, prevKey)), RankedSet.encodeLong(1L)));
    }

    protected CompletableFuture<Void> addInsertLevelKey(Transaction tr, byte[] key, int level) {
        return this.getPreviousKey(tr, level, key, false).thenCompose(prevKey -> {
            CompletionStage prevCount = tr.get(this.subspace.pack(Tuple.from(level, prevKey))).thenApply(RankedSet::decodeLong);
            CompletableFuture<Long> newPrevCount = this.countRange(tr, level - 1, (byte[])prevKey, key);
            return ((CompletableFuture)prevCount).thenAcceptBoth(newPrevCount, (prev, newPrev) -> {
                long count = prev - newPrev + 1L;
                tr.set(this.subspace.pack(Tuple.from(level, prevKey)), RankedSet.encodeLong(newPrev));
                tr.set(this.subspace.pack(Tuple.from(level, key)), RankedSet.encodeLong(count));
            });
        });
    }

    public CompletableFuture<Boolean> remove(TransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        return tc.runAsync(tr -> this.countCheckedKey((ReadTransactionContext)tr, key).thenCompose(count -> {
            if (count == null || count <= 0L) {
                return AsyncUtil.READY_FALSE;
            }
            boolean duplicate = count > 1L;
            int nlevels = this.config.getNLevels();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(nlevels);
            for (int li = 0; li < nlevels; ++li) {
                CompletionStage<Void> future;
                int level = li;
                if (duplicate) {
                    if (level == 0) {
                        tr.set(this.subspace.pack(Tuple.from(level, key)), RankedSet.encodeLong(count - 1L));
                        future = AsyncUtil.DONE;
                    } else {
                        future = this.getPreviousKey((TransactionContext)tr, level, key, true).thenAccept(k -> tr.mutate(MutationType.ADD, this.subspace.pack(Tuple.from(level, k)), RankedSet.encodeLong(-1L)));
                    }
                } else {
                    byte[] k2 = this.subspace.pack(Tuple.from(level, key));
                    if (level == 0) {
                        tr.clear(k2);
                        future = AsyncUtil.DONE;
                    } else {
                        CompletableFuture<byte[]> cf = tr.get(k2);
                        CompletableFuture<byte[]> prevKeyF = this.getPreviousKey((TransactionContext)tr, level, key, false);
                        future = cf.thenAcceptBoth(prevKeyF, (c, prevKey) -> {
                            long countChange = -1L;
                            if (c != null) {
                                countChange += RankedSet.decodeLong(c);
                                tr.clear(k2);
                            }
                            tr.mutate(MutationType.ADD, this.subspace.pack(Tuple.from(level, prevKey)), RankedSet.encodeLong(countChange));
                        });
                    }
                }
                futures.add((CompletableFuture<Void>)future);
            }
            return AsyncUtil.whenAll(futures).thenApply(vignore -> true);
        }));
    }

    public CompletableFuture<Void> clear(TransactionContext tc) {
        Range range = this.subspace.range();
        return tc.runAsync(tr -> {
            tr.clear(range);
            return this.initLevels((TransactionContext)tr);
        });
    }

    public CompletableFuture<Boolean> contains(ReadTransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        return this.countCheckedKey(tc, key).thenApply(c -> c != null && c > 0L);
    }

    public CompletableFuture<Long> count(ReadTransactionContext tc, byte[] key) {
        RankedSet.checkKey(key);
        return this.countCheckedKey(tc, key).thenApply(c -> c == null ? Long.valueOf(0L) : c);
    }

    private CompletableFuture<Long> countCheckedKey(ReadTransactionContext tc, byte[] key) {
        return tc.readAsync(tr -> tr.get(this.subspace.pack(Tuple.from(0, key))).thenApply(b -> b == null ? null : Long.valueOf(RankedSet.decodeLong(b))));
    }

    public CompletableFuture<byte[]> getNth(ReadTransactionContext tc, long rank) {
        if (rank < 0L) {
            return CompletableFuture.completedFuture(null);
        }
        return tc.readAsync(tr -> {
            NthLookup nth = new NthLookup(rank);
            return AsyncUtil.whileTrue(() -> this.nextLookup(nth, (ReadTransaction)tr), this.executor).thenApply(vignore -> nth.getKey());
        });
    }

    public List<byte[]> getRangeList(ReadTransactionContext tc, byte[] beginKey, byte[] endKey) {
        return tc.read(tr -> this.getRange((ReadTransaction)tr, beginKey, endKey).asList().join());
    }

    public AsyncIterable<byte[]> getRange(ReadTransaction tr, byte[] beginKey, byte[] endKey) {
        RankedSet.checkKey(beginKey);
        return AsyncUtil.mapIterable(tr.getRange(this.subspace.pack(Tuple.from(0, beginKey)), this.subspace.pack(Tuple.from(0, endKey))), keyValue -> {
            Tuple t2 = this.subspace.unpack(keyValue.getKey());
            return t2.getBytes(1);
        });
    }

    public CompletableFuture<Void> preloadForLookup(ReadTransaction tr) {
        return tr.getRange(this.subspace.range(), this.config.getNLevels(), true).asList().thenApply(l -> null);
    }

    protected CompletableFuture<Boolean> nextLookup(Lookup lookup, ReadTransaction tr) {
        return lookup.next(tr);
    }

    protected <T> AsyncIterator<T> lookupIterator(AsyncIterable<T> iterable) {
        return iterable.iterator();
    }

    protected void nextLookupKey(long duration, boolean newIter, boolean hasNext, int level, boolean rankLookup) {
    }

    public CompletableFuture<Long> rank(ReadTransactionContext tc, byte[] key) {
        return this.rank(tc, key, true);
    }

    public CompletableFuture<Long> rank(ReadTransactionContext tc, byte[] key, boolean nullIfMissing) {
        RankedSet.checkKey(key);
        return tc.readAsync(tr -> {
            if (nullIfMissing) {
                return this.countCheckedKey((ReadTransactionContext)tr, key).thenCompose(count -> {
                    if (count == null || count <= 0L) {
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.rankLookup((ReadTransaction)tr, key, true);
                });
            }
            return this.rankLookup((ReadTransaction)tr, key, false);
        });
    }

    private CompletableFuture<Long> rankLookup(ReadTransaction tr, byte[] key, boolean keyShouldBePresent) {
        RankLookup rank = new RankLookup(key, keyShouldBePresent);
        return AsyncUtil.whileTrue(() -> this.nextLookup(rank, tr), this.executor).thenApply(vignore -> rank.getRank());
    }

    public CompletableFuture<Long> size(ReadTransactionContext tc) {
        Range r = this.subspace.get(this.config.getNLevels() - 1).range();
        return tc.readAsync(tr -> AsyncUtil.mapIterable(tr.getRange(r), keyValue -> RankedSet.decodeLong(keyValue.getValue())).asList().thenApply(longs -> longs.stream().reduce(0L, Long::sum)));
    }

    protected Consistency checkConsistency(ReadTransactionContext tc) {
        return tc.read(tr -> {
            int nlevels = this.config.getNLevels();
            block0: for (int level = 1; level < nlevels; ++level) {
                byte[] prevKey = null;
                long prevCount = 0L;
                Iterator it = tr.getRange(this.subspace.range(Tuple.from(level))).iterator();
                while (true) {
                    long count;
                    byte[] nextKey;
                    boolean more;
                    KeyValue kv = (more = it.hasNext()) ? (KeyValue)it.next() : null;
                    byte[] byArray = nextKey = kv == null ? null : this.subspace.unpack(kv.getKey()).getBytes(1);
                    if (prevKey != null && prevCount != (count = this.countRange((ReadTransactionContext)tr, level - 1, prevKey, nextKey).join().longValue())) {
                        return new Consistency(level, prevCount, count, this.toDebugString(tc));
                    }
                    if (!more) continue block0;
                    prevKey = nextKey;
                    prevCount = RankedSet.decodeLong(kv.getValue());
                }
            }
            return new Consistency();
        });
    }

    protected String toDebugString(ReadTransactionContext tc) {
        return tc.read(tr -> {
            StringBuilder str = new StringBuilder();
            int nlevels = this.config.getNLevels();
            for (int level = 0; level < nlevels; ++level) {
                if (level > 0) {
                    str.setLength(str.length() - 2);
                    str.append("\n");
                }
                str.append("L").append(level).append(": ");
                for (KeyValue kv : tr.getRange(this.subspace.range(Tuple.from(level)))) {
                    byte[] key = this.subspace.unpack(kv.getKey()).getBytes(1);
                    long count = RankedSet.decodeLong(kv.getValue());
                    str.append("'").append(ByteArrayUtil2.loggable(key)).append("': ").append(count).append(", ");
                }
            }
            return str.toString();
        });
    }

    private static void checkKey(byte[] key) {
        if (key.length == 0) {
            throw new IllegalArgumentException("Empty key not allowed");
        }
    }

    private CompletableFuture<Long> countRange(ReadTransactionContext tc, int level, byte[] beginKey, byte[] endKey) {
        return tc.readAsync(tr -> AsyncUtil.mapIterable(tr.getRange(beginKey == null ? this.subspace.range((Tuple)Tuple.from((Object[])new Object[]{Integer.valueOf((int)level)})).begin : this.subspace.pack(Tuple.from(level, beginKey)), endKey == null ? this.subspace.range((Tuple)Tuple.from((Object[])new Object[]{Integer.valueOf((int)level)})).end : this.subspace.pack(Tuple.from(level, endKey))), keyValue -> RankedSet.decodeLong(keyValue.getValue())).asList().thenApply(longs -> longs.stream().reduce(0L, Long::sum)));
    }

    private CompletableFuture<byte[]> getPreviousKey(TransactionContext tc, int level, byte[] key, boolean orEqual) {
        byte[] k = this.subspace.pack(Tuple.from(level, key));
        CompletableFuture kf = tc.run(tr -> tr.snapshot().getRange(this.subspace.pack(Tuple.from(level, EMPTY_ARRAY)), orEqual ? ByteArrayUtil.join(k, ZERO_ARRAY) : k, 1, true).asList().thenApply(kvs -> {
            if (kvs.isEmpty()) {
                throw new IllegalStateException("no key found on level");
            }
            byte[] prevk = ((KeyValue)kvs.get(0)).getKey();
            if (!orEqual || !Arrays.equals(prevk, k)) {
                byte[] exclusiveBegin = ByteArrayUtil.join(prevk, ZERO_ARRAY);
                tr.addReadConflictRange(exclusiveBegin, k);
            }
            tr.addReadConflictKey(this.subspace.pack(Tuple.from(0, this.subspace.unpack(prevk).getBytes(1))));
            return prevk;
        }));
        return kf.thenApply(prevk -> this.subspace.unpack((byte[])prevk).getBytes(1));
    }

    private CompletableFuture<Void> initLevels(TransactionContext tc) {
        return tc.runAsync(tr -> {
            int nlevels = this.config.getNLevels();
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(nlevels);
            for (int level = 0; level < nlevels; ++level) {
                byte[] k = this.subspace.pack(Tuple.from(level, EMPTY_ARRAY));
                byte[] v = RankedSet.encodeLong(0L);
                futures.add(tr.get(k).thenAccept(value -> {
                    if (value == null) {
                        tr.set(k, v);
                    }
                }));
            }
            return AsyncUtil.whenAll(futures);
        });
    }

    static {
        DEFAULT_CONFIG = new Config();
        LEVEL_FAN_VALUES = new int[8];
        for (int i = 0; i < 8; ++i) {
            RankedSet.LEVEL_FAN_VALUES[i] = (1 << i * 4) - 1;
        }
        EMPTY_ARRAY = new byte[0];
        ZERO_ARRAY = new byte[]{0};
    }

    public static class ConfigBuilder {
        private HashFunction hashFunction = DEFAULT_HASH_FUNCTION;
        private int nlevels = 6;
        private boolean countDuplicates = false;

        protected ConfigBuilder() {
        }

        protected ConfigBuilder(HashFunction hashFunction, int nlevels, boolean countDuplicates) {
            this.hashFunction = hashFunction;
            this.nlevels = nlevels;
            this.countDuplicates = countDuplicates;
        }

        public HashFunction getHashFunction() {
            return this.hashFunction;
        }

        public ConfigBuilder setHashFunction(HashFunction hashFunction) {
            this.hashFunction = hashFunction;
            return this;
        }

        public int getNLevels() {
            return this.nlevels;
        }

        public ConfigBuilder setNLevels(int nlevels) {
            if (nlevels < 2 || nlevels > 8) {
                throw new IllegalArgumentException("levels must be between 2 and 8");
            }
            this.nlevels = nlevels;
            return this;
        }

        public boolean isCountDuplicates() {
            return this.countDuplicates;
        }

        public ConfigBuilder setCountDuplicates(boolean countDuplicates) {
            this.countDuplicates = countDuplicates;
            return this;
        }

        public Config build() {
            return new Config(this.hashFunction, this.nlevels, this.countDuplicates);
        }
    }

    public static class Config {
        private final HashFunction hashFunction;
        private final int nlevels;
        private final boolean countDuplicates;

        protected Config() {
            this.hashFunction = DEFAULT_HASH_FUNCTION;
            this.nlevels = 6;
            this.countDuplicates = false;
        }

        protected Config(HashFunction hashFunction, int nlevels, boolean countDuplicates) {
            this.hashFunction = hashFunction;
            this.nlevels = nlevels;
            this.countDuplicates = countDuplicates;
        }

        public HashFunction getHashFunction() {
            return this.hashFunction;
        }

        public int getNLevels() {
            return this.nlevels;
        }

        public boolean isCountDuplicates() {
            return this.countDuplicates;
        }

        public ConfigBuilder toBuilder() {
            return new ConfigBuilder(this.hashFunction, this.nlevels, this.countDuplicates);
        }
    }

    @FunctionalInterface
    public static interface HashFunction {
        public int hash(byte[] var1);
    }

    protected static interface Lookup {
        public CompletableFuture<Boolean> next(ReadTransaction var1);
    }

    class RankLookup
    implements Lookup {
        private final byte[] key;
        private final boolean keyShouldBePresent;
        private byte[] rankKey = EMPTY_ARRAY;
        private long rank = 0L;
        private Subspace levelSubspace;
        private int level;
        private AsyncIterator<KeyValue> asyncIterator;
        private long lastCount;

        public RankLookup(byte[] key, boolean keyShouldBePresent) {
            this.level = RankedSet.this.config.getNLevels();
            this.asyncIterator = null;
            this.key = key;
            this.keyShouldBePresent = keyShouldBePresent;
        }

        public long getRank() {
            return this.rank;
        }

        @Override
        public CompletableFuture<Boolean> next(ReadTransaction tr) {
            boolean newIterator;
            boolean bl = newIterator = this.asyncIterator == null;
            if (newIterator) {
                --this.level;
                if (this.level < 0) {
                    return AsyncUtil.READY_FALSE;
                }
                this.levelSubspace = RankedSet.this.subspace.get(this.level);
                this.asyncIterator = RankedSet.this.lookupIterator(tr.getRange(KeySelector.firstGreaterOrEqual(this.levelSubspace.pack(this.rankKey)), KeySelector.firstGreaterThan(this.levelSubspace.pack(this.key)), 0, false, StreamingMode.WANT_ALL));
                this.lastCount = 0L;
            }
            long startTime = System.nanoTime();
            CompletableFuture<Boolean> onHasNext = this.asyncIterator.onHasNext();
            boolean wasDone = onHasNext.isDone();
            return onHasNext.thenApply(hasNext -> {
                if (!wasDone) {
                    RankedSet.this.nextLookupKey(System.nanoTime() - startTime, newIterator, (boolean)hasNext, this.level, true);
                }
                if (!hasNext.booleanValue()) {
                    this.asyncIterator = null;
                    this.rank -= this.lastCount;
                    if (Arrays.equals(this.rankKey, this.key)) {
                        return false;
                    }
                    if (!this.keyShouldBePresent && this.level == 0 && this.lastCount > 0L) {
                        ++this.rank;
                    }
                    return true;
                }
                KeyValue kv = this.asyncIterator.next();
                this.rankKey = this.levelSubspace.unpack(kv.getKey()).getBytes(0);
                this.lastCount = RankedSet.decodeLong(kv.getValue());
                this.rank += this.lastCount;
                return true;
            });
        }
    }

    protected static class Consistency {
        private final boolean consistent;
        private final int level;
        private final long prevCount;
        private final long count;
        private String structure;

        public Consistency(int level, long prevCount, long count, String structure) {
            this.level = level;
            this.prevCount = prevCount;
            this.count = count;
            this.structure = structure;
            this.consistent = false;
        }

        public Consistency() {
            this.consistent = true;
            this.level = 0;
            this.prevCount = 0L;
            this.count = 0L;
            this.structure = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(67);
            sb.append("Consistency{").append("consistent:").append(this.isConsistent()).append(", level:").append(this.level).append(", prevCount:").append(this.prevCount).append(", count:").append(this.count).append(", structure:'").append(this.structure).append('\'').append('}');
            return sb.toString();
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }

    class NthLookup
    implements Lookup {
        private long rank;
        private byte[] key = EMPTY_ARRAY;
        private int level;
        private Subspace levelSubspace;
        private AsyncIterator<KeyValue> asyncIterator;

        public NthLookup(long rank) {
            this.level = RankedSet.this.config.getNLevels();
            this.asyncIterator = null;
            this.rank = rank;
        }

        public byte[] getKey() {
            return this.key;
        }

        @Override
        public CompletableFuture<Boolean> next(ReadTransaction tr) {
            boolean newIterator;
            boolean bl = newIterator = this.asyncIterator == null;
            if (newIterator) {
                --this.level;
                if (this.level < 0) {
                    if (!RankedSet.this.config.isCountDuplicates()) {
                        this.key = null;
                    }
                    return AsyncUtil.READY_FALSE;
                }
                this.levelSubspace = RankedSet.this.subspace.get(this.level);
                this.asyncIterator = RankedSet.this.lookupIterator(tr.getRange(this.levelSubspace.pack(this.key), this.levelSubspace.range().end, 0, false, StreamingMode.WANT_ALL));
            }
            long startTime = System.nanoTime();
            CompletableFuture<Boolean> onHasNext = this.asyncIterator.onHasNext();
            boolean wasDone = onHasNext.isDone();
            return onHasNext.thenApply(hasNext -> {
                if (!wasDone) {
                    RankedSet.this.nextLookupKey(System.nanoTime() - startTime, newIterator, (boolean)hasNext, this.level, false);
                }
                if (!hasNext.booleanValue()) {
                    this.key = null;
                    return false;
                }
                KeyValue kv = this.asyncIterator.next();
                this.key = this.levelSubspace.unpack(kv.getKey()).getBytes(0);
                if (this.rank == 0L && this.key.length > 0) {
                    return false;
                }
                long count = RankedSet.decodeLong(kv.getValue());
                if (count > this.rank) {
                    this.asyncIterator = null;
                    return true;
                }
                this.rank -= count;
                return true;
            });
        }
    }
}

