/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async;

import com.apple.foundationdb.annotation.API;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class TaskNotifyingExecutor
implements Executor {
    @Nonnull
    protected final Executor delegate;

    public TaskNotifyingExecutor(@Nonnull Executor executor) {
        this.delegate = executor;
    }

    @Override
    public void execute(Runnable task) {
        if (task instanceof Notifier) {
            this.delegate.execute(task);
        } else {
            this.delegate.execute(new Notifier(task));
        }
    }

    public abstract void beforeTask();

    public abstract void afterTask();

    private class Notifier
    implements Runnable {
        @Nonnull
        private final Runnable delegate;

        public Notifier(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                TaskNotifyingExecutor.this.beforeTask();
                this.delegate.run();
            }
            finally {
                TaskNotifyingExecutor.this.afterTask();
            }
        }
    }
}

