/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.rtree.AbstractNode;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
implements Node.ChangeSet {
    @Nullable
    private final Node.ChangeSet previousChangeSet;
    @Nonnull
    private final N node;
    private final int level;

    AbstractChangeSet(@Nullable Node.ChangeSet previousChangeSet, @Nonnull N node, int level) {
        this.previousChangeSet = previousChangeSet;
        this.node = node;
        this.level = level;
    }

    @Override
    public void apply(@Nonnull Transaction transaction) {
        if (this.previousChangeSet != null) {
            this.previousChangeSet.apply(transaction);
        }
    }

    @Nullable
    public Node.ChangeSet getPreviousChangeSet() {
        return this.previousChangeSet;
    }

    @Nonnull
    public N getNode() {
        return this.node;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isUpdateNodeSlotIndex() {
        return this.level >= 0;
    }
}

