/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.rtree.AbstractChangeSet;
import com.apple.foundationdb.async.rtree.AbstractStorageAdapter;
import com.apple.foundationdb.async.rtree.IntermediateNode;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeHelpers;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.StorageAdapter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractNode<S extends NodeSlot, N extends AbstractNode<S, N>>
implements Node {
    @Nonnull
    private final byte[] id;
    @Nonnull
    private List<S> nodeSlots;
    @Nullable
    private IntermediateNode parentNode;
    private int slotIndexInParent;
    @Nullable
    private AbstractChangeSet<S, N> changeSet;

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    protected AbstractNode(@Nonnull byte[] id, @Nonnull List<S> nodeSlots, @Nullable IntermediateNode parentNode, int slotIndexInParent) {
        this.id = id;
        this.nodeSlots = nodeSlots;
        this.parentNode = parentNode;
        this.slotIndexInParent = slotIndexInParent;
        this.changeSet = null;
    }

    protected abstract N getThis();

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getId() {
        return this.id;
    }

    @Nonnull
    public List<S> getSlots() {
        return this.nodeSlots;
    }

    @Nonnull
    public List<S> getSlots(int startIndexInclusive, int endIndexExclusive) {
        return this.nodeSlots.subList(startIndexInclusive, endIndexExclusive);
    }

    @Override
    public int size() {
        return this.nodeSlots.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeSlots.isEmpty();
    }

    @Nonnull
    public S getSlot(int index) {
        return (S)((NodeSlot)this.getSlots().get(index));
    }

    @Override
    @Nonnull
    public Stream<? extends NodeSlot> slotsStream() {
        return this.nodeSlots.stream();
    }

    @Override
    @Nullable
    public AbstractChangeSet<S, N> getChangeSet() {
        return this.changeSet;
    }

    @Nonnull
    public abstract S narrowSlot(@Nonnull NodeSlot var1);

    @Nonnull
    public N moveInSlots(@Nonnull StorageAdapter storageAdapter, @Nonnull Iterable<? extends NodeSlot> slots) {
        AbstractStorageAdapter abstractStorageAdapter = (AbstractStorageAdapter)storageAdapter;
        N self = this.getThis();
        List narrowedSlots = Streams.stream(slots).map(this::narrowSlot).collect(ImmutableList.toImmutableList());
        this.nodeSlots.addAll(narrowedSlots);
        this.changeSet = abstractStorageAdapter.newInsertChangeSet(self, -1, narrowedSlots);
        return self;
    }

    @Nonnull
    public N moveOutAllSlots(@Nonnull StorageAdapter storageAdapter) {
        return (N)this.deleteAllSlots(storageAdapter, -1);
    }

    @Nonnull
    public N insertSlot(@Nonnull StorageAdapter storageAdapter, int level, int slotIndex, @Nonnull NodeSlot slot) {
        AbstractStorageAdapter abstractStorageAdapter = (AbstractStorageAdapter)storageAdapter;
        N self = this.getThis();
        S narrowedSlot = this.narrowSlot(slot);
        this.nodeSlots.add(slotIndex, narrowedSlot);
        this.changeSet = abstractStorageAdapter.newInsertChangeSet(self, level, ImmutableList.of(narrowedSlot));
        return self;
    }

    @Override
    @Nonnull
    public Node updateSlot(@Nonnull StorageAdapter storageAdapter, int level, int slotIndex, @Nonnull NodeSlot updatedSlot) {
        AbstractStorageAdapter abstractStorageAdapter = (AbstractStorageAdapter)storageAdapter;
        N self = this.getThis();
        S narrowedSlot = this.narrowSlot(updatedSlot);
        NodeSlot originalSlot = (NodeSlot)this.nodeSlots.set(slotIndex, narrowedSlot);
        this.changeSet = abstractStorageAdapter.newUpdateChangeSet(self, level, originalSlot, narrowedSlot);
        return self;
    }

    @Override
    @Nonnull
    public Node deleteSlot(@Nonnull StorageAdapter storageAdapter, int level, int slotIndex) {
        AbstractStorageAdapter abstractStorageAdapter = (AbstractStorageAdapter)storageAdapter;
        N self = this.getThis();
        NodeSlot narrowedSlot = (NodeSlot)this.nodeSlots.get(slotIndex);
        this.nodeSlots.remove(slotIndex);
        this.changeSet = abstractStorageAdapter.newDeleteChangeSet(self, level, ImmutableList.of(narrowedSlot));
        return self;
    }

    @Nonnull
    public N deleteAllSlots(@Nonnull StorageAdapter storageAdapter, int level) {
        AbstractStorageAdapter abstractStorageAdapter = (AbstractStorageAdapter)storageAdapter;
        N self = this.getThis();
        this.changeSet = abstractStorageAdapter.newDeleteChangeSet(self, level, this.nodeSlots);
        this.nodeSlots = Lists.newArrayList();
        return self;
    }

    @Override
    @Nullable
    public IntermediateNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public int getSlotIndexInParent() {
        return this.slotIndexInParent;
    }

    @Override
    public void linkToParent(@Nonnull IntermediateNode parentNode, int slotInParent) {
        this.parentNode = parentNode;
        this.slotIndexInParent = slotInParent;
    }

    @Nonnull
    public abstract N newOfSameKind(@Nonnull byte[] var1);

    @Nonnull
    public String toString() {
        return "[" + this.getKind().name() + ": id = " + NodeHelpers.bytesToHex(this.getId()) + "; parent = " + (this.getParentNode() == null ? "null" : NodeHelpers.bytesToHex(this.getParentNode().getId())) + "; slotInParent = " + String.valueOf(this.getSlotInParent()) + "]";
    }
}

