/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.rtree.AbstractChangeSet;
import com.apple.foundationdb.async.rtree.AbstractNode;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.NodeSlotIndexAdapter;
import com.apple.foundationdb.async.rtree.OnReadListener;
import com.apple.foundationdb.async.rtree.OnWriteListener;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.async.rtree.StorageAdapter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractStorageAdapter
implements StorageAdapter {
    @Nonnull
    private final RTree.Config config;
    @Nonnull
    private final Subspace subspace;
    @Nullable
    private final NodeSlotIndexAdapter nodeSlotIndexAdapter;
    @Nonnull
    private final Function<RTree.Point, BigInteger> hilbertValueFunction;
    @Nonnull
    private final OnWriteListener onWriteListener;
    @Nonnull
    private final OnReadListener onReadListener;

    protected AbstractStorageAdapter(@Nonnull RTree.Config config, @Nonnull Subspace subspace, @Nonnull Subspace nodeSlotIndexSubspace, @Nonnull Function<RTree.Point, BigInteger> hilbertValueFunction, @Nonnull OnWriteListener onWriteListener, @Nonnull OnReadListener onReadListener) {
        this.config = config;
        this.subspace = subspace;
        this.nodeSlotIndexAdapter = config.isUseNodeSlotIndex() ? new NodeSlotIndexAdapter(nodeSlotIndexSubspace, onWriteListener, onReadListener) : null;
        this.hilbertValueFunction = hilbertValueFunction;
        this.onWriteListener = onWriteListener;
        this.onReadListener = onReadListener;
    }

    @Override
    @Nonnull
    public RTree.Config getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public Subspace getSubspace() {
        return this.subspace;
    }

    @Override
    @Nullable
    public Subspace getSecondarySubspace() {
        return this.nodeSlotIndexAdapter == null ? null : this.nodeSlotIndexAdapter.getNodeSlotIndexSubspace();
    }

    @Nonnull
    protected Function<RTree.Point, BigInteger> getHilbertValueFunction() {
        return this.hilbertValueFunction;
    }

    @Override
    @Nonnull
    public OnWriteListener getOnWriteListener() {
        return this.onWriteListener;
    }

    @Override
    @Nonnull
    public OnReadListener getOnReadListener() {
        return this.onReadListener;
    }

    @Override
    public void writeNodes(@Nonnull Transaction transaction, @Nonnull List<? extends Node> nodes) {
        for (Node node : nodes) {
            this.writeNode(transaction, node);
        }
    }

    protected void writeNode(@Nonnull Transaction transaction, @Nonnull Node node) {
        Node.ChangeSet changeSet = node.getChangeSet();
        if (changeSet == null) {
            return;
        }
        changeSet.apply(transaction);
        this.getOnWriteListener().onNodeWritten(node);
    }

    @Nonnull
    public byte[] packWithSubspace(byte[] key) {
        return this.getSubspace().pack(key);
    }

    @Override
    @Nonnull
    public CompletableFuture<Node> scanNodeIndexAndFetchNode(@Nonnull ReadTransaction transaction, int level, @Nonnull BigInteger hilbertValue, @Nonnull Tuple key, boolean isInsertUpdate) {
        Objects.requireNonNull(this.nodeSlotIndexAdapter);
        return this.nodeSlotIndexAdapter.scanIndexForNodeId(transaction, level, hilbertValue, key, isInsertUpdate).thenCompose(nodeId -> nodeId == null ? CompletableFuture.completedFuture(null) : this.fetchNode(transaction, (byte[])nodeId));
    }

    @Override
    public void insertIntoNodeIndexIfNecessary(@Nonnull Transaction transaction, int level, @Nonnull NodeSlot nodeSlot) {
        if (!this.getConfig().isUseNodeSlotIndex() || !(nodeSlot instanceof ChildSlot)) {
            return;
        }
        Objects.requireNonNull(this.nodeSlotIndexAdapter);
        this.nodeSlotIndexAdapter.writeChildSlot(transaction, level, (ChildSlot)nodeSlot);
    }

    @Override
    public void deleteFromNodeIndexIfNecessary(@Nonnull Transaction transaction, int level, @Nonnull NodeSlot nodeSlot) {
        if (!this.getConfig().isUseNodeSlotIndex() || !(nodeSlot instanceof ChildSlot)) {
            return;
        }
        Objects.requireNonNull(this.nodeSlotIndexAdapter);
        this.nodeSlotIndexAdapter.clearChildSlot(transaction, level, (ChildSlot)nodeSlot);
    }

    @Override
    @Nonnull
    public CompletableFuture<Node> fetchNode(@Nonnull ReadTransaction transaction, @Nonnull byte[] nodeId) {
        return this.getOnWriteListener().onAsyncReadForWrite(this.fetchNodeInternal(transaction, nodeId).thenApply(this::checkNode));
    }

    @Nonnull
    protected abstract CompletableFuture<Node> fetchNodeInternal(@Nonnull ReadTransaction var1, @Nonnull byte[] var2);

    @Nullable
    private <N extends Node> N checkNode(@Nullable N node) {
        if (!(node == null || node.size() >= this.getConfig().getMinM() && node.size() <= this.getConfig().getMaxM() || node.isRoot())) {
            throw new IllegalStateException("packing of non-root is out of valid range");
        }
        return node;
    }

    @Nonnull
    abstract <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newInsertChangeSet(@Nonnull N var1, int var2, @Nonnull List<S> var3);

    @Nonnull
    abstract <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newUpdateChangeSet(@Nonnull N var1, int var2, @Nonnull S var3, @Nonnull S var4);

    @Nonnull
    abstract <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newDeleteChangeSet(@Nonnull N var1, int var2, @Nonnull List<S> var3);
}

