/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.rtree.AbstractChangeSet;
import com.apple.foundationdb.async.rtree.AbstractNode;
import com.apple.foundationdb.async.rtree.AbstractStorageAdapter;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.IntermediateNode;
import com.apple.foundationdb.async.rtree.ItemSlot;
import com.apple.foundationdb.async.rtree.LeafNode;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeKind;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.OnReadListener;
import com.apple.foundationdb.async.rtree.OnWriteListener;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.async.rtree.StorageAdapter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;

class ByNodeStorageAdapter
extends AbstractStorageAdapter
implements StorageAdapter {
    public ByNodeStorageAdapter(@Nonnull RTree.Config config, @Nonnull Subspace subspace, @Nonnull Subspace nodeSlotIndexSubspace, @Nonnull Function<RTree.Point, BigInteger> hilbertValueFunction, @Nonnull OnWriteListener onWriteListener, @Nonnull OnReadListener onReadListener) {
        super(config, subspace, nodeSlotIndexSubspace, hilbertValueFunction, onWriteListener, onReadListener);
    }

    @Override
    public void writeLeafNodeSlot(@Nonnull Transaction transaction, @Nonnull LeafNode node, @Nonnull ItemSlot itemSlot) {
        this.persistNode(transaction, node);
    }

    @Override
    public void clearLeafNodeSlot(@Nonnull Transaction transaction, @Nonnull LeafNode node, @Nonnull ItemSlot itemSlot) {
        this.persistNode(transaction, node);
    }

    private void persistNode(@Nonnull Transaction transaction, @Nonnull Node node) {
        byte[] packedKey = this.packWithSubspace(node.getId());
        if (node.isEmpty()) {
            transaction.clear(packedKey);
            this.getOnWriteListener().onKeyCleared(node, packedKey);
        } else {
            byte[] packedValue = this.toTuple(node).pack();
            transaction.set(packedKey, packedValue);
            this.getOnWriteListener().onKeyValueWritten(node, packedKey, packedValue);
        }
    }

    @Nonnull
    private Tuple toTuple(@Nonnull Node node) {
        RTree.Config config = this.getConfig();
        ArrayList<Tuple> slotTuples = Lists.newArrayListWithExpectedSize(node.size());
        for (NodeSlot nodeSlot : node.getSlots()) {
            Tuple slotTuple = Tuple.fromStream(Streams.concat(nodeSlot.getSlotKey(config.isStoreHilbertValues()).getItems().stream(), nodeSlot.getSlotValue().getItems().stream()));
            slotTuples.add(slotTuple);
        }
        return Tuple.from(node.getKind().getSerialized(), slotTuples);
    }

    @Override
    @Nonnull
    public CompletableFuture<Node> fetchNodeInternal(@Nonnull ReadTransaction transaction, @Nonnull byte[] nodeId) {
        byte[] key = this.packWithSubspace(nodeId);
        return transaction.get(key).thenApply(valueBytes -> {
            if (valueBytes == null) {
                return null;
            }
            Node node = this.fromTuple(nodeId, Tuple.fromBytes(valueBytes));
            OnReadListener onReadListener = this.getOnReadListener();
            onReadListener.onNodeRead(node);
            onReadListener.onKeyValueRead(node, key, (byte[])valueBytes);
            return node;
        });
    }

    @Nonnull
    private Node fromTuple(@Nonnull byte[] nodeId, @Nonnull Tuple tuple) {
        NodeKind nodeKind = NodeKind.fromSerializedNodeKind((byte)tuple.getLong(0));
        List<Object> nodeSlotObjects = tuple.getNestedList(1);
        ArrayList<ItemSlot> itemSlots = null;
        ArrayList<ChildSlot> childSlots = null;
        block4: for (Object nodeSlotObject : nodeSlotObjects) {
            List nodeSlotItems = (List)nodeSlotObject;
            switch (nodeKind) {
                case LEAF: {
                    Tuple itemSlotKeyTuple = Tuple.fromList(nodeSlotItems.subList(0, 2));
                    Tuple itemSlotValueTuple = Tuple.fromList(nodeSlotItems.subList(2, nodeSlotItems.size()));
                    if (itemSlots == null) {
                        itemSlots = Lists.newArrayListWithExpectedSize(nodeSlotObjects.size());
                    }
                    itemSlots.add(ItemSlot.fromKeyAndValue(itemSlotKeyTuple, itemSlotValueTuple, this.getHilbertValueFunction()));
                    continue block4;
                }
                case INTERMEDIATE: {
                    Tuple childSlotKeyTuple = Tuple.fromList(nodeSlotItems.subList(0, 4));
                    Tuple childSlotValueTuple = Tuple.fromList(nodeSlotItems.subList(4, nodeSlotItems.size()));
                    if (childSlots == null) {
                        childSlots = Lists.newArrayListWithExpectedSize(nodeSlotObjects.size());
                    }
                    childSlots.add(ChildSlot.fromKeyAndValue(childSlotKeyTuple, childSlotValueTuple));
                    continue block4;
                }
            }
            throw new IllegalStateException("unknown node kind");
        }
        Verify.verify(nodeKind == NodeKind.LEAF && itemSlots != null || nodeKind == NodeKind.INTERMEDIATE && childSlots != null);
        return nodeKind == NodeKind.LEAF ? new LeafNode(nodeId, itemSlots) : new IntermediateNode(nodeId, childSlots);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newInsertChangeSet(@Nonnull N node, int level, @Nonnull List<S> insertedSlots) {
        return new InsertChangeSet(this, node, level, insertedSlots);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newUpdateChangeSet(@Nonnull N node, int level, @Nonnull S originalSlot, @Nonnull S updatedSlot) {
        return new UpdateChangeSet(this, node, level, originalSlot, updatedSlot);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newDeleteChangeSet(@Nonnull N node, int level, @Nonnull List<S> deletedSlots) {
        return new DeleteChangeSet(this, node, level, deletedSlots);
    }

    private static class InsertChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final List<S> insertedSlots;
        final /* synthetic */ ByNodeStorageAdapter this$0;

        public InsertChangeSet(N node, @Nonnull int level, List<S> insertedSlots) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.insertedSlots = ImmutableList.copyOf(insertedSlots);
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            if (this.getPreviousChangeSet() == null) {
                this.this$0.persistNode(transaction, (Node)this.getNode());
            }
            if (this.isUpdateNodeSlotIndex()) {
                for (NodeSlot insertedSlot : this.insertedSlots) {
                    this.this$0.insertIntoNodeIndexIfNecessary(transaction, this.getLevel(), insertedSlot);
                }
            }
        }
    }

    private static class UpdateChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final S originalSlot;
        @Nonnull
        private final S updatedSlot;
        final /* synthetic */ ByNodeStorageAdapter this$0;

        public UpdateChangeSet(N node, @Nonnull int level, @Nonnull S originalSlot, S updatedSlot) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.originalSlot = originalSlot;
            this.updatedSlot = updatedSlot;
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            if (this.getPreviousChangeSet() == null) {
                this.this$0.persistNode(transaction, (Node)this.getNode());
            }
            if (this.isUpdateNodeSlotIndex()) {
                this.this$0.deleteFromNodeIndexIfNecessary(transaction, this.getLevel(), (NodeSlot)this.originalSlot);
                this.this$0.insertIntoNodeIndexIfNecessary(transaction, this.getLevel(), (NodeSlot)this.updatedSlot);
            }
        }
    }

    private static class DeleteChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final List<S> deletedSlots;
        final /* synthetic */ ByNodeStorageAdapter this$0;

        public DeleteChangeSet(N node, @Nonnull int level, List<S> deletedSlots) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.deletedSlots = ImmutableList.copyOf(deletedSlots);
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            if (this.getPreviousChangeSet() == null) {
                this.this$0.persistNode(transaction, (Node)this.getNode());
            }
            if (this.isUpdateNodeSlotIndex()) {
                for (NodeSlot deletedSlot : this.deletedSlots) {
                    this.this$0.deleteFromNodeIndexIfNecessary(transaction, this.getLevel(), deletedSlot);
                }
            }
        }
    }
}

