/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.rtree.AbstractChangeSet;
import com.apple.foundationdb.async.rtree.AbstractNode;
import com.apple.foundationdb.async.rtree.AbstractStorageAdapter;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.IntermediateNode;
import com.apple.foundationdb.async.rtree.ItemSlot;
import com.apple.foundationdb.async.rtree.LeafNode;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeKind;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.OnReadListener;
import com.apple.foundationdb.async.rtree.OnWriteListener;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.async.rtree.StorageAdapter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;

class BySlotStorageAdapter
extends AbstractStorageAdapter
implements StorageAdapter {
    public BySlotStorageAdapter(@Nonnull RTree.Config config, @Nonnull Subspace subspace, @Nonnull Subspace nodeSlotIndexSubspace, @Nonnull Function<RTree.Point, BigInteger> hilbertValueFunction, @Nonnull OnWriteListener onWriteListener, @Nonnull OnReadListener onReadListener) {
        super(config, subspace, nodeSlotIndexSubspace, hilbertValueFunction, onWriteListener, onReadListener);
    }

    @Override
    public void writeLeafNodeSlot(@Nonnull Transaction transaction, @Nonnull LeafNode node, @Nonnull ItemSlot itemSlot) {
        this.writeNodeSlot(transaction, node, itemSlot);
    }

    private void writeNodeSlot(@Nonnull Transaction transaction, @Nonnull Node node, @Nonnull NodeSlot nodeSlot) {
        Tuple keyTuple = Tuple.from(node.getKind().getSerialized());
        keyTuple = keyTuple.addAll(nodeSlot.getSlotKey(this.getConfig().isStoreHilbertValues()));
        byte[] packedKey = keyTuple.pack(this.packWithSubspace(node.getId()));
        byte[] packedValue = nodeSlot.getSlotValue().pack();
        transaction.set(packedKey, packedValue);
        this.getOnWriteListener().onKeyValueWritten(node, packedKey, packedValue);
    }

    @Override
    public void clearLeafNodeSlot(@Nonnull Transaction transaction, @Nonnull LeafNode node, @Nonnull ItemSlot itemSlot) {
        this.clearNodeSlot(transaction, node, itemSlot);
    }

    private void clearNodeSlot(@Nonnull Transaction transaction, @Nonnull Node node, @Nonnull NodeSlot nodeSlot) {
        Tuple keyTuple = Tuple.from(node.getKind().getSerialized());
        keyTuple = keyTuple.addAll(nodeSlot.getSlotKey(this.getConfig().isStoreHilbertValues()));
        byte[] packedKey = keyTuple.pack(this.packWithSubspace(node.getId()));
        transaction.clear(packedKey);
        this.getOnWriteListener().onKeyCleared(node, packedKey);
    }

    @Override
    @Nonnull
    public CompletableFuture<Node> fetchNodeInternal(@Nonnull ReadTransaction transaction, @Nonnull byte[] nodeId) {
        return AsyncUtil.collect(transaction.getRange(Range.startsWith(this.packWithSubspace(nodeId)), 0, false, StreamingMode.WANT_ALL), transaction.getExecutor()).thenApply(keyValues -> {
            if (keyValues.isEmpty()) {
                return null;
            }
            Node node = this.fromKeyValues(nodeId, (List<KeyValue>)keyValues);
            OnReadListener onReadListener = this.getOnReadListener();
            onReadListener.onNodeRead(node);
            keyValues.forEach(keyValue -> onReadListener.onKeyValueRead(node, keyValue.getKey(), keyValue.getValue()));
            return node;
        });
    }

    @Nonnull
    private Node fromKeyValues(@Nonnull byte[] nodeId, List<KeyValue> keyValues) {
        ArrayList<ItemSlot> itemSlots = null;
        ArrayList<ChildSlot> childSlots = null;
        NodeKind nodeKind = null;
        Verify.verify(!keyValues.isEmpty());
        for (KeyValue keyValue : keyValues) {
            Tuple keyTuple = this.getSubspace().unpack(keyValue.getKey()).popFront();
            Tuple valueTuple = Tuple.fromBytes(keyValue.getValue());
            NodeKind currentNodeKind = NodeKind.fromSerializedNodeKind((byte)keyTuple.getLong(0));
            if (nodeKind == null) {
                nodeKind = currentNodeKind;
            } else if (nodeKind != currentNodeKind) {
                throw new IllegalArgumentException("same node id uses different node kinds");
            }
            Tuple slotKeyTuple = keyTuple.popFront();
            if (nodeKind == NodeKind.LEAF) {
                if (itemSlots == null) {
                    itemSlots = Lists.newArrayList();
                }
                itemSlots.add(ItemSlot.fromKeyAndValue(slotKeyTuple, valueTuple, this.getHilbertValueFunction()));
                continue;
            }
            Verify.verify(nodeKind == NodeKind.INTERMEDIATE);
            if (childSlots == null) {
                childSlots = Lists.newArrayList();
            }
            childSlots.add(ChildSlot.fromKeyAndValue(slotKeyTuple, valueTuple));
        }
        Verify.verify(nodeKind == NodeKind.LEAF && itemSlots != null && childSlots == null || nodeKind == NodeKind.INTERMEDIATE && itemSlots == null && childSlots != null);
        if (nodeKind == NodeKind.LEAF && !this.getConfig().isStoreHilbertValues()) {
            itemSlots.sort(ItemSlot.comparator);
        }
        return nodeKind == NodeKind.LEAF ? new LeafNode(nodeId, (List<ItemSlot>)itemSlots) : new IntermediateNode(nodeId, childSlots);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newInsertChangeSet(@Nonnull N node, int level, @Nonnull List<S> insertedSlots) {
        return new InsertChangeSet(this, node, level, insertedSlots);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newUpdateChangeSet(@Nonnull N node, int level, @Nonnull S originalSlot, @Nonnull S updatedSlot) {
        return new UpdateChangeSet(this, node, level, originalSlot, updatedSlot);
    }

    @Override
    @Nonnull
    public <S extends NodeSlot, N extends AbstractNode<S, N>> AbstractChangeSet<S, N> newDeleteChangeSet(@Nonnull N node, int level, @Nonnull List<S> deletedSlots) {
        return new DeleteChangeSet(this, node, level, deletedSlots);
    }

    private static class InsertChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final List<S> insertedSlots;
        final /* synthetic */ BySlotStorageAdapter this$0;

        public InsertChangeSet(N node, @Nonnull int level, List<S> insertedSlots) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.insertedSlots = ImmutableList.copyOf(insertedSlots);
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            for (NodeSlot insertedSlot : this.insertedSlots) {
                this.this$0.writeNodeSlot(transaction, (Node)this.getNode(), insertedSlot);
                if (!this.isUpdateNodeSlotIndex()) continue;
                this.this$0.insertIntoNodeIndexIfNecessary(transaction, this.getLevel(), insertedSlot);
            }
        }
    }

    private static class UpdateChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final S originalSlot;
        @Nonnull
        private final S updatedSlot;
        final /* synthetic */ BySlotStorageAdapter this$0;

        public UpdateChangeSet(N node, @Nonnull int level, @Nonnull S originalSlot, S updatedSlot) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.originalSlot = originalSlot;
            this.updatedSlot = updatedSlot;
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            this.this$0.clearNodeSlot(transaction, (Node)this.getNode(), (NodeSlot)this.originalSlot);
            this.this$0.writeNodeSlot(transaction, (Node)this.getNode(), (NodeSlot)this.updatedSlot);
            if (this.isUpdateNodeSlotIndex()) {
                this.this$0.deleteFromNodeIndexIfNecessary(transaction, this.getLevel(), (NodeSlot)this.originalSlot);
                this.this$0.insertIntoNodeIndexIfNecessary(transaction, this.getLevel(), (NodeSlot)this.updatedSlot);
            }
        }
    }

    private static class DeleteChangeSet<S extends NodeSlot, N extends AbstractNode<S, N>>
    extends AbstractChangeSet<S, N> {
        @Nonnull
        private final List<S> deletedSlots;
        final /* synthetic */ BySlotStorageAdapter this$0;

        public DeleteChangeSet(N node, @Nonnull int level, List<S> deletedSlots) {
            this.this$0 = var1_1;
            super(((AbstractNode)node).getChangeSet(), node, level);
            this.deletedSlots = ImmutableList.copyOf(deletedSlots);
        }

        @Override
        public void apply(@Nonnull Transaction transaction) {
            super.apply(transaction);
            for (NodeSlot deletedSlot : this.deletedSlots) {
                this.this$0.clearNodeSlot(transaction, (Node)this.getNode(), deletedSlot);
                if (!this.isUpdateNodeSlotIndex()) continue;
                this.this$0.deleteFromNodeIndexIfNecessary(transaction, this.getLevel(), deletedSlot);
            }
        }
    }
}

