/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Verify;
import java.math.BigInteger;
import javax.annotation.Nonnull;

public class ChildSlot
implements NodeSlot {
    static final int SLOT_KEY_TUPLE_SIZE = 4;
    static final int SLOT_VALUE_TUPLE_SIZE = 2;
    @Nonnull
    private final byte[] childId;
    @Nonnull
    private final RTree.Rectangle mbr;
    @Nonnull
    private final BigInteger smallestHilbertValue;
    @Nonnull
    private final Tuple smallestKey;
    @Nonnull
    private final BigInteger largestHilbertValue;
    @Nonnull
    private final Tuple largestKey;

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    ChildSlot(@Nonnull BigInteger smallestHilbertValue, @Nonnull Tuple smallestKey, @Nonnull BigInteger largestHilbertValue, @Nonnull Tuple largestKey, @Nonnull byte[] childId, @Nonnull RTree.Rectangle mbr) {
        this.smallestHilbertValue = smallestHilbertValue;
        this.smallestKey = smallestKey;
        this.largestHilbertValue = largestHilbertValue;
        this.largestKey = largestKey;
        this.childId = childId;
        this.mbr = mbr;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getChildId() {
        return this.childId;
    }

    @Override
    @Nonnull
    public BigInteger getSmallestHilbertValue() {
        return this.smallestHilbertValue;
    }

    @Override
    @Nonnull
    public Tuple getSmallestKey() {
        return this.smallestKey;
    }

    @Override
    @Nonnull
    public BigInteger getLargestHilbertValue() {
        return this.largestHilbertValue;
    }

    @Override
    @Nonnull
    public Tuple getLargestKey() {
        return this.largestKey;
    }

    @Nonnull
    public RTree.Rectangle getMbr() {
        return this.mbr;
    }

    @Override
    @Nonnull
    public Tuple getSlotKey(boolean storeHilbertValue) {
        return Tuple.from(this.getSmallestHilbertValue(), this.getSmallestKey(), this.getLargestHilbertValue(), this.getLargestKey());
    }

    @Override
    @Nonnull
    public Tuple getSlotValue() {
        return Tuple.from(this.getChildId(), this.getMbr().getRanges());
    }

    public boolean suffixPredicateCanBeApplied() {
        int hilbertValueCompare = this.getSmallestHilbertValue().compareTo(this.getLargestHilbertValue());
        Verify.verify(hilbertValueCompare <= 0);
        if (hilbertValueCompare != 0) {
            return false;
        }
        int positionTupleCompare = TupleHelpers.compare(this.getSmallestKey().getNestedTuple(0), this.getLargestKey().getNestedTuple(0));
        Verify.verify(positionTupleCompare <= 0);
        return positionTupleCompare == 0;
    }

    @Nonnull
    public String toString() {
        return "[" + String.valueOf(this.getMbr()) + ";" + String.valueOf(this.getSmallestHilbertValue()) + "; " + String.valueOf(this.getLargestHilbertValue()) + "]";
    }

    @Nonnull
    static ChildSlot fromKeyAndValue(@Nonnull Tuple keyTuple, @Nonnull Tuple valueTuple) {
        Verify.verify(keyTuple.size() == 4);
        Verify.verify(valueTuple.size() == 2);
        return new ChildSlot(keyTuple.getBigInteger(0), keyTuple.getNestedTuple(1), keyTuple.getBigInteger(2), keyTuple.getNestedTuple(3), valueTuple.getBytes(0), new RTree.Rectangle(valueTuple.getNestedTuple(1)));
    }
}

