/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Verify;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ItemSlot
implements NodeSlot {
    static final Comparator<ItemSlot> comparator = Comparator.comparing(ItemSlot::getHilbertValue).thenComparing(ItemSlot::getKey);
    public static final int SLOT_KEY_TUPLE_SIZE = 2;
    public static final int SLOT_VALUE_TUPLE_SIZE = 1;
    @Nonnull
    private final BigInteger hilbertValue;
    @Nonnull
    private final Tuple key;
    @Nonnull
    private final Tuple value;
    @Nonnull
    private final RTree.Point position;

    public ItemSlot(@Nonnull BigInteger hilbertValue, @Nonnull RTree.Point position, @Nonnull Tuple key, @Nonnull Tuple value) {
        this.hilbertValue = hilbertValue;
        this.key = key;
        this.value = value;
        this.position = position;
    }

    @Nonnull
    public BigInteger getHilbertValue() {
        return this.hilbertValue;
    }

    @Nonnull
    public Tuple getKey() {
        return this.key;
    }

    @Nonnull
    public Tuple getKeySuffix() {
        return this.key.getNestedTuple(1);
    }

    @Nonnull
    public Tuple getValue() {
        return this.value;
    }

    @Nonnull
    public RTree.Point getPosition() {
        return this.position;
    }

    @Override
    @Nonnull
    public BigInteger getSmallestHilbertValue() {
        return this.hilbertValue;
    }

    @Override
    @Nonnull
    public BigInteger getLargestHilbertValue() {
        return this.hilbertValue;
    }

    @Override
    @Nonnull
    public Tuple getSmallestKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public Tuple getLargestKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public Tuple getSlotKey(boolean storeHilbertValues) {
        return Tuple.from(storeHilbertValues ? this.getHilbertValue() : null, this.getKey());
    }

    @Override
    @Nonnull
    public Tuple getSlotValue() {
        return Tuple.from(this.getValue());
    }

    public int compareHilbertValueAndKey(@Nonnull BigInteger hilbertValue, @Nonnull Tuple key) {
        int hilbertValueCompare = this.getHilbertValue().compareTo(hilbertValue);
        if (hilbertValueCompare != 0) {
            return hilbertValueCompare;
        }
        return TupleHelpers.compare(this.getKey(), key);
    }

    public String toString() {
        return "[" + String.valueOf(this.getPosition()) + ";" + String.valueOf(this.getHilbertValue()) + "; " + String.valueOf(this.getKey()) + "]";
    }

    @Nonnull
    static ItemSlot fromKeyAndValue(@Nonnull Tuple keyTuple, @Nonnull Tuple valueTuple, @Nonnull Function<RTree.Point, BigInteger> hilbertValueFunction) {
        Verify.verify(keyTuple.size() == 2);
        Verify.verify(valueTuple.size() == 1);
        Tuple itemKey = keyTuple.getNestedTuple(1);
        RTree.Point point = new RTree.Point(itemKey.getNestedTuple(0));
        BigInteger hilbertValue = keyTuple.get(0) == null ? hilbertValueFunction.apply(point) : keyTuple.getBigInteger(0);
        return new ItemSlot(hilbertValue, point, itemKey, valueTuple.getNestedTuple(0));
    }
}

