/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.IntermediateNode;
import com.apple.foundationdb.async.rtree.NodeHelpers;
import com.apple.foundationdb.async.rtree.NodeKind;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.async.rtree.StorageAdapter;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.base.Verify;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Node {
    @Nonnull
    public byte[] getId();

    public int size();

    public boolean isEmpty();

    @Nonnull
    public Iterable<? extends NodeSlot> getSlots();

    @Nonnull
    public Iterable<? extends NodeSlot> getSlots(int var1, int var2);

    @Nonnull
    public NodeSlot getSlot(int var1);

    @Nonnull
    public Stream<? extends NodeSlot> slotsStream();

    @Nullable
    public ChangeSet getChangeSet();

    @Nonnull
    @CanIgnoreReturnValue
    public Node moveInSlots(@Nonnull StorageAdapter var1, @Nonnull Iterable<? extends NodeSlot> var2);

    @Nonnull
    @CanIgnoreReturnValue
    public Node moveOutAllSlots(@Nonnull StorageAdapter var1);

    @Nonnull
    @CanIgnoreReturnValue
    public Node insertSlot(@Nonnull StorageAdapter var1, int var2, int var3, @Nonnull NodeSlot var4);

    @Nonnull
    @CanIgnoreReturnValue
    public Node updateSlot(@Nonnull StorageAdapter var1, int var2, int var3, @Nonnull NodeSlot var4);

    @Nonnull
    @CanIgnoreReturnValue
    public Node deleteSlot(@Nonnull StorageAdapter var1, int var2, int var3);

    @Nonnull
    @CanIgnoreReturnValue
    public Node deleteAllSlots(@Nonnull StorageAdapter var1, int var2);

    default public boolean isRoot() {
        return Arrays.equals(RTree.rootId, this.getId());
    }

    @Nonnull
    public NodeKind getKind();

    @Nullable
    public IntermediateNode getParentNode();

    public int getSlotIndexInParent();

    @Nullable
    default public ChildSlot getSlotInParent() {
        IntermediateNode parentNode = this.getParentNode();
        if (parentNode == null) {
            return null;
        }
        int slotIndexInParent = this.getSlotIndexInParent();
        Verify.verify(slotIndexInParent >= 0);
        return (ChildSlot)parentNode.getSlot(slotIndexInParent);
    }

    public void linkToParent(@Nonnull IntermediateNode var1, int var2);

    @Nonnull
    public Node newOfSameKind(@Nonnull byte[] var1);

    default public void validate() {
        BigInteger lastHilbertValue = null;
        Tuple lastKey = null;
        for (NodeSlot nodeSlot : this.getSlots()) {
            int hilbertValueCompare;
            if (lastHilbertValue != null) {
                hilbertValueCompare = nodeSlot.getSmallestHilbertValue().compareTo(lastHilbertValue);
                Verify.verify(hilbertValueCompare >= 0, "smallest (hilbertValue, key) pairs are not monotonically increasing (hilbertValueCheck)", new Object[0]);
                if (hilbertValueCompare == 0) {
                    Verify.verify(TupleHelpers.compare(nodeSlot.getSmallestKey(), lastKey) >= 0, "smallest (hilbertValue, key) pairs are not monotonically increasing (keyCheck)", new Object[0]);
                }
            }
            lastHilbertValue = nodeSlot.getSmallestHilbertValue();
            lastKey = nodeSlot.getSmallestKey();
            hilbertValueCompare = nodeSlot.getLargestHilbertValue().compareTo(lastHilbertValue);
            Verify.verify(hilbertValueCompare >= 0, "largest (hilbertValue, key) pairs are not monotonically increasing (hilbertValueCheck)", new Object[0]);
            if (hilbertValueCompare == 0) {
                Verify.verify(TupleHelpers.compare(nodeSlot.getLargestKey(), lastKey) >= 0, "largest (hilbertValue, key) pairs are not monotonically increasing (keyCheck)", new Object[0]);
            }
            lastHilbertValue = nodeSlot.getLargestHilbertValue();
            lastKey = nodeSlot.getLargestKey();
        }
    }

    default public void validateParentNode(@Nullable IntermediateNode parentNode, @Nullable ChildSlot childSlotInParentNode) {
        if (parentNode == null) {
            Verify.verify(this.isRoot());
            Verify.verify(childSlotInParentNode == null);
        } else {
            Objects.requireNonNull(childSlotInParentNode);
            RTree.Rectangle computedMbr = NodeHelpers.computeMbr(this.getSlots());
            Verify.verify(childSlotInParentNode.getMbr().equals(computedMbr), "computed mbr does not match mbr from node", new Object[0]);
            Verify.verify(childSlotInParentNode.getSmallestHilbertValue().equals(this.getSlot(0).getSmallestHilbertValue()), "expected smallest hilbert value does not match the actual smallest hilbert value of the first child in childNode", new Object[0]);
            Verify.verify(TupleHelpers.equals(childSlotInParentNode.getSmallestKey(), this.getSlot(0).getSmallestKey()), "expected smallest key does not match the actual smallest key of the first child in childNode", new Object[0]);
            Verify.verify(childSlotInParentNode.getLargestHilbertValue().equals(this.getSlot(this.size() - 1).getLargestHilbertValue()), "expected largest hilbert value does not match the actual hilbert value of the last child in childNode", new Object[0]);
            Verify.verify(TupleHelpers.equals(childSlotInParentNode.getLargestKey(), this.getSlot(this.size() - 1).getLargestKey()), "expected largest key does not match the actual largest key of the last child in childNode", new Object[0]);
        }
    }

    public static interface ChangeSet {
        public void apply(@Nonnull Transaction var1);
    }
}

