/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.ItemSlot;
import com.apple.foundationdb.async.rtree.Node;
import com.apple.foundationdb.async.rtree.NodeSlot;
import com.apple.foundationdb.async.rtree.RTree;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NodeHelpers {
    private static final int nodeIdLength = 16;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final AtomicLong nodeIdState = new AtomicLong(1L);

    private NodeHelpers() {
    }

    @Nonnull
    public static byte[] newRandomNodeId() {
        UUID uuid = UUID.randomUUID();
        byte[] uuidBytes = new byte[16];
        ByteBuffer.wrap(uuidBytes).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return uuidBytes;
    }

    @Nonnull
    static byte[] newSequentialNodeId() {
        long nodeIdAsLong = nodeIdState.getAndIncrement();
        byte[] uuidBytes = new byte[16];
        ByteBuffer.wrap(uuidBytes).order(ByteOrder.BIG_ENDIAN).putLong(0L).putLong(nodeIdAsLong);
        return uuidBytes;
    }

    @Nonnull
    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return "0x" + new String(hexChars).replaceFirst("^0+(?!$)", "");
    }

    @Nonnull
    static String nodeIdPath(@Nullable Node node) {
        ArrayList<String> nodeIds = Lists.newArrayList();
        do {
            if (node != null) {
                nodeIds.add(NodeHelpers.bytesToHex(node.getId()));
                node = node.getParentNode();
                continue;
            }
            nodeIds.add("<null>");
        } while (node != null);
        Collections.reverse(nodeIds);
        return String.join((CharSequence)", ", nodeIds);
    }

    @Nonnull
    static RTree.Rectangle computeMbr(@Nonnull Iterable<? extends NodeSlot> slots) {
        RTree.Rectangle mbr = null;
        for (NodeSlot nodeSlot : slots) {
            if (nodeSlot instanceof ItemSlot) {
                RTree.Point position = ((ItemSlot)nodeSlot).getPosition();
                if (mbr == null) {
                    mbr = RTree.Rectangle.fromPoint(position);
                    continue;
                }
                mbr = mbr.unionWith(position);
                continue;
            }
            if (nodeSlot instanceof ChildSlot) {
                RTree.Rectangle mbrForSlot = ((ChildSlot)nodeSlot).getMbr();
                if (mbr == null) {
                    mbr = mbrForSlot;
                    continue;
                }
                mbr = mbr.unionWith(mbrForSlot);
                continue;
            }
            throw new IllegalStateException("slot of unknown kind");
        }
        return Objects.requireNonNull(mbr);
    }
}

