/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public enum NodeKind {
    LEAF(0),
    INTERMEDIATE(1);

    private final byte serialized;

    private NodeKind(byte serialized) {
        this.serialized = serialized;
    }

    public byte getSerialized() {
        return this.serialized;
    }

    @Nonnull
    static NodeKind fromSerializedNodeKind(byte serializedNodeKind) {
        NodeKind nodeKind;
        switch (serializedNodeKind) {
            case 0: {
                nodeKind = LEAF;
                break;
            }
            case 1: {
                nodeKind = INTERMEDIATE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown node kind");
            }
        }
        Verify.verify(nodeKind.getSerialized() == serializedNodeKind);
        return nodeKind;
    }
}

