/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.math.BigInteger;
import javax.annotation.Nonnull;

public interface NodeSlot {
    public static int compareHilbertValueKeyPair(@Nonnull BigInteger hilbertValue1, @Nonnull Tuple key1, @Nonnull BigInteger hilbertValue2, @Nonnull Tuple key2) {
        int hilbertValueCompare = hilbertValue1.compareTo(hilbertValue2);
        if (hilbertValueCompare != 0) {
            return hilbertValueCompare;
        }
        return TupleHelpers.compare(key1, key2);
    }

    @Nonnull
    public BigInteger getSmallestHilbertValue();

    @Nonnull
    public BigInteger getLargestHilbertValue();

    @Nonnull
    public Tuple getSmallestKey();

    @Nonnull
    default public Tuple getSmallestKeySuffix() {
        return this.getSmallestKey().getNestedTuple(1);
    }

    @Nonnull
    public Tuple getLargestKey();

    @Nonnull
    default public Tuple getLargestKeySuffix() {
        return this.getLargestKey().getNestedTuple(1);
    }

    @Nonnull
    public Tuple getSlotKey(boolean var1);

    @Nonnull
    public Tuple getSlotValue();

    default public int compareSmallestHilbertValueAndKey(@Nonnull BigInteger hilbertValue, @Nonnull Tuple key) {
        return NodeSlot.compareHilbertValueKeyPair(this.getSmallestHilbertValue(), this.getSmallestKey(), hilbertValue, key);
    }

    default public int compareLargestHilbertValueAndKey(@Nonnull BigInteger hilbertValue, @Nonnull Tuple key) {
        return NodeSlot.compareHilbertValueKeyPair(this.getLargestHilbertValue(), this.getLargestKey(), hilbertValue, key);
    }
}

