/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.rtree.ChildSlot;
import com.apple.foundationdb.async.rtree.OnReadListener;
import com.apple.foundationdb.async.rtree.OnWriteListener;
import com.apple.foundationdb.async.rtree.RTree;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

class NodeSlotIndexAdapter {
    private static final byte[] emptyArray = new byte[0];
    @Nonnull
    private final Subspace nodeSlotIndexSubspace;
    @Nonnull
    private final OnWriteListener onWriteListener;
    @Nonnull
    private final OnReadListener onReadListener;

    NodeSlotIndexAdapter(@Nonnull Subspace nodeSlotIndexSubspace, @Nonnull OnWriteListener onWriteListener, @Nonnull OnReadListener onReadListener) {
        this.nodeSlotIndexSubspace = nodeSlotIndexSubspace;
        this.onWriteListener = onWriteListener;
        this.onReadListener = onReadListener;
    }

    @Nonnull
    public Subspace getNodeSlotIndexSubspace() {
        return this.nodeSlotIndexSubspace;
    }

    @Nonnull
    CompletableFuture<byte[]> scanIndexForNodeId(@Nonnull ReadTransaction transaction, int level, @Nonnull BigInteger hilbertValue, @Nonnull Tuple key, boolean isInsertUpdate) {
        ArrayList<Object> keys = Lists.newArrayList();
        keys.add(level);
        keys.add(hilbertValue);
        keys.addAll(key.getItems());
        byte[] packedKey = this.nodeSlotIndexSubspace.pack(Tuple.fromList(keys));
        return AsyncUtil.collect(transaction.getRange(new Range(packedKey, this.nodeSlotIndexSubspace.pack(Tuple.from(level + 1))), 1, false, StreamingMode.WANT_ALL)).thenCompose(keyValues -> {
            Verify.verify(keyValues.size() <= 1);
            if (!keyValues.isEmpty()) {
                KeyValue keyValue = (KeyValue)keyValues.get(0);
                this.onReadListener.onSlotIndexEntryRead(keyValue.getKey());
                Tuple indexKeyTuple = Tuple.fromBytes(keyValue.getKey());
                return CompletableFuture.completedFuture(this.getNodeIdFromIndexKeyTuple(indexKeyTuple));
            }
            if (!isInsertUpdate && level > 0) {
                return CompletableFuture.completedFuture(RTree.rootId);
            }
            return AsyncUtil.collect(transaction.getRange(new Range(this.nodeSlotIndexSubspace.pack(Tuple.from(level)), packedKey), 1, true, StreamingMode.WANT_ALL)).thenApply(previousKeyValues -> {
                Verify.verify(previousKeyValues.size() <= 1);
                if (previousKeyValues.isEmpty()) {
                    return RTree.rootId;
                }
                KeyValue previousKeyValue = (KeyValue)previousKeyValues.get(0);
                this.onReadListener.onSlotIndexEntryRead(previousKeyValue.getKey());
                if (!isInsertUpdate) {
                    return null;
                }
                Tuple indexKeyTuple = Tuple.fromBytes(previousKeyValue.getKey());
                return this.getNodeIdFromIndexKeyTuple(indexKeyTuple);
            });
        });
    }

    void writeChildSlot(@Nonnull Transaction transaction, int level, @Nonnull ChildSlot childSlot) {
        Tuple indexKeyTuple = this.createIndexKeyTuple(level, childSlot);
        byte[] packedKey = this.nodeSlotIndexSubspace.pack(indexKeyTuple);
        transaction.set(packedKey, emptyArray);
        this.onWriteListener.onSlotIndexEntryWritten(packedKey);
    }

    void clearChildSlot(@Nonnull Transaction transaction, int level, @Nonnull ChildSlot childSlot) {
        Tuple indexKeyTuple = this.createIndexKeyTuple(level, childSlot);
        byte[] packedKey = this.nodeSlotIndexSubspace.pack(indexKeyTuple);
        transaction.clear(packedKey);
        this.onWriteListener.onSlotIndexEntryCleared(packedKey);
    }

    @Nonnull
    private Tuple createIndexKeyTuple(int level, @Nonnull ChildSlot childSlot) {
        return this.createIndexKeyTuple(level, childSlot.getLargestHilbertValue(), childSlot.getLargestKey(), childSlot.getChildId());
    }

    @Nonnull
    private Tuple createIndexKeyTuple(int level, @Nonnull BigInteger largestHilbertValue, @Nonnull Tuple largestKey, @Nonnull byte[] nodeId) {
        ArrayList<Object> keys = Lists.newArrayList();
        keys.add(level);
        keys.add(largestHilbertValue);
        keys.addAll(largestKey.getItems());
        keys.add(nodeId);
        return Tuple.fromList(keys);
    }

    @Nonnull
    private byte[] getNodeIdFromIndexKeyTuple(Tuple tuple) {
        return tuple.getBytes(tuple.size() - 1);
    }
}

