/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.async.rtree;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.rtree.RTree;
import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RTreeHilbertCurveHelpers {
    private static final long nullReplacement = Long.MIN_VALUE;

    private RTreeHilbertCurveHelpers() {
    }

    public static BigInteger hilbertValue(@Nonnull RTree.Point point) {
        int numBits = 64;
        long[] shiftedCoordinates = new long[point.getNumDimensions()];
        for (int i = 0; i < point.getNumDimensions(); ++i) {
            Long coordinateAsLong = (Long)point.getCoordinateAsNumber(i);
            long coordinate = coordinateAsLong == null ? Long.MIN_VALUE : coordinateAsLong;
            shiftedCoordinates[i] = RTreeHilbertCurveHelpers.shiftCoordinate(coordinate);
        }
        return RTreeHilbertCurveHelpers.toIndex(numBits, RTreeHilbertCurveHelpers.transposedIndex(numBits, shiftedCoordinates));
    }

    private static long shiftCoordinate(long coordinate) {
        return coordinate < 0L ? Long.MAX_VALUE - (-coordinate - 1L) : coordinate | Long.MIN_VALUE;
    }

    private static BigInteger toIndex(int numBits, long ... transposedIndexes) {
        int length = numBits * transposedIndexes.length;
        byte[] b = new byte[length / 8 + 1];
        int bIndex = length - 1;
        long mask = 1L << numBits - 1;
        for (int i = 0; i < numBits; ++i) {
            for (long transposedIndex : transposedIndexes) {
                if ((transposedIndex & mask) != 0L) {
                    int n = b.length - 1 - bIndex / 8;
                    b[n] = (byte)(b[n] | 1 << bIndex % 8);
                }
                --bIndex;
            }
            mask >>>= 1;
        }
        return new BigInteger(1, b);
    }

    private static long[] transposedIndex(int numBits, long ... unsignedPoints) {
        long t2;
        int i;
        long q;
        long m4 = 1L << numBits - 1;
        int n = unsignedPoints.length;
        long[] x = Arrays.copyOf(unsignedPoints, n);
        for (q = m4; q != 1L; q >>>= 1) {
            long p = q - 1L;
            for (i = 0; i < n; ++i) {
                if ((x[i] & q) != 0L) {
                    x[0] = x[0] ^ p;
                    continue;
                }
                t2 = (x[0] ^ x[i]) & p;
                x[0] = x[0] ^ t2;
                int n2 = i;
                x[n2] = x[n2] ^ t2;
            }
        }
        for (i = 1; i < n; ++i) {
            int n3 = i;
            x[n3] = x[n3] ^ x[i - 1];
        }
        t2 = 0L;
        for (q = m4; q != 1L; q >>>= 1) {
            if ((x[n - 1] & q) == 0L) continue;
            t2 ^= q - 1L;
        }
        i = 0;
        while (i < n) {
            int n4 = i++;
            x[n4] = x[n4] ^ t2;
        }
        return x;
    }
}

