/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.clientlog;

import com.apple.foundationdb.LocalityUtil;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.clientlog.DatabaseClientLogEvents;
import com.apple.foundationdb.clientlog.FDBClientLogEvents;
import com.apple.foundationdb.clientlog.TupleKeyCountTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class DatabaseClientLogEventCounter
implements DatabaseClientLogEvents.EventConsumer {
    @Nonnull
    private final TupleKeyCountTree root;
    private final boolean countReads;
    private final boolean countWrites;
    private final boolean countSingleKeys;
    private final boolean countRanges;
    private final boolean byAddress;

    public DatabaseClientLogEventCounter(@Nonnull TupleKeyCountTree root, boolean countReads, boolean countWrites, boolean countSingleKeys, boolean countRanges, boolean byAddress) {
        this.root = root;
        this.countReads = countReads;
        this.countWrites = countWrites;
        this.countSingleKeys = countSingleKeys;
        this.countRanges = countRanges;
        this.byAddress = byAddress;
    }

    @Override
    public CompletableFuture<Void> accept(@Nonnull Transaction tr, @Nonnull FDBClientLogEvents.Event event) {
        switch (event.getType()) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.countReads || !this.countSingleKeys) break;
                return this.addKey(tr, ((FDBClientLogEvents.EventGet)event).getKey());
            }
            case 2: {
                if (!this.countReads || !this.countRanges) break;
                return this.addRange(tr, ((FDBClientLogEvents.EventGetRange)event).getRange());
            }
            case 3: {
                if (!this.countWrites) break;
                return this.addCommit(tr, ((FDBClientLogEvents.EventCommit)event).getCommitRequest());
            }
            case 4: {
                if (!this.countReads || !this.countSingleKeys) break;
                return this.addKey(tr, ((FDBClientLogEvents.EventGetError)event).getKey());
            }
            case 5: {
                if (!this.countReads || !this.countRanges) break;
                return this.addRange(tr, ((FDBClientLogEvents.EventGetRangeError)event).getRange());
            }
            case 6: {
                if (!this.countWrites) break;
                return this.addCommit(tr, ((FDBClientLogEvents.EventCommitError)event).getCommitRequest());
            }
        }
        return AsyncUtil.DONE;
    }

    protected CompletableFuture<Void> addKey(@Nonnull Transaction tr, @Nonnull byte[] key) {
        if (this.byAddress) {
            return this.addKeyAddresses(tr, key);
        }
        this.root.add(key);
        return AsyncUtil.DONE;
    }

    protected CompletableFuture<Void> addKeyAddresses(@Nonnull Transaction tr, @Nonnull byte[] key) {
        return LocalityUtil.getAddressesForKey(tr, key).handle((addresses, ex) -> {
            if (ex == null) {
                for (String address : addresses) {
                    this.root.addPrefixChild(address).add(key);
                }
            }
            return null;
        });
    }

    protected CompletableFuture<Void> addRange(@Nonnull Transaction tr, @Nonnull Range range) {
        if (this.byAddress) {
            return this.addKeyAddresses(tr, range.begin).thenCompose(vignore -> {
                CloseableAsyncIterator<byte[]> boundaryKeys = LocalityUtil.getBoundaryKeys(tr, range.begin, range.end);
                return AsyncUtil.whileTrue(() -> boundaryKeys.onHasNext().thenCompose(hasNext -> {
                    if (hasNext.booleanValue()) {
                        byte[] boundaryKey = (byte[])boundaryKeys.next();
                        if (Arrays.equals(boundaryKey, range.begin)) {
                            return AsyncUtil.READY_TRUE;
                        }
                        return this.addKeyAddresses(tr, boundaryKey).thenApply(vignore2 -> true);
                    }
                    return AsyncUtil.READY_FALSE;
                })).whenComplete((v, t2) -> boundaryKeys.close());
            });
        }
        this.root.add(range.begin);
        return AsyncUtil.DONE;
    }

    protected CompletableFuture<Void> addCommit(@Nonnull Transaction tr, @Nonnull FDBClientLogEvents.CommitRequest commitRequest) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (FDBClientLogEvents.Mutation mutation : commitRequest.getMutations()) {
            CompletableFuture<Void> future = AsyncUtil.DONE;
            if (mutation.getType() == 1) {
                if (this.countRanges) {
                    future = this.addRange(tr, new Range(mutation.getKey(), mutation.getParam()));
                }
            } else if (this.countSingleKeys) {
                future = this.addKey(tr, mutation.getKey());
            }
            if (future.isDone()) continue;
            futures.add(future);
        }
        if (futures.isEmpty()) {
            return AsyncUtil.DONE;
        }
        return AsyncUtil.whenAll(futures);
    }
}

