/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.clientlog;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionOptions;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.clientlog.FDBClientLogEvents;
import com.apple.foundationdb.clientlog.VersionFromTimestamp;
import com.apple.foundationdb.system.SystemKeyspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class DatabaseClientLogEvents {
    @Nonnull
    private byte[] startKey;
    @Nonnull
    private byte[] endKey;
    @Nullable
    private Instant earliestTimestamp;
    @Nullable
    private Instant latestTimestamp;
    private int eventCount;
    private boolean more;

    private DatabaseClientLogEvents(@Nonnull byte[] startKey, @Nonnull byte[] endKey) {
        this.startKey = startKey;
        this.endKey = endKey;
    }

    @Nullable
    public Instant getEarliestTimestamp() {
        return this.earliestTimestamp;
    }

    @Nullable
    public Instant getLatestTimestamp() {
        return this.latestTimestamp;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public boolean hasMore() {
        return this.more;
    }

    private AsyncIterable<KeyValue> getRange(@Nonnull ReadTransaction tr) {
        return tr.getRange(this.startKey, this.endKey);
    }

    private void updateForEvent(@Nonnull Instant eventTimestamp) {
        if (this.earliestTimestamp == null) {
            this.earliestTimestamp = eventTimestamp;
        }
        this.latestTimestamp = eventTimestamp;
    }

    private void updateForTransaction(@Nullable byte[] lastProcessedKey) {
        this.startKey = lastProcessedKey != null ? ByteArrayUtil.join(lastProcessedKey, new byte[1]) : this.endKey;
    }

    private void updateForRun(int rangeEventCount, boolean limitReached) {
        this.eventCount += rangeEventCount;
        this.more = limitReached;
    }

    @Nonnull
    public static CompletableFuture<DatabaseClientLogEvents> forEachEvent(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, @Nonnull Function<ReadTransaction, CompletableFuture<Long[]>> versionRangeProducer, int eventCountLimit, long timeLimitMillis) {
        EventRunner runner = new EventRunner(database, executor, callback, versionRangeProducer, eventCountLimit, timeLimitMillis);
        return runner.run();
    }

    @Nonnull
    public static CompletableFuture<DatabaseClientLogEvents> forEachEventBetweenVersions(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, @Nullable Long startVersion, @Nullable Long endVersion, int eventCountLimit, long timeLimitMillis) {
        return DatabaseClientLogEvents.forEachEvent(database, executor, callback, tignore -> CompletableFuture.completedFuture(new Long[]{startVersion, endVersion}), eventCountLimit, timeLimitMillis);
    }

    @Nonnull
    public static CompletableFuture<DatabaseClientLogEvents> forEachEventBetweenTimestamps(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, @Nullable Instant startTimestamp, @Nullable Instant endTimestamp, int eventCountLimit, long timeLimitMillis) {
        return DatabaseClientLogEvents.forEachEvent(database, executor, callback, tr -> {
            CompletableFuture<Object> startVersion = startTimestamp == null ? CompletableFuture.completedFuture(null) : VersionFromTimestamp.lastVersionBefore(tr, startTimestamp);
            CompletableFuture<Object> endVersion = endTimestamp == null ? CompletableFuture.completedFuture(null) : VersionFromTimestamp.nextVersionAfter(tr, endTimestamp);
            return startVersion.thenCombine(endVersion, (s2, e) -> new Long[]{s2, e});
        }, eventCountLimit, timeLimitMillis);
    }

    public CompletableFuture<DatabaseClientLogEvents> forEachEventContinued(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, int eventCountLimit, long timeLimitMillis) {
        EventRunner runner = new EventRunner(database, executor, callback, this, eventCountLimit, timeLimitMillis);
        return runner.run();
    }

    protected static class EventRunner
    implements FDBClientLogEvents.EventConsumer {
        @Nonnull
        private final Database database;
        @Nonnull
        private final Executor executor;
        @Nullable
        private Transaction tr;
        @Nonnull
        private final EventConsumer callback;
        @Nullable
        private DatabaseClientLogEvents events;
        @Nullable
        private final Function<ReadTransaction, CompletableFuture<Long[]>> versionRangeProducer;
        private int eventCount;
        private final int eventCountLimit;
        private long startTimeMillis = System.currentTimeMillis();
        private final long timeLimitMillis;
        private boolean limitReached;

        public EventRunner(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, @Nonnull Function<ReadTransaction, CompletableFuture<Long[]>> versionRangeProducer, int eventCountLimit, long timeLimitMillis) {
            this.database = database;
            this.executor = executor;
            this.callback = callback;
            this.versionRangeProducer = versionRangeProducer;
            this.eventCountLimit = eventCountLimit;
            this.timeLimitMillis = timeLimitMillis;
        }

        public EventRunner(@Nonnull Database database, @Nonnull Executor executor, @Nonnull EventConsumer callback, @Nonnull DatabaseClientLogEvents events, int eventCountLimit, long timeLimitMillis) {
            this.database = database;
            this.executor = executor;
            this.callback = callback;
            this.events = events;
            this.versionRangeProducer = null;
            this.eventCountLimit = eventCountLimit;
            this.timeLimitMillis = timeLimitMillis;
        }

        public CompletableFuture<DatabaseClientLogEvents> run() {
            return AsyncUtil.whileTrue(this::loop).thenApply(vignore -> {
                this.events.updateForRun(this.eventCount, this.limitReached);
                return this.events;
            });
        }

        private CompletableFuture<Boolean> loop() {
            this.tr = this.database.createTransaction(this.executor);
            TransactionOptions transactionOptions = this.tr.options();
            transactionOptions.setReadSystemKeys();
            transactionOptions.setReadLockAware();
            if (this.events == null) {
                return this.versionRangeProducer.apply(this.tr).thenCompose(versions -> {
                    Long startVersion = versions[0];
                    byte[] startKey = startVersion == null ? SystemKeyspace.CLIENT_LOG_KEY_PREFIX : FDBClientLogEvents.eventKeyForVersion(startVersion);
                    Long endVersion = versions[1];
                    byte[] endKey = endVersion == null ? ByteArrayUtil.strinc(SystemKeyspace.CLIENT_LOG_KEY_PREFIX) : FDBClientLogEvents.eventKeyForVersion(endVersion);
                    this.events = new DatabaseClientLogEvents(startKey, endKey);
                    return this.loopBody();
                });
            }
            return this.loopBody();
        }

        private CompletableFuture<Boolean> loopBody() {
            AsyncIterable<KeyValue> range = this.events.getRange(this.tr);
            return ((CompletableFuture)FDBClientLogEvents.forEachEvent(range, this).thenApply(lastProcessedKey -> {
                this.events.updateForTransaction((byte[])lastProcessedKey);
                return false;
            })).handle((b, t2) -> {
                if (this.tr != null) {
                    this.tr.close();
                    this.tr = null;
                }
                if (t2 != null) {
                    Throwable tt = t2;
                    if (tt instanceof CompletionException) {
                        tt = tt.getCause();
                    }
                    if (tt instanceof FDBException && ((FDBException)tt).isRetryable()) {
                        return true;
                    }
                    throw t2 instanceof RuntimeException ? (RuntimeException)t2 : new RuntimeException((Throwable)t2);
                }
                return b;
            });
        }

        @Override
        public CompletableFuture<Void> accept(FDBClientLogEvents.Event event) {
            ++this.eventCount;
            this.events.updateForEvent(event.getStartTimestamp());
            return this.callback.accept(this.tr, event);
        }

        @Override
        public boolean more() {
            if (this.eventCount >= this.eventCountLimit || System.currentTimeMillis() - this.startTimeMillis >= this.timeLimitMillis) {
                this.limitReached = true;
            }
            return !this.limitReached;
        }
    }

    @FunctionalInterface
    public static interface EventConsumer {
        public CompletableFuture<Void> accept(@Nonnull Transaction var1, @Nonnull FDBClientLogEvents.Event var2);
    }
}

