/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.clientlog;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.system.SystemKeyspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
public class FDBClientLogEvents {
    public static final int GET_VERSION_LATENCY = 0;
    public static final int GET_LATENCY = 1;
    public static final int GET_RANGE_LATENCY = 2;
    public static final int COMMIT_LATENCY = 3;
    public static final int ERROR_GET = 4;
    public static final int ERROR_GET_RANGE = 5;
    public static final int ERROR_COMMIT = 6;
    public static final long PROTOCOL_VERSION_5_2 = 1142507640513888257L;
    public static final long PROTOCOL_VERSION_6_0 = 1142507641017270273L;
    public static final long PROTOCOL_VERSION_6_1 = 1142507688010579969L;
    public static final long PROTOCOL_VERSION_6_2 = 1142507688027029505L;
    public static final long PROTOCOL_VERSION_6_3 = 1142507688043806721L;
    public static final long PROTOCOL_VERSION_7_0 = 1142507688261910529L;
    public static final long PROTOCOL_VERSION_7_1 = 1142507688278687744L;
    public static final long PROTOCOL_VERSION_7_2 = 1142507688295399424L;
    public static final long PROTOCOL_VERSION_7_3 = 1142507688312176640L;
    private static final long[] SUPPORTED_PROTOCOL_VERSIONS = new long[]{1142507640513888257L, 1142507641017270273L, 1142507688010579969L, 1142507688027029505L, 1142507688043806721L, 1142507688261910529L, 1142507688278687744L, 1142507688295399424L, 1142507688312176640L};
    public static final int EVENT_KEY_VERSION_END_INDEX = 42;
    public static final int EVENT_KEY_ID_START_INDEX = 43;
    public static final int EVENT_KEY_ID_END_INDEX = 59;
    public static final int EVENT_KEY_CHUNK_INDEX = 60;
    private static final Map<Integer, MutationType> MUTATION_TYPE_BY_CODE = FDBClientLogEvents.buildMutationTypeMap();

    private static Map<Integer, MutationType> buildMutationTypeMap() {
        HashMap<Integer, MutationType> result = new HashMap<Integer, MutationType>();
        for (MutationType mutationType : MutationType.values()) {
            result.put(mutationType.code(), mutationType);
        }
        return result;
    }

    public static CompletableFuture<Void> deserializeEvents(@Nonnull ByteBuffer buffer, @Nonnull AsyncConsumer<Event> callback) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long protocolVersion = buffer.getLong();
        if (Longs.indexOf(SUPPORTED_PROTOCOL_VERSIONS, protocolVersion) < 0) {
            throw new IllegalStateException("Unknown protocol version: 0x" + Long.toString(protocolVersion, 16));
        }
        return AsyncUtil.whileTrue(() -> {
            Event event;
            int dcIdLength;
            int type = buffer.getInt();
            double startTime = buffer.getDouble();
            String dcId = "";
            if (protocolVersion >= 1142507688043806721L && (dcIdLength = buffer.getInt()) > 0) {
                byte[] dcIdBytes = new byte[dcIdLength];
                buffer.get(dcIdBytes);
                dcId = new String(dcIdBytes, StandardCharsets.UTF_8);
            }
            String tenant = "";
            if (protocolVersion >= 1142507688278687744L) {
                int tenantLength;
                boolean present;
                boolean bl = present = buffer.get() != 0;
                if (present && (tenantLength = buffer.getInt()) > 0) {
                    byte[] tenantBytes = new byte[tenantLength];
                    buffer.get(tenantBytes);
                    tenant = new String(tenantBytes, StandardCharsets.UTF_8);
                }
            }
            switch (type) {
                case 0: {
                    event = new EventGetVersion(startTime, dcId, tenant, buffer.getDouble(), protocolVersion < 1142507688027029505L ? 0 : buffer.getInt(), protocolVersion < 1142507688043806721L ? 0L : buffer.getLong());
                    break;
                }
                case 1: {
                    event = new EventGet(startTime, dcId, tenant, buffer.getDouble(), buffer.getInt(), FDBClientLogEvents.deserializeByteArray(buffer));
                    break;
                }
                case 2: {
                    event = new EventGetRange(startTime, dcId, tenant, buffer.getDouble(), buffer.getInt(), FDBClientLogEvents.deserializeRange(buffer));
                    break;
                }
                case 3: {
                    event = new EventCommit(startTime, dcId, tenant, buffer.getDouble(), buffer.getInt(), buffer.getInt(), protocolVersion < 1142507688043806721L ? 0L : buffer.getLong(), FDBClientLogEvents.deserializeCommit(protocolVersion, buffer));
                    break;
                }
                case 4: {
                    event = new EventGetError(startTime, dcId, tenant, buffer.getInt(), FDBClientLogEvents.deserializeByteArray(buffer));
                    break;
                }
                case 5: {
                    event = new EventGetRangeError(startTime, dcId, tenant, buffer.getInt(), FDBClientLogEvents.deserializeRange(buffer));
                    break;
                }
                case 6: {
                    event = new EventCommitError(startTime, dcId, tenant, buffer.getInt(), FDBClientLogEvents.deserializeCommit(protocolVersion, buffer));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event type: " + type);
                }
            }
            return callback.accept(event).thenApply(vignore -> buffer.hasRemaining());
        });
    }

    @Nonnull
    protected static byte[] deserializeByteArray(@Nonnull ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] result = new byte[length];
        buffer.get(result);
        return result;
    }

    @Nonnull
    protected static Range deserializeRange(@Nonnull ByteBuffer buffer) {
        return new Range(FDBClientLogEvents.deserializeByteArray(buffer), FDBClientLogEvents.deserializeByteArray(buffer));
    }

    @Nonnull
    protected static Range[] deserializeRangeArray(@Nonnull ByteBuffer buffer) {
        int length = buffer.getInt();
        Range[] result = new Range[length];
        for (int i = 0; i < length; ++i) {
            result[i] = FDBClientLogEvents.deserializeRange(buffer);
        }
        return result;
    }

    @Nonnull
    protected static Mutation deserializeMutation(@Nonnull ByteBuffer buffer) {
        return new Mutation(buffer.get(), FDBClientLogEvents.deserializeByteArray(buffer), FDBClientLogEvents.deserializeByteArray(buffer));
    }

    @Nonnull
    protected static Mutation[] deserializeMutationArray(@Nonnull ByteBuffer buffer) {
        int length = buffer.getInt();
        Mutation[] result = new Mutation[length];
        for (int i = 0; i < length; ++i) {
            result[i] = FDBClientLogEvents.deserializeMutation(buffer);
        }
        return result;
    }

    @Nonnull
    protected static CommitRequest deserializeCommit(long protocolVersion, @Nonnull ByteBuffer buffer) {
        Range[] readConflictRanges = FDBClientLogEvents.deserializeRangeArray(buffer);
        Range[] writeConflictRanges = FDBClientLogEvents.deserializeRangeArray(buffer);
        Mutation[] mutations = FDBClientLogEvents.deserializeMutationArray(buffer);
        long snapshotVersion = buffer.getLong();
        boolean reportConflictingKeys = false;
        if (protocolVersion >= 1142507688043806721L) {
            reportConflictingKeys = buffer.get() != 0;
        }
        boolean lockAware = false;
        SpanContext spanContext = null;
        if (protocolVersion >= 1142507688278687744L) {
            boolean present;
            lockAware = buffer.get() != 0;
            boolean bl = present = buffer.get() != 0;
            if (present) {
                spanContext = new SpanContext(new Uid(buffer.getLong(), buffer.getLong()), buffer.getLong(), buffer.get());
            }
        }
        return new CommitRequest(readConflictRanges, writeConflictRanges, mutations, snapshotVersion, reportConflictingKeys, lockAware, spanContext);
    }

    @Nonnull
    public static CompletableFuture<byte[]> forEachEvent(@Nonnull AsyncIterable<KeyValue> range, @Nonnull EventConsumer callback) {
        EventDeserializer deserializer = new EventDeserializer(callback);
        Iterator iterator = range.iterator();
        return AsyncUtil.whileTrue(() -> FDBClientLogEvents.lambda$forEachEvent$4((AsyncIterator)iterator, deserializer, callback)).thenApply(vignore -> deserializer.getLastProcessedKey());
    }

    @Nonnull
    public static byte[] eventKeyForVersion(long version) {
        byte[] result = new byte[40];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.put(SystemKeyspace.CLIENT_LOG_KEY_PREFIX);
        buffer.putLong(version);
        return result;
    }

    private FDBClientLogEvents() {
    }

    private static /* synthetic */ CompletableFuture lambda$forEachEvent$4(AsyncIterator iterator, EventDeserializer deserializer, EventConsumer callback) {
        return iterator.onHasNext().thenCompose(hasNext -> hasNext != false ? deserializer.accept((KeyValue)iterator.next()).thenApply(vignore -> callback.more()) : AsyncUtil.READY_FALSE);
    }

    @FunctionalInterface
    public static interface AsyncConsumer<T> {
        public CompletableFuture<Void> accept(T var1);
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class Mutation {
        public static final int SET_VALUE = 0;
        public static final int CLEAR_RANGE = 1;
        public static final int MIN_V2 = 18;
        public static final int AND_V2 = 19;
        private final int type;
        @Nonnull
        private final byte[] key;
        @Nonnull
        private final byte[] param;

        public Mutation(int type, @Nonnull byte[] key, @Nonnull byte[] param) {
            this.type = type;
            this.key = key;
            this.param = param;
        }

        public int getType() {
            return this.type;
        }

        @Nonnull
        public byte[] getKey() {
            return this.key;
        }

        @Nonnull
        public byte[] getParam() {
            return this.param;
        }

        public String toString() {
            String typeName = this.type == 0 ? "SET_VALUE" : (this.type == 1 ? "CLEAR_RANGE" : (this.type == 18 ? "MIN_V2" : (this.type == 19 ? "AND_V2" : (MUTATION_TYPE_BY_CODE.containsKey(this.type) ? MUTATION_TYPE_BY_CODE.get(this.type).name() : Integer.toString(this.type)))));
            return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("type=" + typeName).add("key=" + ByteArrayUtil.printable(this.key)).add("param=" + ByteArrayUtil.printable(this.param)).toString();
        }
    }

    protected static class SpanContext {
        private final Uid traceID;
        private final long spanID;
        private final byte flags;

        public Uid getTraceID() {
            return this.traceID;
        }

        public long getSpanID() {
            return this.spanID;
        }

        public byte getFlags() {
            return this.flags;
        }

        public SpanContext(Uid traceID, long spanID, byte flags) {
            this.traceID = traceID;
            this.spanID = spanID;
            this.flags = flags;
        }

        public String toString() {
            return new StringJoiner(", ", CommitRequest.class.getSimpleName() + "[", "]").add("traceID=" + String.valueOf(this.traceID)).add("spanID=" + this.spanID).add("flags=" + this.flags).toString();
        }
    }

    protected static class Uid {
        private final long part1;
        private final long part2;

        public Uid(long part1, long part2) {
            this.part1 = part1;
            this.part2 = part2;
        }

        public String toString() {
            String hexPart1 = Long.toHexString(this.part1);
            String hexPart2 = Long.toHexString(this.part2);
            return "0".repeat(16 - hexPart1.length()) + hexPart1 + "0".repeat(16 - hexPart2.length()) + hexPart2;
        }
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class CommitRequest {
        @Nonnull
        private final Range[] readConflictRanges;
        @Nonnull
        private final Range[] writeConflictRanges;
        @Nonnull
        private final Mutation[] mutations;
        private final long snapshotVersion;
        private final boolean reportConflictingKeys;
        private final boolean lockAware;
        @Nullable
        private final SpanContext spanContext;

        public CommitRequest(@Nonnull Range[] readConflictRanges, @Nonnull Range[] writeConflictRanges, @Nonnull Mutation[] mutations, long snapshotVersion, boolean reportConflictingKeys, boolean lockAware, @Nullable SpanContext spanContext) {
            this.readConflictRanges = readConflictRanges;
            this.writeConflictRanges = writeConflictRanges;
            this.mutations = mutations;
            this.snapshotVersion = snapshotVersion;
            this.reportConflictingKeys = reportConflictingKeys;
            this.lockAware = lockAware;
            this.spanContext = spanContext;
        }

        @Nonnull
        public Range[] getReadConflictRanges() {
            return this.readConflictRanges;
        }

        @Nonnull
        public Range[] getWriteConflictRanges() {
            return this.writeConflictRanges;
        }

        @Nonnull
        public Mutation[] getMutations() {
            return this.mutations;
        }

        public long getSnapshotVersion() {
            return this.snapshotVersion;
        }

        public boolean isReportConflictingKeys() {
            return this.reportConflictingKeys;
        }

        public boolean isLockAware() {
            return this.lockAware;
        }

        @Nullable
        public SpanContext getSpanContext() {
            return this.spanContext;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", CommitRequest.class.getSimpleName() + "[", "]").add("readConflictRanges=" + Arrays.toString(this.readConflictRanges)).add("writeConflictRanges=" + Arrays.toString(this.writeConflictRanges)).add("mutations=" + Arrays.toString(this.mutations)).add("snapshotVersion=" + this.snapshotVersion).add("reportConflictingKeys=" + this.reportConflictingKeys).add("lockAware=" + this.lockAware);
            if (this.spanContext != null) {
                joiner.add("spanContext=" + String.valueOf(this.spanContext));
            }
            return joiner.toString();
        }
    }

    protected static class EventDeserializer
    implements AsyncConsumer<KeyValue> {
        @Nonnull
        private final AsyncConsumer<Event> callback;
        @Nullable
        private ByteBuffer splitBuffer;
        private byte[] splitId;
        private int splitPosition;
        private byte[] lastProcessedKey;

        public EventDeserializer(@Nonnull AsyncConsumer<Event> callback) {
            this.callback = callback;
        }

        @Override
        public CompletableFuture<Void> accept(KeyValue keyValue) {
            byte[] transactionId = Arrays.copyOfRange(keyValue.getKey(), 43, 59);
            ByteBuffer keyBuffer = ByteBuffer.wrap(keyValue.getKey());
            keyBuffer.position(60);
            int chunkNumber = keyBuffer.getInt();
            int numChunks = keyBuffer.getInt();
            if (numChunks == 1) {
                this.splitBuffer = null;
                this.lastProcessedKey = keyValue.getKey();
                return FDBClientLogEvents.deserializeEvents(ByteBuffer.wrap(keyValue.getValue()), this.callback);
            }
            if (chunkNumber == 1) {
                this.splitBuffer = ByteBuffer.allocate(numChunks * keyValue.getValue().length);
                this.splitId = transactionId;
                this.splitPosition = 1;
            } else if (chunkNumber == this.splitPosition && Arrays.equals(transactionId, this.splitId)) {
                if (this.splitBuffer.remaining() < keyValue.getValue().length) {
                    ByteBuffer newBuffer = ByteBuffer.allocate(this.splitBuffer.position() + keyValue.getValue().length);
                    this.splitBuffer.flip();
                    newBuffer.put(this.splitBuffer);
                    this.splitBuffer = newBuffer;
                }
                this.splitBuffer.put(keyValue.getValue());
                ++this.splitPosition;
                if (this.splitPosition == numChunks) {
                    this.splitBuffer.flip();
                    ByteBuffer buffer = this.splitBuffer;
                    this.splitBuffer = null;
                    this.lastProcessedKey = keyValue.getKey();
                    return FDBClientLogEvents.deserializeEvents(buffer, this.callback);
                }
            } else {
                this.splitBuffer = null;
                this.splitPosition = -1;
                this.lastProcessedKey = keyValue.getKey();
            }
            return AsyncUtil.DONE;
        }

        @Nullable
        @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
        public byte[] getLastProcessedKey() {
            return this.lastProcessedKey;
        }
    }

    public static interface EventConsumer
    extends AsyncConsumer<Event> {
        default public boolean more() {
            return true;
        }
    }

    public static class EventGetVersion
    extends Event {
        private final double latency;
        private final int priority;
        private final long readVersion;

        public EventGetVersion(double startTimestamp, String dcId, String tenant, double latency, int priority, long readVersion) {
            super(startTimestamp, dcId, tenant);
            this.latency = latency;
            this.priority = priority;
            this.readVersion = readVersion;
        }

        @Override
        public int getType() {
            return 0;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getReadVersion() {
            return this.readVersion;
        }

        public String toString() {
            return this.toStringBase().add("latency=" + this.latency).add("priority=" + this.priority).add("readVersion=" + this.readVersion).toString();
        }
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class EventGet
    extends Event {
        private final double latency;
        private final int size;
        @Nonnull
        private final byte[] key;

        public EventGet(double startTimestamp, String dcId, String tenant, double latency, int size, @Nonnull byte[] key) {
            super(startTimestamp, dcId, tenant);
            this.latency = latency;
            this.size = size;
            this.key = key;
        }

        @Override
        public int getType() {
            return 1;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getSize() {
            return this.size;
        }

        @Nonnull
        public byte[] getKey() {
            return this.key;
        }

        public String toString() {
            return this.toStringBase().add("latency=" + this.latency).add("size=" + this.size).add("key=" + ByteArrayUtil.printable(this.key)).toString();
        }
    }

    public static class EventGetRange
    extends Event {
        private final double latency;
        private final int size;
        @Nonnull
        private final Range range;

        public EventGetRange(double startTimestamp, String dcId, String tenant, double latency, int size, @Nonnull Range range) {
            super(startTimestamp, dcId, tenant);
            this.latency = latency;
            this.size = size;
            this.range = range;
        }

        @Override
        public int getType() {
            return 2;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getSize() {
            return this.size;
        }

        @Nonnull
        public Range getRange() {
            return this.range;
        }

        public String toString() {
            return this.toStringBase().add("latency=" + this.latency).add("size=" + this.size).add("range=" + String.valueOf(this.range)).toString();
        }
    }

    public static class EventCommit
    extends Event {
        private final double latency;
        private final int numMutations;
        private final int commitBytes;
        private final long commitVersion;
        @Nonnull
        private final CommitRequest commitRequest;

        public EventCommit(double startTimestamp, String dcId, String tenant, double latency, int numMutations, int commitBytes, long commitVersion, @Nonnull CommitRequest commitRequest) {
            super(startTimestamp, dcId, tenant);
            this.latency = latency;
            this.numMutations = numMutations;
            this.commitBytes = commitBytes;
            this.commitVersion = commitVersion;
            this.commitRequest = commitRequest;
        }

        @Override
        public int getType() {
            return 3;
        }

        public double getLatency() {
            return this.latency;
        }

        public int getNumMutations() {
            return this.numMutations;
        }

        public int getCommitBytes() {
            return this.commitBytes;
        }

        @Nonnull
        public CommitRequest getCommitRequest() {
            return this.commitRequest;
        }

        public String toString() {
            return this.toStringBase().add("latency=" + this.latency).add("numMutations=" + this.numMutations).add("commitBytes=" + this.commitBytes).add("commitVersion=" + this.commitVersion).add("commitRequest=" + String.valueOf(this.commitRequest)).toString();
        }
    }

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class EventGetError
    extends Event {
        private final int errorCode;
        @Nonnull
        private final byte[] key;

        public EventGetError(double startTimestamp, String dcId, String tenant, int errorCode, @Nonnull byte[] key) {
            super(startTimestamp, dcId, tenant);
            this.errorCode = errorCode;
            this.key = key;
        }

        @Override
        public int getType() {
            return 4;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Nonnull
        public byte[] getKey() {
            return this.key;
        }

        public String toString() {
            return this.toStringBase().add("errorCode=" + this.errorCode).add("key=" + Arrays.toString(this.key)).toString();
        }
    }

    public static class EventGetRangeError
    extends Event {
        private final int errorCode;
        @Nonnull
        private final Range range;

        public EventGetRangeError(double startTimestamp, String dcId, String tenant, int errorCode, @Nonnull Range range) {
            super(startTimestamp, dcId, tenant);
            this.errorCode = errorCode;
            this.range = range;
        }

        @Override
        public int getType() {
            return 5;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Nonnull
        public Range getRange() {
            return this.range;
        }

        public String toString() {
            return this.toStringBase().add("errorCode=" + this.errorCode).add("range=" + String.valueOf(this.range)).toString();
        }
    }

    public static class EventCommitError
    extends Event {
        private final int errorCode;
        @Nonnull
        private final CommitRequest commitRequest;

        public EventCommitError(double startTimestamp, String dcId, String tenant, int errorCode, @Nonnull CommitRequest commitRequest) {
            super(startTimestamp, dcId, tenant);
            this.errorCode = errorCode;
            this.commitRequest = commitRequest;
        }

        @Override
        public int getType() {
            return 6;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Nonnull
        public CommitRequest getCommitRequest() {
            return this.commitRequest;
        }

        public String toString() {
            return this.toStringBase().add("errorCode=" + this.errorCode).add("commitRequest=" + String.valueOf(this.commitRequest)).toString();
        }
    }

    public static abstract class Event {
        protected final double startTimestamp;
        protected final String dcId;
        protected final String tenant;

        protected Event(double startTimestamp, String dcId, String tenant) {
            this.startTimestamp = startTimestamp;
            this.dcId = dcId;
            this.tenant = tenant;
        }

        public abstract int getType();

        public double getStartTimestampDouble() {
            return this.startTimestamp;
        }

        public Instant getStartTimestamp() {
            long seconds = (long)this.startTimestamp;
            long nanos = (long)((this.startTimestamp - (double)seconds) * 1.0E9);
            return Instant.ofEpochSecond(seconds, nanos);
        }

        public String getStartTimestampString() {
            Instant startTimestamp = this.getStartTimestamp();
            return startTimestamp.atOffset(ZoneId.systemDefault().getRules().getOffset(startTimestamp)).toString();
        }

        public String getDcId() {
            return this.dcId;
        }

        public String getTenant() {
            return this.tenant;
        }

        protected StringJoiner toStringBase() {
            StringJoiner joiner = new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("startTimestamp=" + this.getStartTimestampString());
            if (this.dcId.length() > 0) {
                joiner.add("dcId=" + this.dcId);
            }
            if (this.tenant.length() > 0) {
                joiner.add("tenant=" + this.tenant);
            }
            return joiner;
        }
    }
}

