/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.clientlog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class TupleKeyCountTree {
    @Nonnull
    private final byte[] bytes;
    @Nullable
    private final Object object;
    private int count;
    @Nullable
    private final TupleKeyCountTree parent;
    @Nonnull
    private final Map<byte[], TupleKeyCountTree> children;
    private boolean visible = true;
    private static final Object UNPARSEABLE = new Object(){

        public String toString() {
            return "*unparseable*";
        }
    };
    private static final Comparator<byte[]> BYTES_COMPARATOR = ByteArrayUtil::compareUnsigned;

    public TupleKeyCountTree() {
        this(null, new byte[0], null);
    }

    public TupleKeyCountTree(@Nullable TupleKeyCountTree parent, @Nonnull byte[] bytes, @Nullable Object object) {
        this.bytes = bytes;
        this.object = object;
        this.count = 0;
        this.parent = parent;
        this.children = new TreeMap<byte[], TupleKeyCountTree>(BYTES_COMPARATOR);
    }

    @Nonnull
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean hasObject() {
        return this.object != UNPARSEABLE;
    }

    @Nullable
    public Object getObject() {
        if (this.object == UNPARSEABLE) {
            throw new IllegalStateException("node does not have a parseable object");
        }
        return this.object;
    }

    public void add(@Nonnull Tuple tuple) {
        this.addInternal(tuple.getItems(), 0, tuple.pack(), 0);
    }

    public void add(@Nonnull byte[] packed) {
        int endPosition;
        List<Object> items = null;
        for (endPosition = packed.length; endPosition > 0; --endPosition) {
            try {
                items = Tuple.fromBytes(packed, 0, endPosition).getItems();
                break;
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
        }
        if (items == null) {
            items = new ArrayList();
        }
        if (endPosition < packed.length) {
            items.add(UNPARSEABLE);
        }
        this.addInternal(items, 0, packed, 0);
    }

    private synchronized void addInternal(@Nonnull List<Object> items, int itemPosition, @Nonnull byte[] bytes, int bytePosition) {
        ++this.count;
        if (itemPosition < items.size()) {
            Object childObject = items.get(itemPosition);
            int byteSize = childObject == UNPARSEABLE ? bytes.length - bytePosition : TupleHelpers.packedSizeAsTupleItem(childObject);
            byte[] childBytes = Arrays.copyOfRange(bytes, bytePosition, bytePosition + byteSize);
            TupleKeyCountTree child = this.children.computeIfAbsent(childBytes, b -> this.newChild((byte[])b, childObject));
            child.addInternal(items, itemPosition + 1, bytes, bytePosition + byteSize);
        }
    }

    @Nonnull
    public TupleKeyCountTree addPrefixChild(@Nonnull Object prefix) {
        ++this.count;
        byte[] prefixBytes = Tuple.from(prefix).pack();
        return this.children.computeIfAbsent(prefixBytes, b -> this.newPrefixChild(prefixBytes, prefix));
    }

    @Nonnull
    protected TupleKeyCountTree newPrefixChild(@Nonnull byte[] prefixBytes, @Nonnull Object prefix) {
        return this.newChild(prefixBytes, prefix);
    }

    @Nonnull
    protected TupleKeyCountTree newChild(@Nonnull byte[] childBytes, @Nonnull Object object) {
        return new TupleKeyCountTree(this, childBytes, object);
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public TupleKeyCountTree getParent() {
        return this.parent;
    }

    @Nonnull
    public Collection<TupleKeyCountTree> getChildren() {
        return this.children.values();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void hideLessThanFraction(double fraction) {
        int threshold = (int)((double)this.count * fraction);
        for (TupleKeyCountTree child : this.children.values()) {
            child.setVisible(child.getCount() >= threshold);
            child.hideLessThanFraction(fraction);
        }
    }

    public void printTree(@Nonnull Printer printer, @Nullable String collapseSeparator) {
        if (this.parent != null) {
            this.printTree(0, 0, printer, collapseSeparator);
        } else {
            for (TupleKeyCountTree child : this.children.values()) {
                child.printTree(0, 0, printer, collapseSeparator);
            }
        }
    }

    protected void printTree(int depth, int nancestors, @Nonnull Printer printer, @Nullable String collapseSeparator) {
        if (this.visible) {
            List<TupleKeyCountTree> path;
            if (collapseSeparator != null) {
                TupleKeyCountTree onlyChild = null;
                for (TupleKeyCountTree child : this.children.values()) {
                    if (!child.visible) continue;
                    if (onlyChild == null) {
                        onlyChild = child;
                        continue;
                    }
                    onlyChild = null;
                    break;
                }
                if (onlyChild != null) {
                    onlyChild.printTree(depth + 1, nancestors + 1, printer, collapseSeparator);
                    return;
                }
            }
            if (nancestors > 0) {
                path = new ArrayList<TupleKeyCountTree>(nancestors + 1);
                TupleKeyCountTree ancestor = this;
                for (int i = 0; i <= nancestors; ++i) {
                    path.add(0, ancestor);
                    ancestor = ancestor.parent;
                }
            } else {
                path = Collections.singletonList(this);
            }
            printer.print(depth - nancestors, path);
            for (TupleKeyCountTree child : this.children.values()) {
                child.printTree(depth + 1, 0, printer, collapseSeparator);
            }
        }
    }

    public String toString() {
        if (this.object == UNPARSEABLE) {
            return ByteArrayUtil.printable(this.bytes);
        }
        if (this.object instanceof byte[]) {
            try {
                Tuple tuple = Tuple.fromBytes((byte[])this.object);
                return tuple.toString();
            }
            catch (Exception ex) {
                return ByteArrayUtil.printable((byte[])this.object);
            }
        }
        return Objects.toString(this.object);
    }

    @FunctionalInterface
    public static interface Printer {
        public void print(int var1, @Nonnull List<TupleKeyCountTree> var2);
    }
}

