/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.clientlog;

import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.system.SystemKeyspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class VersionFromTimestamp {
    @Nonnull
    public static CompletableFuture<Long> lastVersionBefore(@Nonnull ReadTransaction tr, @Nonnull Instant timestamp) {
        return VersionFromTimestamp.versionFromTimestamp(tr, timestamp, true);
    }

    @Nonnull
    public static CompletableFuture<Long> nextVersionAfter(@Nonnull ReadTransaction tr, @Nonnull Instant timestamp) {
        return VersionFromTimestamp.versionFromTimestamp(tr, timestamp, false);
    }

    private static CompletableFuture<Long> versionFromTimestamp(@Nonnull ReadTransaction tr, @Nonnull Instant timestamp, boolean start) {
        KeySelector endKey;
        KeySelector startKey;
        byte[] dateKey = ByteArrayUtil.join(SystemKeyspace.TIMEKEEPER_KEY_PREFIX, Tuple.from(timestamp.getEpochSecond()).pack());
        if (start) {
            startKey = KeySelector.firstGreaterThan(SystemKeyspace.TIMEKEEPER_KEY_PREFIX);
            endKey = KeySelector.firstGreaterThan(dateKey);
        } else {
            startKey = KeySelector.firstGreaterOrEqual(dateKey);
            endKey = KeySelector.firstGreaterOrEqual(ByteArrayUtil.strinc(SystemKeyspace.TIMEKEEPER_KEY_PREFIX));
        }
        Iterator range = tr.getRange(startKey, endKey, 1, start).iterator();
        return range.onHasNext().thenApply(arg_0 -> VersionFromTimestamp.lambda$versionFromTimestamp$0((AsyncIterator)range, start, arg_0));
    }

    private VersionFromTimestamp() {
    }

    private static /* synthetic */ Long lambda$versionFromTimestamp$0(AsyncIterator range, boolean start, Boolean hasNext) {
        if (hasNext.booleanValue()) {
            return Tuple.fromBytes(((KeyValue)range.next()).getValue()).getLong(0);
        }
        if (start) {
            return 0L;
        }
        return Long.MAX_VALUE;
    }
}

