/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncPeekCallbackIterator;
import com.apple.foundationdb.async.AsyncPeekIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.map.BunchedMapException;
import com.apple.foundationdb.map.BunchedMapIterator;
import com.apple.foundationdb.map.BunchedMapMultiIterator;
import com.apple.foundationdb.map.BunchedSerializer;
import com.apple.foundationdb.map.SubspaceSplitter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.util.LogMessageKeys;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class BunchedMap<K, V> {
    private static final int MAX_VALUE_SIZE = 10000;
    private static final byte[] ZERO_ARRAY = new byte[]{0};
    @Nonnull
    private final Comparator<K> keyComparator;
    @Nonnull
    private final BunchedSerializer<K, V> serializer;
    private final int bunchSize;

    public BunchedMap(@Nonnull BunchedSerializer<K, V> serializer, @Nonnull Comparator<K> keyComparator, int bunchSize) {
        this.serializer = serializer;
        this.keyComparator = keyComparator;
        this.bunchSize = bunchSize;
    }

    protected BunchedMap(@Nonnull BunchedMap<K, V> model) {
        this(model.serializer, model.keyComparator, model.bunchSize);
    }

    private static <T> List<T> makeMutable(@Nonnull List<T> list) {
        if (list instanceof ArrayList) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    @Nonnull
    protected CompletableFuture<List<KeyValue>> instrumentRangeRead(@Nonnull CompletableFuture<List<KeyValue>> readFuture) {
        return readFuture;
    }

    protected void instrumentWrite(@Nonnull byte[] key, @Nonnull byte[] value, @Nullable byte[] oldValue) {
    }

    protected void instrumentDelete(@Nonnull byte[] key, @Nullable byte[] oldValue) {
    }

    private CompletableFuture<Optional<KeyValue>> entryForKey(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull K key) {
        byte[] keyBytes = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(key));
        tr.addReadConflictKey(keyBytes);
        return this.instrumentRangeRead(tr.snapshot().getRange(KeySelector.lastLessOrEqual(keyBytes), KeySelector.firstGreaterThan(keyBytes), 0, false, StreamingMode.WANT_ALL).asList()).thenApply(keyValues -> {
            if (keyValues.isEmpty()) {
                return Optional.empty();
            }
            KeyValue kv = (KeyValue)keyValues.get(keyValues.size() - 1);
            if (ByteArrayUtil.compareUnsigned(kv.getKey(), keyBytes) > 0) {
                throw new BunchedMapException("signpost key found for key is greater than original key").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(subspaceKey)}).addLogInfo("key", (Object)ByteArrayUtil2.loggable(keyBytes)).addLogInfo("signpostKey", (Object)ByteArrayUtil2.loggable(kv.getKey()));
            }
            if (ByteArrayUtil.startsWith(kv.getKey(), subspaceKey)) {
                return Optional.of(kv);
            }
            return Optional.empty();
        });
    }

    private void addEntryListReadConflictRange(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull byte[] keyBytes, @Nonnull List<Map.Entry<K, V>> entryList) {
        byte[] end = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(entryList.get(entryList.size() - 1).getKey()), ZERO_ARRAY);
        tr.addReadConflictRange(keyBytes, end);
    }

    private void insertAlone(@Nonnull Transaction tr, @Nonnull byte[] keyBytes, @Nonnull Map.Entry<K, V> entry) {
        tr.addReadConflictKey(keyBytes);
        byte[] valueBytes = this.serializer.serializeEntries(Collections.singletonList(entry));
        tr.set(keyBytes, valueBytes);
        this.instrumentWrite(keyBytes, valueBytes, null);
    }

    private void writeEntryListWithoutChecking(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull byte[] keyBytes, @Nullable KeyValue oldKv, @Nonnull byte[] newKey, @Nonnull List<Map.Entry<K, V>> entryList, @Nonnull byte[] serializedBytes) {
        byte[] oldValue;
        byte[] oldKey;
        this.addEntryListReadConflictRange(tr, subspaceKey, newKey, entryList);
        byte[] byArray = oldKey = oldKv == null ? null : oldKv.getKey();
        if (oldKey != null && !Arrays.equals(oldKey, newKey)) {
            tr.clear(oldKey);
            this.instrumentDelete(oldKey, oldKv.getValue());
            oldValue = null;
        } else {
            oldValue = oldKv == null ? null : oldKv.getValue();
        }
        tr.set(newKey, serializedBytes);
        this.instrumentWrite(newKey, serializedBytes, oldValue);
        if (!Arrays.equals(keyBytes, newKey)) {
            tr.addWriteConflictKey(keyBytes);
        }
    }

    private void writeEntryList(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull byte[] keyBytes, @Nullable KeyValue oldKv, @Nonnull byte[] newKey, @Nonnull List<Map.Entry<K, V>> entryList, @Nullable KeyValue kvAfter, boolean isFirst, boolean isLast) {
        byte[] serializedBytes = this.serializer.serializeEntries(entryList);
        if (serializedBytes.length > 10000) {
            if (isFirst || entryList.size() == 1) {
                this.insertAlone(tr, keyBytes, entryList.get(0));
            } else if (isLast) {
                this.insertAfter(tr, subspaceKey, keyBytes, kvAfter, entryList.get(entryList.size() - 1));
            } else {
                int splitPoint = entryList.size() / 2;
                List<Map.Entry<K, V>> firstEntries = entryList.subList(0, splitPoint);
                byte[] firstSerialized = this.serializer.serializeEntries(firstEntries);
                List<Map.Entry<K, V>> secondEntries = entryList.subList(splitPoint, entryList.size());
                byte[] secondSerialized = this.serializer.serializeEntries(secondEntries);
                this.writeEntryListWithoutChecking(tr, subspaceKey, keyBytes, oldKv, newKey, firstEntries, firstSerialized);
                byte[] secondKey = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(secondEntries.get(0).getKey()));
                this.writeEntryListWithoutChecking(tr, subspaceKey, keyBytes, null, secondKey, secondEntries, secondSerialized);
            }
        } else {
            if (this.serializer.canAppend() && isLast && entryList.size() > 1 && oldKv != null && Arrays.equals(oldKv.getKey(), newKey)) {
                this.addEntryListReadConflictRange(tr, subspaceKey, newKey, entryList);
                byte[] appendBytes = this.serializer.serializeEntry(entryList.get(entryList.size() - 1));
                tr.mutate(MutationType.APPEND_IF_FITS, newKey, appendBytes);
                this.instrumentWrite(newKey, appendBytes, null);
                tr.addWriteConflictKey(keyBytes);
            } else {
                this.writeEntryListWithoutChecking(tr, subspaceKey, keyBytes, oldKv, newKey, entryList, serializedBytes);
            }
            if (isFirst && entryList.size() >= 2) {
                tr.addWriteConflictRange(keyBytes, ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(entryList.get(1).getKey())));
            }
            if (isLast && entryList.size() >= 2) {
                tr.addWriteConflictRange(ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(entryList.get(entryList.size() - 2).getKey())), keyBytes);
            }
        }
    }

    private void insertAfter(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull byte[] keyBytes, @Nullable KeyValue kvAfter, @Nonnull Map.Entry<K, V> entry) {
        if (kvAfter == null) {
            this.insertAlone(tr, keyBytes, entry);
        } else {
            K afterKey = this.serializer.deserializeKey(kvAfter.getKey(), subspaceKey.length);
            List<Map.Entry<K, V>> afterEntryList = this.serializer.deserializeEntries(afterKey, kvAfter.getValue());
            if (afterEntryList.size() >= this.bunchSize) {
                this.insertAlone(tr, keyBytes, entry);
            } else {
                ArrayList<Map.Entry<K, V>> newEntryList = new ArrayList<Map.Entry<K, V>>(afterEntryList.size() + 1);
                newEntryList.add(entry);
                newEntryList.addAll(afterEntryList);
                this.writeEntryList(tr, subspaceKey, keyBytes, kvAfter, keyBytes, newEntryList, null, true, false);
            }
        }
    }

    @Nonnull
    private Optional<V> insertEntry(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull byte[] keyBytes, @Nonnull K key, @Nonnull V value, @Nullable KeyValue kvBefore, @Nullable KeyValue kvAfter, @Nonnull Map.Entry<K, V> entry) {
        int insertIndex;
        if (kvBefore == null) {
            this.insertAfter(tr, subspaceKey, keyBytes, kvAfter, entry);
            return Optional.empty();
        }
        K beforeKey = this.serializer.deserializeKey(kvBefore.getKey(), subspaceKey.length);
        List<Map.Entry<K, V>> beforeEntryList = this.serializer.deserializeEntries(beforeKey, kvBefore.getValue());
        for (insertIndex = 0; insertIndex < beforeEntryList.size() && this.keyComparator.compare(key, beforeEntryList.get(insertIndex).getKey()) > 0; ++insertIndex) {
        }
        if (insertIndex < beforeEntryList.size() && this.keyComparator.compare(key, beforeEntryList.get(insertIndex).getKey()) == 0) {
            Map.Entry<K, V> oldEntry = beforeEntryList.get(insertIndex);
            V oldValue = oldEntry.getValue();
            if (!oldEntry.getValue().equals(value)) {
                beforeEntryList = BunchedMap.makeMutable(beforeEntryList);
                beforeEntryList.set(insertIndex, entry);
                this.writeEntryList(tr, subspaceKey, keyBytes, kvBefore, kvBefore.getKey(), beforeEntryList, kvAfter, false, false);
            } else {
                tr.addReadConflictKey(keyBytes);
            }
            return Optional.of(oldValue);
        }
        if (insertIndex < beforeEntryList.size()) {
            beforeEntryList = BunchedMap.makeMutable(beforeEntryList);
            beforeEntryList.add(insertIndex, entry);
            if (beforeEntryList.size() <= this.bunchSize) {
                this.writeEntryList(tr, subspaceKey, keyBytes, kvBefore, kvBefore.getKey(), beforeEntryList, kvAfter, false, false);
            } else {
                int splitPoint = beforeEntryList.size() / 2;
                this.writeEntryList(tr, subspaceKey, keyBytes, kvBefore, kvBefore.getKey(), beforeEntryList.subList(0, splitPoint), null, false, false);
                List<Map.Entry<K, V>> secondEntries = beforeEntryList.subList(splitPoint, beforeEntryList.size());
                byte[] secondKey = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(secondEntries.get(0).getKey()));
                this.writeEntryList(tr, subspaceKey, keyBytes, null, secondKey, secondEntries, kvAfter, false, false);
            }
            return Optional.empty();
        }
        if (beforeEntryList.size() < this.bunchSize) {
            ArrayList<Map.Entry<K, V>> newEntryList = new ArrayList<Map.Entry<K, V>>(beforeEntryList.size() + 1);
            newEntryList.addAll(beforeEntryList);
            newEntryList.add(entry);
            this.writeEntryList(tr, subspaceKey, keyBytes, kvBefore, kvBefore.getKey(), newEntryList, kvAfter, false, true);
        } else {
            this.insertAfter(tr, subspaceKey, keyBytes, kvAfter, entry);
        }
        return Optional.empty();
    }

    @Nonnull
    public CompletableFuture<Optional<V>> put(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace, @Nonnull K key, @Nonnull V value) {
        return tcx.runAsync(tr -> {
            byte[] subspaceKey = subspace.pack();
            byte[] keyBytes = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(key));
            return this.instrumentRangeRead(tr.snapshot().getRange(KeySelector.lastLessOrEqual(keyBytes), KeySelector.firstGreaterThan(keyBytes).add(1), 0, false, StreamingMode.WANT_ALL).asList()).thenApply(keyValues -> {
                KeyValue kvBefore = null;
                KeyValue kvAfter = null;
                for (KeyValue next : keyValues) {
                    if (!ByteArrayUtil.startsWith(next.getKey(), subspaceKey)) continue;
                    if (ByteArrayUtil.compareUnsigned(keyBytes, next.getKey()) < 0) {
                        kvAfter = next;
                        break;
                    }
                    if (ByteArrayUtil.compareUnsigned(next.getKey(), keyBytes) > 0) continue;
                    kvBefore = next;
                }
                if (!(kvBefore == null || ByteArrayUtil.compareUnsigned(keyBytes, kvBefore.getKey()) >= 0 && ByteArrayUtil.startsWith(kvBefore.getKey(), subspaceKey))) {
                    throw new BunchedMapException("database key before map key compared incorrectly").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(subspaceKey)}).addLogInfo("key", (Object)ByteArrayUtil2.loggable(keyBytes)).addLogInfo("kvBefore", (Object)ByteArrayUtil2.loggable(kvBefore.getKey()));
                }
                if (!(kvAfter == null || ByteArrayUtil.compareUnsigned(keyBytes, kvAfter.getKey()) < 0 && ByteArrayUtil.startsWith(kvAfter.getKey(), subspaceKey))) {
                    throw new BunchedMapException("database key after map key compared incorrectly").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(subspaceKey)}).addLogInfo("key", (Object)ByteArrayUtil2.loggable(keyBytes)).addLogInfo("kvAfter", (Object)ByteArrayUtil2.loggable(kvAfter.getKey()));
                }
                AbstractMap.SimpleImmutableEntry<Object, Object> newEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
                return this.insertEntry((Transaction)tr, subspaceKey, keyBytes, key, value, kvBefore, kvAfter, newEntry);
            });
        });
    }

    @Nonnull
    public CompletableFuture<Boolean> containsKey(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace, @Nonnull K key) {
        byte[] subspaceKey = subspace.getKey();
        return tcx.runAsync(tr -> this.entryForKey((Transaction)tr, subspaceKey, key).thenApply(optionalEntry -> optionalEntry.map(kv -> {
            K mapKey = this.serializer.deserializeKey(kv.getKey(), subspaceKey.length);
            return this.serializer.deserializeKeys(mapKey, kv.getValue()).contains(key);
        }).orElse(false)));
    }

    @Nonnull
    public CompletableFuture<Optional<V>> get(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace, @Nonnull K key) {
        byte[] subspaceKey = subspace.getKey();
        return tcx.runAsync(tr -> this.entryForKey((Transaction)tr, subspaceKey, key).thenApply(optionalEntry -> optionalEntry.flatMap(kv -> {
            K mapKey = this.serializer.deserializeKey(kv.getKey(), subspaceKey.length);
            List<Map.Entry<K, V>> entryList = this.serializer.deserializeEntries(mapKey, kv.getValue());
            return entryList.stream().filter(entry -> entry.getKey().equals(key)).findAny().map(Map.Entry::getValue);
        })));
    }

    @Nonnull
    public CompletableFuture<Optional<V>> remove(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace, @Nonnull K key) {
        byte[] subspaceKey = subspace.getKey();
        return tcx.runAsync(tr -> this.entryForKey((Transaction)tr, subspaceKey, key).thenApply(optionalEntry -> optionalEntry.flatMap(kv -> {
            K mapKey = this.serializer.deserializeKey(kv.getKey(), subspaceKey.length);
            List<Map.Entry<K, V>> entryList = this.serializer.deserializeEntries(mapKey, kv.getValue());
            int foundIndex = -1;
            for (int i = 0; i < entryList.size(); ++i) {
                if (!entryList.get(i).getKey().equals(key)) continue;
                foundIndex = i;
                break;
            }
            if (foundIndex != -1) {
                Map.Entry<K, V> oldEntry = entryList.get(foundIndex);
                this.addEntryListReadConflictRange((Transaction)tr, subspaceKey, kv.getKey(), entryList);
                tr.addWriteConflictKey(ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(key)));
                if (entryList.size() == 1) {
                    tr.clear(kv.getKey());
                    this.instrumentDelete(kv.getKey(), null);
                } else {
                    byte[] oldValue;
                    byte[] newKey;
                    entryList = BunchedMap.makeMutable(entryList);
                    entryList.remove(foundIndex);
                    if (foundIndex == 0) {
                        tr.clear(kv.getKey());
                        this.instrumentDelete(kv.getKey(), kv.getValue());
                        newKey = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(entryList.get(0).getKey()));
                        oldValue = null;
                    } else {
                        newKey = kv.getKey();
                        oldValue = kv.getValue();
                    }
                    byte[] newValue = this.serializer.serializeEntries(entryList);
                    tr.set(newKey, newValue);
                    this.instrumentWrite(newKey, newValue, oldValue);
                }
                return Optional.of(oldEntry.getValue());
            }
            return Optional.empty();
        })));
    }

    @Nonnull
    public CompletableFuture<Void> verifyIntegrity(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace) {
        return tcx.runAsync(tr -> {
            AtomicReference<Object> lastKey = new AtomicReference<Object>(null);
            byte[] subspaceKey = subspace.getKey();
            AsyncIterable<KeyValue> iterable = tr.getRange(subspace.range());
            return AsyncUtil.forEach(iterable, kv -> {
                K boundaryKey = this.serializer.deserializeKey(kv.getKey(), subspaceKey.length);
                if (lastKey.get() != null && this.keyComparator.compare(boundaryKey, lastKey.get()) < 0) {
                    throw new BunchedMapException("boundary key out of order").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(subspaceKey)}).addLogInfo("lastKey", lastKey.get()).addLogInfo("boundaryKey", boundaryKey);
                }
                lastKey.set(boundaryKey);
                List<K> keys = this.serializer.deserializeKeys(boundaryKey, kv.getValue());
                for (K key : keys) {
                    if (this.keyComparator.compare(key, lastKey.get()) < 0) {
                        throw new BunchedMapException("keys within bunch out of order").addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, ByteArrayUtil2.loggable(subspaceKey)}).addLogInfo("lastKey", lastKey.get()).addLogInfo("nextKey", key);
                    }
                    lastKey.set(key);
                }
            }, tr.getExecutor());
        });
    }

    private void flushEntryList(@Nonnull Transaction tr, @Nonnull byte[] subspaceKey, @Nonnull List<Map.Entry<K, V>> currentEntryList, @Nonnull AtomicReference<K> lastKey) {
        byte[] keyBytes = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(currentEntryList.get(0).getKey()));
        this.writeEntryListWithoutChecking(tr, subspaceKey, keyBytes, null, keyBytes, currentEntryList, this.serializer.serializeEntries(currentEntryList));
        lastKey.set(currentEntryList.get(currentEntryList.size() - 1).getKey());
        currentEntryList.clear();
    }

    @Nonnull
    protected CompletableFuture<byte[]> compact(@Nonnull TransactionContext tcx, @Nonnull Subspace subspace, int keyLimit, @Nullable byte[] continuation) {
        return tcx.runAsync(tr -> {
            byte[] subspaceKey = subspace.getKey();
            byte[] begin = continuation == null ? subspaceKey : continuation;
            byte[] end = subspace.range().end;
            AsyncIterable<KeyValue> iterable = tr.snapshot().getRange(begin, end, keyLimit);
            ArrayList currentEntryList = new ArrayList(this.bunchSize);
            AtomicInteger currentEntrySize = new AtomicInteger(0);
            AtomicInteger readKeys = new AtomicInteger(0);
            AtomicReference<Object> lastReadKeyBytes = new AtomicReference<Object>(null);
            AtomicReference<Object> lastKey = new AtomicReference<Object>(null);
            return AsyncUtil.forEach(iterable, kv -> {
                K boundaryKey = this.serializer.deserializeKey(kv.getKey(), subspaceKey.length);
                List<Map.Entry<K, V>> entriesFromKey = this.serializer.deserializeEntries(boundaryKey, kv.getValue());
                readKeys.incrementAndGet();
                if (entriesFromKey.size() >= this.bunchSize && currentEntryList.isEmpty()) {
                    lastReadKeyBytes.set(null);
                    return;
                }
                if (lastReadKeyBytes.get() == null) {
                    lastReadKeyBytes.set(kv.getKey());
                }
                byte[] endKeyBytes = ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(entriesFromKey.get(entriesFromKey.size() - 1).getKey()), ZERO_ARRAY);
                tr.addReadConflictRange((byte[])lastReadKeyBytes.get(), endKeyBytes);
                tr.addWriteConflictRange((byte[])lastReadKeyBytes.get(), kv.getKey());
                lastReadKeyBytes.set(endKeyBytes);
                tr.clear(kv.getKey());
                this.instrumentDelete(kv.getKey(), kv.getValue());
                for (Map.Entry<K, V> entry : entriesFromKey) {
                    byte[] serializedEntry = this.serializer.serializeEntry(entry);
                    if (currentEntrySize.get() + serializedEntry.length > 10000 && !currentEntryList.isEmpty()) {
                        this.flushEntryList((Transaction)tr, subspaceKey, currentEntryList, (AtomicReference<K>)lastKey);
                        currentEntrySize.set(0);
                    }
                    currentEntryList.add(entry);
                    currentEntrySize.addAndGet(serializedEntry.length);
                    if (currentEntryList.size() != this.bunchSize) continue;
                    this.flushEntryList((Transaction)tr, subspaceKey, currentEntryList, (AtomicReference<K>)lastKey);
                    currentEntrySize.set(0);
                }
            }, tr.getExecutor()).thenApply(vignore -> {
                if (!currentEntryList.isEmpty()) {
                    this.flushEntryList((Transaction)tr, subspaceKey, currentEntryList, (AtomicReference<K>)lastKey);
                }
                if (lastKey.get() != null && keyLimit != 0 && readKeys.get() == keyLimit) {
                    return ByteArrayUtil.join(subspaceKey, this.serializer.serializeKey(lastKey.get()), ZERO_ARRAY);
                }
                return null;
            });
        });
    }

    @Nonnull
    public BunchedSerializer<K, V> getSerializer() {
        return this.serializer;
    }

    @Nonnull
    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public int getBunchSize() {
        return this.bunchSize;
    }

    @Nonnull
    public BunchedMapIterator<K, V> scan(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace) {
        return this.scan(tr, subspace, null, 0, false);
    }

    @Nonnull
    public BunchedMapIterator<K, V> scan(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nullable byte[] continuation) {
        return this.scan(tr, subspace, continuation, 0, false);
    }

    @Nonnull
    public BunchedMapIterator<K, V> scan(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nullable byte[] continuation, int limit, boolean reverse) {
        AsyncIterable<KeyValue> rangeReadIterable;
        Object continuationKey;
        byte[] subspaceKey = subspace.getKey();
        if (continuation == null) {
            continuationKey = null;
            rangeReadIterable = tr.getRange(subspace.range(), 0, reverse);
        } else {
            continuationKey = this.serializer.deserializeKey(continuation);
            byte[] continuationKeyBytes = ByteArrayUtil.join(subspaceKey, continuation);
            rangeReadIterable = reverse ? tr.getRange(subspaceKey, continuationKeyBytes, 0, true) : tr.getRange(KeySelector.lastLessOrEqual(continuationKeyBytes), KeySelector.firstGreaterOrEqual(subspace.range().end), 0, false);
        }
        return new BunchedMapIterator(AsyncPeekIterator.wrap(rangeReadIterable.iterator()), tr, subspace, subspace.getKey(), this, continuationKey, limit, reverse);
    }

    @Nonnull
    public <T> BunchedMapMultiIterator<K, V, T> scanMulti(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull SubspaceSplitter<T> splitter) {
        return this.scanMulti(tr, subspace, splitter, null, 0, false);
    }

    @Nonnull
    public <T> BunchedMapMultiIterator<K, V, T> scanMulti(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull SubspaceSplitter<T> splitter, @Nullable byte[] continuation, int limit, boolean reverse) {
        return this.scanMulti(tr, subspace, splitter, null, null, continuation, limit, reverse);
    }

    @Nonnull
    public <T> BunchedMapMultiIterator<K, V, T> scanMulti(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull SubspaceSplitter<T> splitter, @Nullable byte[] subspaceStart, @Nullable byte[] subspaceEnd, @Nullable byte[] continuation, int limit, boolean reverse) {
        return this.scanMulti(tr, subspace, splitter, subspaceStart, subspaceEnd, continuation, limit, null, reverse);
    }

    @Nonnull
    public <T> BunchedMapMultiIterator<K, V, T> scanMulti(@Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull SubspaceSplitter<T> splitter, @Nullable byte[] subspaceStart, @Nullable byte[] subspaceEnd, @Nullable byte[] continuation, int limit, @Nullable Consumer<KeyValue> postReadCallback, boolean reverse) {
        AsyncIterable<KeyValue> rangeReadIterable;
        byte[] endBytes;
        byte[] subspaceKey = subspace.getKey();
        byte[] startBytes = subspaceStart == null ? subspaceKey : ByteArrayUtil.join(subspaceKey, subspaceStart);
        byte[] byArray = endBytes = subspaceEnd == null ? ByteArrayUtil.strinc(subspaceKey) : ByteArrayUtil.join(subspaceKey, subspaceEnd);
        if (continuation == null) {
            rangeReadIterable = tr.getRange(startBytes, endBytes, 0, reverse);
        } else {
            byte[] continuationEndpoint = ByteArrayUtil.join(subspaceKey, continuation);
            rangeReadIterable = reverse ? (ByteArrayUtil.compareUnsigned(continuationEndpoint, endBytes) < 0 ? tr.getRange(startBytes, continuationEndpoint, 0, true) : tr.getRange(startBytes, endBytes, 0, true)) : (ByteArrayUtil.compareUnsigned(continuationEndpoint, startBytes) < 0 ? tr.getRange(startBytes, endBytes, 0, false) : tr.getRange(KeySelector.lastLessThan(continuationEndpoint), KeySelector.firstGreaterOrEqual(endBytes), 0, false));
        }
        AsyncPeekIterator<KeyValue> wrappedIterator = postReadCallback == null ? AsyncPeekIterator.wrap(rangeReadIterable.iterator()) : AsyncPeekCallbackIterator.wrap(rangeReadIterable.iterator(), postReadCallback);
        return new BunchedMapMultiIterator(wrappedIterator, tr, subspace, subspaceKey, splitter, this, continuation, limit, reverse);
    }
}

