/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncPeekIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.map.BunchedMap;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class BunchedMapIterator<K, V>
implements AsyncPeekIterator<Map.Entry<K, V>> {
    @Nonnull
    private final AsyncPeekIterator<KeyValue> underlying;
    @Nonnull
    private final Subspace subspace;
    @Nonnull
    private final ReadTransaction tr;
    @Nonnull
    private final byte[] subspaceKey;
    @Nonnull
    private final BunchedMap<K, V> bunchedMap;
    @Nullable
    private final K continuationKey;
    private final boolean reverse;
    private final int limit;
    @Nullable
    private CompletableFuture<Boolean> hasNextFuture;
    private boolean continuationSatisfied;
    @Nullable
    private List<Map.Entry<K, V>> currEntryList;
    private int currEntryIndex;
    @Nullable
    private K lastKey;
    private int returned;
    private boolean done;

    BunchedMapIterator(@Nonnull AsyncPeekIterator<KeyValue> underlying, @Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull byte[] subspaceKey, @Nonnull BunchedMap<K, V> bunchedMap, @Nullable K continuationKey, int limit, boolean reverse) {
        this.underlying = underlying;
        this.tr = tr;
        this.subspace = subspace;
        this.subspaceKey = subspaceKey;
        this.bunchedMap = bunchedMap;
        this.continuationKey = continuationKey;
        this.continuationSatisfied = continuationKey == null;
        this.limit = limit;
        this.reverse = reverse;
        this.currEntryList = null;
        this.currEntryIndex = -1;
        this.lastKey = null;
        this.returned = 0;
        this.done = false;
    }

    @Override
    public CompletableFuture<Boolean> onHasNext() {
        if (this.done) {
            return AsyncUtil.READY_FALSE;
        }
        if (this.currEntryList != null && this.currEntryIndex >= 0 && this.currEntryIndex < this.currEntryList.size()) {
            return AsyncUtil.READY_TRUE;
        }
        if (this.hasNextFuture == null) {
            this.hasNextFuture = this.underlying.onHasNext().thenCompose(doesHaveNext -> {
                if (doesHaveNext.booleanValue()) {
                    return AsyncUtil.whileTrue(() -> {
                        int nextItemIndex;
                        KeyValue underlyingNext = this.underlying.peek();
                        if (!this.subspace.contains(underlyingNext.getKey())) {
                            if (ByteArrayUtil.compareUnsigned(underlyingNext.getKey(), this.subspaceKey) * (this.reverse ? -1 : 1) < 0) {
                                this.underlying.next();
                                return this.underlying.onHasNext();
                            }
                            this.done = true;
                            return AsyncUtil.READY_FALSE;
                        }
                        this.underlying.next();
                        K boundaryKey = this.bunchedMap.getSerializer().deserializeKey(underlyingNext.getKey(), this.subspaceKey.length);
                        List<Map.Entry<K, V>> nextEntryList = this.bunchedMap.getSerializer().deserializeEntries(boundaryKey, underlyingNext.getValue());
                        if (nextEntryList.isEmpty()) {
                            return this.underlying.onHasNext();
                        }
                        int n = nextItemIndex = this.reverse ? nextEntryList.size() - 1 : 0;
                        if (!this.continuationSatisfied) {
                            while (nextItemIndex >= 0 && nextItemIndex < nextEntryList.size() && this.bunchedMap.getKeyComparator().compare(this.continuationKey, nextEntryList.get(nextItemIndex).getKey()) * (this.reverse ? -1 : 1) >= 0) {
                                nextItemIndex += this.reverse ? -1 : 1;
                            }
                            if (nextItemIndex < 0 || nextItemIndex >= nextEntryList.size()) {
                                return this.underlying.onHasNext();
                            }
                            this.continuationSatisfied = true;
                        }
                        this.currEntryIndex = nextItemIndex;
                        this.currEntryList = nextEntryList;
                        return AsyncUtil.READY_FALSE;
                    }, this.tr.getExecutor()).thenApply(vignore -> {
                        if (this.currEntryList == null || this.currEntryIndex < 0 || this.currEntryIndex >= this.currEntryList.size()) {
                            this.done = true;
                        }
                        return !this.done;
                    });
                }
                this.done = true;
                return AsyncUtil.READY_FALSE;
            });
        }
        return this.hasNextFuture;
    }

    @Override
    public boolean hasNext() {
        return this.onHasNext().join();
    }

    @Override
    @Nonnull
    public Map.Entry<K, V> peek() {
        if (this.hasNext()) {
            if (this.currEntryList == null || this.currEntryIndex >= this.currEntryList.size() || this.currEntryIndex < 0) {
                throw new IllegalStateException();
            }
            return this.currEntryList.get(this.currEntryIndex);
        }
        throw new NoSuchElementException();
    }

    @Override
    @Nonnull
    public Map.Entry<K, V> next() {
        Object nextEntry = this.peek();
        this.lastKey = nextEntry.getKey();
        this.hasNextFuture = null;
        this.currEntryIndex += this.reverse ? -1 : 1;
        ++this.returned;
        if (this.limit != 0 && this.returned >= this.limit) {
            this.done = true;
        }
        return nextEntry;
    }

    @Nullable
    public byte[] getContinuation() {
        if (this.lastKey == null || this.done && (this.limit == 0 || this.returned < this.limit)) {
            return null;
        }
        return this.bunchedMap.getSerializer().serializeKey(this.lastKey);
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public void cancel() {
        this.underlying.cancel();
    }
}

