/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.map;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncPeekIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.map.BunchedMap;
import com.apple.foundationdb.map.BunchedMapIterator;
import com.apple.foundationdb.map.BunchedMapScanEntry;
import com.apple.foundationdb.map.SubspaceSplitter;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class BunchedMapMultiIterator<K, V, T>
implements AsyncPeekIterator<BunchedMapScanEntry<K, V, T>> {
    @Nonnull
    private final AsyncPeekIterator<KeyValue> underlying;
    @Nonnull
    private final ReadTransaction tr;
    @Nonnull
    private final Subspace subspace;
    @Nonnull
    private final byte[] subspaceKey;
    @Nonnull
    private final SubspaceSplitter<T> splitter;
    @Nonnull
    private final BunchedMap<K, V> bunchedMap;
    @Nullable
    private final byte[] continuation;
    private final boolean reverse;
    private final int limit;
    @Nullable
    private CompletableFuture<Boolean> hasNextFuture;
    private boolean continuationSatisfied;
    @Nullable
    private BunchedMapIterator<K, V> mapIterator;
    @Nullable
    private Subspace currentSubspace;
    @Nullable
    private byte[] currentSubspaceSuffix;
    @Nullable
    private byte[] currentSubspaceKey;
    @Nullable
    private T currentSubspaceTag;
    @Nullable
    private BunchedMapScanEntry<K, V, T> nextEntry;
    @Nullable
    private K lastKey;
    private boolean hasCurrent;
    private int returned;
    private boolean done;

    BunchedMapMultiIterator(@Nonnull AsyncPeekIterator<KeyValue> underlying, @Nonnull ReadTransaction tr, @Nonnull Subspace subspace, @Nonnull byte[] subspaceKey, @Nonnull SubspaceSplitter<T> splitter, @Nonnull BunchedMap<K, V> bunchedMap, @Nullable byte[] continuation, int limit, boolean reverse) {
        this.underlying = underlying;
        this.tr = tr;
        this.subspace = subspace;
        this.subspaceKey = subspaceKey;
        this.splitter = splitter;
        this.bunchedMap = bunchedMap;
        this.continuation = continuation;
        this.continuationSatisfied = continuation == null;
        this.limit = limit;
        this.reverse = reverse;
        this.mapIterator = null;
        this.currentSubspace = null;
        this.currentSubspaceKey = null;
        this.currentSubspaceTag = null;
        this.nextEntry = null;
        this.returned = 0;
        this.done = false;
    }

    private CompletableFuture<Boolean> getNextMapIterator() {
        return this.underlying.onHasNext().thenCompose(doesHaveNext -> {
            if (doesHaveNext.booleanValue()) {
                KeyValue nextKv = this.underlying.peek();
                if (!this.subspace.contains(nextKv.getKey())) {
                    if (ByteArrayUtil.compareUnsigned(nextKv.getKey(), this.subspaceKey) * (this.reverse ? -1 : 1) > 0) {
                        this.underlying.cancel();
                        return AsyncUtil.READY_FALSE;
                    }
                    return AsyncUtil.whileTrue(() -> {
                        KeyValue kv = this.underlying.peek();
                        if (ByteArrayUtil.compareUnsigned(kv.getKey(), this.subspaceKey) * (this.reverse ? -1 : 1) >= 0) {
                            return AsyncUtil.READY_FALSE;
                        }
                        this.underlying.next();
                        return this.underlying.onHasNext();
                    }, this.tr.getExecutor()).thenCompose(vignore -> this.getNextMapIterator());
                }
                Subspace nextSubspace = this.splitter.subspaceOf(nextKv.getKey());
                byte[] nextSubspaceKey = nextSubspace.getKey();
                byte[] nextSubspaceSuffix = Arrays.copyOfRange(nextSubspaceKey, this.subspaceKey.length, nextSubspaceKey.length);
                Object continuationKey = null;
                if (!this.continuationSatisfied) {
                    if (ByteArrayUtil.startsWith(this.continuation, nextSubspaceSuffix)) {
                        continuationKey = this.bunchedMap.getSerializer().deserializeKey(this.continuation, nextSubspaceSuffix.length);
                        this.continuationSatisfied = true;
                    } else if (ByteArrayUtil.compareUnsigned(nextSubspaceSuffix, this.continuation) * (this.reverse ? -1 : 1) > 0) {
                        this.continuationSatisfied = true;
                        continuationKey = null;
                    } else {
                        return AsyncUtil.whileTrue(() -> {
                            KeyValue kv = this.underlying.peek();
                            if (nextSubspace.contains(kv.getKey())) {
                                this.underlying.next();
                                return this.underlying.onHasNext();
                            }
                            return AsyncUtil.READY_FALSE;
                        }, this.tr.getExecutor()).thenCompose(vignore -> this.getNextMapIterator());
                    }
                }
                BunchedMapIterator<Object, V> nextMapIterator = new BunchedMapIterator<Object, V>(this.underlying, this.tr, nextSubspace, nextSubspaceKey, this.bunchedMap, continuationKey, this.limit == 0 ? 0 : this.limit - this.returned, this.reverse);
                T nextSubspaceTag = this.splitter.subspaceTag(nextSubspace);
                return nextMapIterator.onHasNext().thenCompose(mapHasNext -> {
                    if (mapHasNext.booleanValue()) {
                        this.currentSubspace = nextSubspace;
                        this.currentSubspaceKey = nextSubspaceKey;
                        this.currentSubspaceSuffix = nextSubspaceSuffix;
                        this.currentSubspaceTag = nextSubspaceTag;
                        this.mapIterator = nextMapIterator;
                        Object mapEntry = this.mapIterator.next();
                        this.nextEntry = new BunchedMapScanEntry(this.currentSubspace, this.currentSubspaceTag, mapEntry.getKey(), mapEntry.getValue());
                        return AsyncUtil.READY_TRUE;
                    }
                    return this.getNextMapIterator();
                });
            }
            this.done = true;
            return AsyncUtil.READY_FALSE;
        });
    }

    @Override
    public CompletableFuture<Boolean> onHasNext() {
        if (this.done) {
            return AsyncUtil.READY_FALSE;
        }
        if (this.hasCurrent) {
            return AsyncUtil.READY_TRUE;
        }
        if (this.hasNextFuture == null) {
            this.hasNextFuture = this.mapIterator != null ? this.mapIterator.onHasNext().thenCompose(mapHasNext -> {
                if (mapHasNext.booleanValue()) {
                    Object entry = this.mapIterator.next();
                    assert (this.currentSubspace != null);
                    assert (this.currentSubspaceKey != null);
                    this.nextEntry = new BunchedMapScanEntry(this.currentSubspace, this.currentSubspaceTag, entry.getKey(), entry.getValue());
                    return AsyncUtil.READY_TRUE;
                }
                if (this.limit != 0 && this.returned == this.limit) {
                    this.done = true;
                    return AsyncUtil.READY_FALSE;
                }
                return this.getNextMapIterator();
            }) : this.getNextMapIterator();
        }
        return this.hasNextFuture;
    }

    @Override
    public boolean hasNext() {
        return this.onHasNext().join();
    }

    @Override
    @Nonnull
    public BunchedMapScanEntry<K, V, T> peek() {
        if (this.hasNext() && this.nextEntry != null) {
            return this.nextEntry;
        }
        throw new NoSuchElementException();
    }

    @Override
    @Nonnull
    public BunchedMapScanEntry<K, V, T> next() {
        Object nextEntry = this.peek();
        this.lastKey = ((BunchedMapScanEntry)nextEntry).getKey();
        this.hasCurrent = false;
        this.hasNextFuture = null;
        ++this.returned;
        return nextEntry;
    }

    @Nullable
    public byte[] getContinuation() {
        if (this.lastKey == null || this.currentSubspaceKey == null || this.done && (this.limit == 0 || this.returned < this.limit)) {
            return null;
        }
        return ByteArrayUtil.join(this.currentSubspaceSuffix, this.bunchedMap.getSerializer().serializeKey(this.lastKey));
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public void cancel() {
        if (this.mapIterator != null) {
            this.mapIterator.cancel();
        }
        this.underlying.cancel();
    }
}

