/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.MoreAsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class AsyncLoadingCache<K, V> {
    public static final long DEFAULT_DEADLINE_TIME_MILLIS = 5000L;
    public static final long UNLIMITED = Long.MAX_VALUE;
    @Nonnull
    private final Cache<K, Optional<V>> cache;
    private final long refreshTimeMillis;
    private final long deadlineTimeMillis;
    private final long maxSize;
    @Nonnull
    private final ScheduledExecutorService scheduledExecutor;

    public AsyncLoadingCache(long refreshTimeMillis, long deadlineTimeMillis, long maxSize, @Nonnull ScheduledExecutorService scheduledExecutor) {
        this.refreshTimeMillis = refreshTimeMillis;
        this.deadlineTimeMillis = deadlineTimeMillis;
        this.maxSize = maxSize;
        this.scheduledExecutor = scheduledExecutor;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(this.refreshTimeMillis, TimeUnit.MILLISECONDS);
        if (maxSize != Long.MAX_VALUE) {
            cacheBuilder.maximumSize(maxSize);
        }
        this.cache = cacheBuilder.build();
    }

    @Nonnull
    public CompletableFuture<V> orElseGet(@Nonnull K key, @Nonnull Supplier<CompletableFuture<V>> supplier) {
        try {
            Optional<V> cachedValue = this.cache.getIfPresent(key);
            if (cachedValue == null) {
                return MoreAsyncUtil.getWithDeadline(this.deadlineTimeMillis, supplier, this.scheduledExecutor).thenApply(value -> {
                    Optional<Object> existingValue = this.cache.asMap().putIfAbsent(key, Optional.ofNullable(value));
                    return existingValue == null ? value : existingValue.orElse(null);
                });
            }
            return CompletableFuture.completedFuture(cachedValue.orElse(null));
        }
        catch (Exception e) {
            throw new RecordCoreException("failed getting value", e).addLogInfo("cacheKey", key);
        }
    }

    public long getRefreshTimeSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.refreshTimeMillis);
    }

    public long getRefreshTimeMillis() {
        return this.refreshTimeMillis;
    }

    public long getDeadlineTimeMillis() {
        return this.deadlineTimeMillis;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public String toString() {
        return "CachedResult:" + this.cache.asMap().toString();
    }
}

