/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PParameterComparison;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Bindings {
    @Nonnull
    private final Map<String, Object> values = new HashMap<String, Object>();
    @Nullable
    private final Bindings parent;
    public static final Bindings EMPTY_BINDINGS = new Bindings();

    private Bindings(@Nullable Bindings parent) {
        this.parent = parent;
    }

    public Bindings() {
        this(null);
    }

    @Nullable
    public Object get(@Nonnull String name) {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        throw new RecordCoreException("Missing binding for " + name, new Object[0]);
    }

    public boolean containsBinding(@Nonnull String name) {
        if (this.values.containsKey(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsBinding(name);
        }
        return false;
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public Builder childBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public List<Map.Entry<String, Object>> asMappingList() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        this.values.forEach((key, value) -> resultBuilder.add(Pair.of(key, value)));
        if (this.parent != null) {
            resultBuilder.addAll(this.parent.asMappingList());
        }
        return resultBuilder.build();
    }

    public String toString() {
        return "Bindings(" + String.valueOf(this.asMappingList()) + ")";
    }

    public static class Builder {
        @Nonnull
        private final Bindings bindings;
        private boolean built;

        private Builder(@Nullable Bindings parent) {
            this.bindings = new Bindings(parent);
        }

        @Nullable
        public Object get(@Nonnull String name) {
            return this.bindings.get(name);
        }

        public Builder set(@Nonnull String name, @Nullable Object value) {
            if (this.built) {
                throw new RecordCoreException("Cannot change bindings after building", new Object[0]);
            }
            if (this.bindings.values.containsKey(name)) {
                throw new RecordCoreException("Duplicate binding for " + name, new Object[0]);
            }
            this.bindings.values.put(name, value);
            return this;
        }

        @Nonnull
        public Bindings build() {
            this.built = true;
            return this.bindings;
        }
    }

    public static enum Internal {
        IN("__in_"),
        RANK("__rank_"),
        CORRELATION("__corr_"),
        CONSTANT("__const_");

        public static final String PREFIX = "__";
        private final String value;

        private Internal(String value) {
            this.value = value;
        }

        public static boolean isInternal(@Nonnull String name) {
            return name.startsWith(PREFIX);
        }

        public boolean isOfType(@Nonnull String name) {
            return name.startsWith(this.value);
        }

        public String bindingName(@Nonnull String suffix) {
            return this.value + suffix;
        }

        public String identifier(@Nonnull String bindingName) {
            Verify.verify(bindingName.startsWith(this.value));
            return bindingName.substring(this.value.length());
        }

        @Nonnull
        public PParameterComparison.PBindingKind toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case IN: {
                    return PParameterComparison.PBindingKind.IN;
                }
                case RANK: {
                    return PParameterComparison.PBindingKind.RANK;
                }
                case CONSTANT: {
                    return PParameterComparison.PBindingKind.CONSTANT;
                }
                case CORRELATION: {
                    return PParameterComparison.PBindingKind.CORRELATION;
                }
            }
            throw new RecordCoreException("unknown binding mapping. did you forget to map it?", new Object[0]);
        }

        @Nonnull
        public static Internal fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PParameterComparison.PBindingKind bindingKindProto) {
            switch (bindingKindProto) {
                case IN: {
                    return IN;
                }
                case RANK: {
                    return RANK;
                }
                case CONSTANT: {
                    return CONSTANT;
                }
                case CORRELATION: {
                    return CORRELATION;
                }
            }
            throw new RecordCoreException("unknown binding mapping. did you forget to map it?", new Object[0]);
        }
    }
}

