/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ByteArrayContinuation
implements RecordCursorContinuation {
    @Nonnull
    private final byte[] bytes;
    @Nullable
    private ByteString byteString;

    @SpotBugsSuppressWarnings(value={"EI2"})
    private ByteArrayContinuation(@Nonnull byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI"})
    public byte[] toBytes() {
        return this.bytes;
    }

    @Override
    @Nonnull
    public ByteString toByteString() {
        if (this.byteString == null) {
            this.byteString = ZeroCopyByteString.wrap(this.bytes);
        }
        return this.byteString;
    }

    @Override
    public boolean isEnd() {
        return false;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI2"})
    public static RecordCursorContinuation fromNullable(@Nullable byte[] bytes) {
        if (bytes == null) {
            return RecordCursorEndContinuation.END;
        }
        return new ByteArrayContinuation(bytes);
    }

    @Nonnull
    public static RecordCursorContinuation fromInt(int a) {
        return new ByteArrayContinuation(ByteBuffer.allocate(4).putInt(a).array());
    }
}

