/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteScanLimiter;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class ByteScanLimiterFactory {
    private static final Untracked UNTRACKED = new Untracked();

    private ByteScanLimiterFactory() {
    }

    public static ByteScanLimiter enforce(long limit) {
        return new Enforcing(limit);
    }

    public static ByteScanLimiter tracking() {
        return new Tracking();
    }

    public static ByteScanLimiter untracked() {
        return UNTRACKED;
    }

    private static class Enforcing
    implements ByteScanLimiter {
        private final long originalLimit;
        private final AtomicLong bytesRemaining;

        private Enforcing(long limit) {
            this.originalLimit = limit;
            this.bytesRemaining = new AtomicLong(limit);
        }

        @Override
        @Nonnull
        public ByteScanLimiter reset() {
            return new Enforcing(this.originalLimit);
        }

        @Override
        public boolean isEnforcing() {
            return true;
        }

        @Override
        public boolean hasBytesRemaining() {
            return this.bytesRemaining.get() > 0L;
        }

        @Override
        public void registerScannedBytes(long bytes) {
            this.bytesRemaining.addAndGet(-bytes);
        }

        @Override
        public long getLimit() {
            return this.originalLimit;
        }

        @Override
        public long getBytesScanned() {
            return this.originalLimit - this.bytesRemaining.get();
        }

        public String toString() {
            return "ByteScanLimiter(" + this.originalLimit + " limit, " + this.bytesRemaining.get() + " left)";
        }
    }

    private static class Tracking
    implements ByteScanLimiter {
        private final AtomicLong bytesScanned = new AtomicLong();

        private Tracking() {
        }

        @Override
        @Nonnull
        public ByteScanLimiter reset() {
            return new Tracking();
        }

        @Override
        public boolean isEnforcing() {
            return false;
        }

        @Override
        public boolean hasBytesRemaining() {
            return true;
        }

        @Override
        public void registerScannedBytes(long bytes) {
            this.bytesScanned.addAndGet(bytes);
        }

        @Override
        public long getLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getBytesScanned() {
            return this.bytesScanned.get();
        }

        public String toString() {
            return "ByteScanLimiter(UNLIMITED, " + this.bytesScanned.get() + " scanned)";
        }
    }

    private static class Untracked
    implements ByteScanLimiter {
        private Untracked() {
        }

        @Override
        @Nonnull
        public ByteScanLimiter reset() {
            return this;
        }

        @Override
        public boolean isEnforcing() {
            return false;
        }

        @Override
        public boolean hasBytesRemaining() {
            return true;
        }

        @Override
        public void registerScannedBytes(long bytes) {
        }

        @Override
        public long getLimit() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getBytesScanned() {
            return 0L;
        }

        public String toString() {
            return "ByteScanLimiter(NO_LIMIT)";
        }
    }
}

