/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContextBuilder;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class EvaluationContext {
    @Nonnull
    private final Bindings bindings;
    @Nonnull
    private final TypeRepository typeRepository;
    public static final EvaluationContext EMPTY = new EvaluationContext(Bindings.EMPTY_BINDINGS, TypeRepository.EMPTY_SCHEMA);

    public static EvaluationContext empty() {
        return EMPTY;
    }

    private EvaluationContext(@Nonnull Bindings bindings, @Nonnull TypeRepository typeRepository) {
        this.bindings = bindings;
        this.typeRepository = typeRepository;
    }

    @Nonnull
    public static EvaluationContext forBindings(@Nonnull Bindings bindings) {
        return new EvaluationContext(bindings, TypeRepository.EMPTY_SCHEMA);
    }

    @Nonnull
    public static EvaluationContext forBindingsAndTypeRepository(@Nonnull Bindings bindings, @Nonnull TypeRepository typeRepository) {
        return new EvaluationContext(bindings, typeRepository);
    }

    @Nonnull
    public static EvaluationContext forTypeRepository(@Nonnull TypeRepository typeRepository) {
        return new EvaluationContext(Bindings.EMPTY_BINDINGS, typeRepository);
    }

    @Nonnull
    public static EvaluationContext forBinding(@Nonnull String bindingName, @Nullable Object value) {
        return new EvaluationContext(Bindings.newBuilder().set(bindingName, value).build(), TypeRepository.EMPTY_SCHEMA);
    }

    @Nonnull
    public Bindings getBindings() {
        return this.bindings;
    }

    @Nullable
    public Object getBinding(@Nonnull String name) {
        return this.bindings.get(name);
    }

    public Object getBinding(@Nonnull Bindings.Internal type, @Nonnull CorrelationIdentifier alias) {
        return this.bindings.get(type.bindingName(alias.getId()));
    }

    public boolean containsBinding(@Nonnull String name) {
        return this.bindings.containsBinding(name);
    }

    public boolean containsBinding(@Nonnull Bindings.Internal type, @Nonnull CorrelationIdentifier alias) {
        return this.containsBinding(type.bindingName(alias.getId()));
    }

    public boolean containsConstantBinding(@Nonnull CorrelationIdentifier alias, @Nonnull String constantId) {
        if (!this.containsBinding(Bindings.Internal.CONSTANT, alias)) {
            return false;
        }
        Map<String, ?> constantsMap = this.getConstantsMap(alias);
        return constantsMap.containsKey(constantId);
    }

    @Nullable
    public Object dereferenceConstant(@Nonnull CorrelationIdentifier alias, @Nonnull String constantId) {
        Map<String, ?> constantsMap = this.getConstantsMap(alias);
        return constantsMap.get(constantId);
    }

    @Nonnull
    private Map<String, ?> getConstantsMap(@Nonnull CorrelationIdentifier alias) {
        return (Map)this.getBinding(Bindings.Internal.CONSTANT, alias);
    }

    @Nonnull
    public TypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    @Nonnull
    public EvaluationContextBuilder childBuilder() {
        return new EvaluationContextBuilder(this);
    }

    @Nonnull
    public static EvaluationContextBuilder newBuilder() {
        return new EvaluationContextBuilder();
    }

    @Nonnull
    public EvaluationContext withBinding(@Nonnull String bindingName, @Nullable Object value) {
        return this.childBuilder().setBinding(bindingName, value).build(this.typeRepository);
    }

    public EvaluationContext withBinding(Bindings.Internal type, @Nonnull CorrelationIdentifier alias, @Nullable Object value) {
        return this.childBuilder().setBinding(type.bindingName(alias.getId()), value).build(this.typeRepository);
    }
}

