/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class EvaluationContextBuilder {
    @Nonnull
    protected final Bindings.Builder bindings;

    protected EvaluationContextBuilder() {
        this.bindings = Bindings.newBuilder();
    }

    protected EvaluationContextBuilder(@Nonnull EvaluationContext original) {
        this.bindings = original.getBindings().childBuilder();
    }

    @Nullable
    public Object getBinding(@Nonnull String name) {
        return this.bindings.get(name);
    }

    @Nonnull
    public EvaluationContextBuilder setBinding(@Nonnull String name, @Nullable Object value) {
        this.bindings.set(name, value);
        return this;
    }

    public EvaluationContextBuilder setBinding(@Nonnull CorrelationIdentifier alias, @Nullable Object value) {
        return this.setBinding(Bindings.Internal.CORRELATION.bindingName(alias.getId()), value);
    }

    public EvaluationContextBuilder setConstant(@Nonnull CorrelationIdentifier alias, @Nullable Object value) {
        return this.setBinding(Bindings.Internal.CONSTANT.bindingName(alias.getId()), value);
    }

    @Nonnull
    public EvaluationContext build(@Nonnull TypeRepository typeRepository) {
        return EvaluationContext.forBindingsAndTypeRepository(this.bindings.build(), typeRepository);
    }
}

