/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteScanLimiter;
import com.apple.foundationdb.record.ByteScanLimiterFactory;
import com.apple.foundationdb.record.CursorStreamingMode;
import com.apple.foundationdb.record.ExecuteState;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordScanLimiter;
import com.apple.foundationdb.record.RecordScanLimiterFactory;
import com.apple.foundationdb.record.ScanProperties;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ExecuteProperties {
    public static final long UNLIMITED_TIME = 0L;
    public static final ExecuteProperties SERIAL_EXECUTE = ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setState(ExecuteState.NO_LIMITS).build();
    @Nonnull
    protected final IsolationLevel isolationLevel;
    protected final int skip;
    protected final int rowLimit;
    private final long timeLimit;
    @Nonnull
    private final ExecuteState state;
    private final boolean failOnScanLimitReached;
    private final boolean isDryRun;
    private final CursorStreamingMode defaultCursorStreamingMode;

    private ExecuteProperties(int skip, int rowLimit, @Nonnull IsolationLevel isolationLevel, long timeLimit, @Nonnull ExecuteState state, boolean failOnScanLimitReached, @Nonnull CursorStreamingMode defaultCursorStreamingMode, boolean isDryRun) {
        this.skip = skip;
        this.rowLimit = rowLimit;
        this.isolationLevel = isolationLevel;
        this.timeLimit = timeLimit;
        this.state = state;
        this.failOnScanLimitReached = failOnScanLimitReached;
        this.defaultCursorStreamingMode = defaultCursorStreamingMode;
        this.isDryRun = isDryRun;
    }

    @Nonnull
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public int getSkip() {
        return this.skip;
    }

    @Nonnull
    public ExecuteProperties setSkip(int skip) {
        if (skip == this.skip) {
            return this;
        }
        return this.copy(skip, this.rowLimit, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    @Nonnull
    public ExecuteProperties setDryRun(boolean isDryRun) {
        if (isDryRun == this.isDryRun) {
            return this;
        }
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, isDryRun);
    }

    public int getReturnedRowLimit() {
        return this.rowLimit;
    }

    @Nonnull
    public ExecuteProperties setReturnedRowLimit(int rowLimit) {
        int newLimit = ExecuteProperties.validateAndNormalizeRowLimit(rowLimit);
        if (newLimit == this.rowLimit) {
            return this;
        }
        return this.copy(this.skip, newLimit, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public int getScannedRecordsLimit() {
        RecordScanLimiter recordScanLimiter = this.getState().getRecordScanLimiter();
        return !recordScanLimiter.isEnforcing() ? Integer.MAX_VALUE : recordScanLimiter.getLimit();
    }

    public long getScannedBytesLimit() {
        ByteScanLimiter byteScanLimiter = this.getState().getByteScanLimiter();
        return !byteScanLimiter.isEnforcing() ? Long.MAX_VALUE : byteScanLimiter.getLimit();
    }

    @Nonnull
    public ExecuteState getState() {
        return this.state;
    }

    @Nonnull
    public ExecuteProperties setState(@Nonnull ExecuteState newState) {
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, newState, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties clearState() {
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, new ExecuteState(), this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    public boolean isFailOnScanLimitReached() {
        return this.failOnScanLimitReached;
    }

    public ExecuteProperties setFailOnScanLimitReached(boolean failOnScanLimitReached) {
        if (failOnScanLimitReached == this.failOnScanLimitReached) {
            return this;
        }
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, this.state, failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties clearReturnedRowLimit() {
        if (this.getReturnedRowLimit() == 0) {
            return this;
        }
        return this.copy(this.skip, 0, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties clearRowAndTimeLimits() {
        if (this.getTimeLimit() == 0L && this.getReturnedRowLimit() == 0) {
            return this;
        }
        return this.copy(this.skip, 0, 0L, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties clearSkipAndLimit() {
        if (this.skip == 0 && this.rowLimit == 0) {
            return this;
        }
        return this.copy(0, 0, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties clearSkipAndAdjustLimit() {
        if (this.skip == 0) {
            return this;
        }
        return this.copy(0, this.rowLimit == 0 ? 0 : this.rowLimit + this.skip, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    public int getReturnedRowLimitOrMax() {
        return this.rowLimit == 0 ? Integer.MAX_VALUE : this.rowLimit;
    }

    @Nonnull
    public ExecuteProperties setLimitsFrom(@Nonnull ExecuteProperties other) {
        Builder builder = this.toBuilder();
        if (other.rowLimit != 0) {
            builder.setReturnedRowLimit(other.rowLimit);
        }
        if (other.timeLimit != 0L) {
            builder.setTimeLimit(other.timeLimit);
        }
        if (other.state.getRecordScanLimiter().isEnforcing() || other.state.getByteScanLimiter().isEnforcing()) {
            builder.setState(other.state);
        }
        return builder.build();
    }

    public CursorStreamingMode getDefaultCursorStreamingMode() {
        return this.defaultCursorStreamingMode;
    }

    public ExecuteProperties setDefaultCursorStreamingMode(CursorStreamingMode defaultCursorStreamingMode) {
        if (defaultCursorStreamingMode == this.defaultCursorStreamingMode) {
            return this;
        }
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, this.state, this.failOnScanLimitReached, defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    public ExecuteProperties resetState() {
        return this.copy(this.skip, this.rowLimit, this.timeLimit, this.isolationLevel, this.state.reset(), this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
    }

    @Nonnull
    protected ExecuteProperties copy(int skip, int rowLimit, long timeLimit, @Nonnull IsolationLevel isolationLevel, @Nonnull ExecuteState state, boolean failOnScanLimitReached, CursorStreamingMode defaultCursorStreamingMode, boolean isDryRun) {
        return new ExecuteProperties(skip, rowLimit, isolationLevel, timeLimit, state, failOnScanLimitReached, defaultCursorStreamingMode, isDryRun);
    }

    @Nonnull
    public ScanProperties asScanProperties(boolean reverse) {
        return new ScanProperties(this, reverse);
    }

    private static int validateAndNormalizeRowLimit(int rowLimit) {
        if (rowLimit < 0) {
            throw new RecordCoreException("Invalid returned row limit specified: " + rowLimit, new Object[0]);
        }
        return rowLimit == Integer.MAX_VALUE ? 0 : rowLimit;
    }

    private static long validateAndNormalizeTimeLimit(long timeLimit) {
        if (timeLimit < 0L) {
            throw new RecordCoreException("Invalid time limit specified: " + timeLimit, new Object[0]);
        }
        if (timeLimit == Long.MAX_VALUE) {
            return 0L;
        }
        return timeLimit;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public String toString() {
        ArrayList<Object> components = new ArrayList<Object>();
        if (!this.isolationLevel.equals((Object)IsolationLevel.SERIALIZABLE)) {
            components.add(this.isolationLevel.toString());
        }
        if (this.skip != 0) {
            components.add("skip " + this.skip);
        }
        if (this.rowLimit != 0) {
            components.add("rowLimit " + this.rowLimit);
        }
        if (this.timeLimit != 0L) {
            components.add("timeLimit " + this.timeLimit + " ms");
        }
        if (this.failOnScanLimitReached) {
            components.add("fail on scan limit");
        }
        components.add(this.state.toString());
        return "ExecuteProperties(" + String.join((CharSequence)", ", components) + ")";
    }

    public static class Builder {
        private IsolationLevel isolationLevel = IsolationLevel.SERIALIZABLE;
        private int skip = 0;
        private int rowLimit = 0;
        private long timeLimit = 0L;
        private int scannedRecordsLimit = Integer.MAX_VALUE;
        private long scannedBytesLimit = Long.MAX_VALUE;
        private ExecuteState executeState = null;
        private boolean failOnScanLimitReached = false;
        private boolean isDryRun = false;
        private CursorStreamingMode defaultCursorStreamingMode = CursorStreamingMode.ITERATOR;

        private Builder() {
        }

        private Builder(ExecuteProperties executeProperties) {
            this.isolationLevel = executeProperties.isolationLevel;
            this.skip = executeProperties.skip;
            this.rowLimit = executeProperties.rowLimit;
            this.timeLimit = executeProperties.timeLimit;
            this.executeState = executeProperties.state;
            this.failOnScanLimitReached = executeProperties.failOnScanLimitReached;
            this.defaultCursorStreamingMode = executeProperties.defaultCursorStreamingMode;
            this.isDryRun = executeProperties.isDryRun;
        }

        @Nonnull
        public Builder setIsolationLevel(@Nonnull IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        @Nonnull
        public IsolationLevel getIsolationLevel() {
            return this.isolationLevel;
        }

        @Nonnull
        public Builder setSkip(int skip) {
            this.skip = skip;
            return this;
        }

        public int getSkip() {
            return this.skip;
        }

        public boolean isDryRun() {
            return this.isDryRun;
        }

        @Nonnull
        public Builder setDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            return this;
        }

        @Nonnull
        public Builder setReturnedRowLimit(int rowLimit) {
            this.rowLimit = ExecuteProperties.validateAndNormalizeRowLimit(rowLimit);
            return this;
        }

        @Nonnull
        public Builder clearReturnedRowLimit() {
            return this.setReturnedRowLimit(Integer.MAX_VALUE);
        }

        public int getReturnedRowLimit() {
            return this.rowLimit;
        }

        public int getReturnedRowLimitOrMax() {
            return this.rowLimit == 0 ? Integer.MAX_VALUE : this.rowLimit;
        }

        @Nonnull
        public Builder clearSkipAndAdjustLimit() {
            if (this.skip != 0) {
                if (this.rowLimit != 0) {
                    this.setReturnedRowLimit(this.rowLimit + this.skip);
                }
                this.setSkip(0);
            }
            return this;
        }

        @Nonnull
        public Builder setTimeLimit(long timeLimit) {
            this.timeLimit = ExecuteProperties.validateAndNormalizeTimeLimit(timeLimit);
            return this;
        }

        @Nonnull
        public Builder clearTimeLimit() {
            return this.setTimeLimit(0L);
        }

        public long getTimeLimit() {
            return this.timeLimit;
        }

        @Nonnull
        public Builder setScannedRecordsLimit(int limit) {
            if (this.executeState != null) {
                throw new RecordCoreException("Tried to set a record scan limit on a builder with an ExecuteState", new Object[0]);
            }
            this.scannedRecordsLimit = Builder.validateAndNormalizeRecordScanLimit(limit);
            return this;
        }

        private static int validateAndNormalizeRecordScanLimit(int scanLimit) {
            if (scanLimit < 0) {
                throw new RecordCoreException("Invalid record scan limit specified: " + scanLimit, new Object[0]);
            }
            return scanLimit;
        }

        @Nonnull
        public Builder clearScannedRecordsLimit() {
            return this.setScannedRecordsLimit(Integer.MAX_VALUE);
        }

        @Nonnull
        public Builder setScannedBytesLimit(long limit) {
            if (this.executeState != null) {
                throw new RecordCoreException("Tried to set a byte scan limit on a builder with an ExecuteState", new Object[0]);
            }
            this.scannedBytesLimit = Builder.validateAndNormalizeByteScanLimit(limit);
            return this;
        }

        private static long validateAndNormalizeByteScanLimit(long scanLimit) {
            if (scanLimit < 0L) {
                throw new RecordCoreException("Invalid record scan limit specified: " + scanLimit, new Object[0]);
            }
            return scanLimit;
        }

        @Nonnull
        public Builder clearScannedBytesLimit() {
            return this.setScannedBytesLimit(Long.MAX_VALUE);
        }

        @Nonnull
        public Builder setState(@Nullable ExecuteState state) {
            if (this.scannedRecordsLimit != Integer.MAX_VALUE || this.scannedBytesLimit != Long.MAX_VALUE) {
                throw new RecordCoreException("Tried to set a state on a builder with a record scan limit or byte scan limit", new Object[0]);
            }
            this.executeState = state;
            return this;
        }

        @Nonnull
        public Builder clearState() {
            return this.setState(null);
        }

        public Builder setFailOnScanLimitReached(boolean failOnScanLimitReached) {
            this.failOnScanLimitReached = failOnScanLimitReached;
            return this;
        }

        public CursorStreamingMode getDefaultCursorStreamingMode() {
            return this.defaultCursorStreamingMode;
        }

        public Builder setDefaultCursorStreamingMode(CursorStreamingMode defaultCursorStreamingMode) {
            this.defaultCursorStreamingMode = defaultCursorStreamingMode;
            return this;
        }

        @Nonnull
        public ExecuteProperties build() {
            ExecuteState state = this.executeState != null ? this.executeState : (this.scannedRecordsLimit == Integer.MAX_VALUE && this.scannedBytesLimit == Long.MAX_VALUE ? new ExecuteState(RecordScanLimiterFactory.tracking(), ByteScanLimiterFactory.tracking()) : (this.scannedBytesLimit == Long.MAX_VALUE ? new ExecuteState(RecordScanLimiterFactory.enforce(this.scannedRecordsLimit), ByteScanLimiterFactory.tracking()) : (this.scannedRecordsLimit == Integer.MAX_VALUE ? new ExecuteState(RecordScanLimiterFactory.tracking(), ByteScanLimiterFactory.enforce(this.scannedBytesLimit)) : new ExecuteState(RecordScanLimiterFactory.enforce(this.scannedRecordsLimit), ByteScanLimiterFactory.enforce(this.scannedBytesLimit)))));
            return new ExecuteProperties(this.skip, this.rowLimit, this.isolationLevel, this.timeLimit, state, this.failOnScanLimitReached, this.defaultCursorStreamingMode, this.isDryRun);
        }
    }
}

