/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteScanLimiter;
import com.apple.foundationdb.record.ByteScanLimiterFactory;
import com.apple.foundationdb.record.RecordScanLimiter;
import com.apple.foundationdb.record.RecordScanLimiterFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ExecuteState {
    public static final ExecuteState NO_LIMITS = new ExecuteState(RecordScanLimiterFactory.untracked(), ByteScanLimiterFactory.untracked());
    @Nonnull
    private final RecordScanLimiter recordScanLimiter;
    @Nonnull
    private final ByteScanLimiter byteScanLimiter;

    public ExecuteState(@Nullable RecordScanLimiter recordScanLimiter, @Nullable ByteScanLimiter byteScanLimiter) {
        this.recordScanLimiter = recordScanLimiter == null ? RecordScanLimiterFactory.tracking() : recordScanLimiter;
        this.byteScanLimiter = byteScanLimiter == null ? ByteScanLimiterFactory.tracking() : byteScanLimiter;
    }

    public ExecuteState() {
        this(RecordScanLimiterFactory.tracking(), ByteScanLimiterFactory.tracking());
    }

    @Nonnull
    public ExecuteState reset() {
        return new ExecuteState(this.recordScanLimiter.reset(), this.byteScanLimiter.reset());
    }

    @Nonnull
    public RecordScanLimiter getRecordScanLimiter() {
        return this.recordScanLimiter;
    }

    @Nonnull
    public ByteScanLimiter getByteScanLimiter() {
        return this.byteScanLimiter;
    }

    public int getRecordsScanned() {
        return this.recordScanLimiter.getRecordsScanned();
    }

    public long getBytesScanned() {
        return this.byteScanLimiter.getBytesScanned();
    }

    public String toString() {
        return "State(" + String.valueOf(this.recordScanLimiter) + ", " + String.valueOf(this.byteScanLimiter) + ")";
    }
}

