/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class IndexEntry {
    private static final Key.Evaluated.NullStandin[] NO_NULLS = new Key.Evaluated.NullStandin[0];
    @Nonnull
    private final Index index;
    @Nonnull
    private final Tuple key;
    @Nonnull
    private final Tuple value;
    @Nullable
    private Tuple primaryKey;
    @Nullable
    private Key.Evaluated.NullStandin[] nullStandins;

    @API(value=API.Status.INTERNAL)
    public IndexEntry(@Nonnull Index index, @Nonnull Key.Evaluated key, @Nonnull Key.Evaluated value) {
        this(index, key.toTuple(), value.toTuple());
        int idx = 0;
        for (Object keyValue : key.values()) {
            if (keyValue instanceof Key.Evaluated.NullStandin) {
                if (this.nullStandins == null) {
                    this.nullStandins = new Key.Evaluated.NullStandin[key.size()];
                }
                this.nullStandins[idx] = (Key.Evaluated.NullStandin)((Object)keyValue);
            }
            ++idx;
        }
        if (this.nullStandins == null) {
            this.nullStandins = NO_NULLS;
        }
    }

    @API(value=API.Status.INTERNAL)
    public IndexEntry(@Nonnull Index index, @Nonnull Key.Evaluated key) {
        this(index, key, Key.Evaluated.EMPTY);
    }

    @API(value=API.Status.INTERNAL)
    public IndexEntry(@Nonnull Index index, @Nonnull Tuple key, @Nonnull Tuple value) {
        this(index, key, value, null);
    }

    @API(value=API.Status.INTERNAL)
    public IndexEntry(@Nonnull Index index, @Nonnull Tuple key, @Nonnull Tuple value, @Nullable Tuple primaryKey) {
        this.index = index;
        this.key = key;
        this.value = value;
        this.primaryKey = primaryKey;
    }

    @Nonnull
    public Index getIndex() {
        return this.index;
    }

    @Nonnull
    public Tuple getKey() {
        return this.key;
    }

    @Nonnull
    public Tuple getValue() {
        return this.value;
    }

    public int getKeySize() {
        return this.key.size();
    }

    @Nonnull
    public Tuple getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.index.getEntryPrimaryKey(this.key);
        }
        return this.primaryKey;
    }

    @Nullable
    public Object getKeyValue(int idx) {
        return this.key.get(idx);
    }

    @API(value=API.Status.INTERNAL)
    public void validateInIndex(@Nonnull Index index) {
        if (!index.equals(this.getIndex())) {
            throw new RecordCoreArgumentException("index entry's index " + this.getIndex().getName() + " differs from specified index " + index.getName(), new Object[0]);
        }
    }

    public boolean keyContainsNonUniqueNull() {
        this.checkIfNullTypeAvailable();
        for (Key.Evaluated.NullStandin nullStandin : this.nullStandins) {
            if (nullStandin != Key.Evaluated.NullStandin.NULL) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Key.Evaluated.NullStandin getKeyNullType(int idx) {
        this.checkIfNullTypeAvailable();
        if (this.nullStandins.length == 0 || this.nullStandins[idx] == null) {
            throw new RecordCoreException("Value is not null", new Object[0]).addLogInfo("index", (Object)idx);
        }
        return this.nullStandins[idx];
    }

    @Nonnull
    public IndexEntry subKey(int startIdx, int endIdx) {
        if (startIdx == 0 && endIdx == this.key.size()) {
            return this;
        }
        IndexEntry subKey = new IndexEntry(this.index, TupleHelpers.subTuple(this.key, startIdx, endIdx), this.value);
        if (this.nullStandins == null || this.nullStandins.length == 0) {
            subKey.nullStandins = this.nullStandins;
        } else {
            subKey.nullStandins = new Key.Evaluated.NullStandin[endIdx - startIdx];
            System.arraycopy(this.nullStandins, startIdx, subKey.nullStandins, 0, endIdx - startIdx);
        }
        return subKey;
    }

    private void checkIfNullTypeAvailable() {
        if (this.nullStandins == null) {
            throw new RecordCoreException("Type of null cannot be determined from tuple", new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntry that = (IndexEntry)o;
        return Objects.equals(this.index, that.index) && TupleHelpers.equals(this.key, that.key) && TupleHelpers.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.key, this.value);
    }

    public String toString() {
        return this.index.getName() + ":" + String.valueOf(this.key) + ":" + String.valueOf(this.value);
    }
}

