/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PIndexFetchMethod;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public enum IndexFetchMethod {
    SCAN_AND_FETCH,
    USE_REMOTE_FETCH,
    USE_REMOTE_FETCH_WITH_FALLBACK;


    @Nonnull
    public PIndexFetchMethod toProto(@Nonnull PlanSerializationContext serializationContext) {
        switch (this) {
            case SCAN_AND_FETCH: {
                return PIndexFetchMethod.SCAN_AND_FETCH;
            }
            case USE_REMOTE_FETCH: {
                return PIndexFetchMethod.USE_REMOTE_FETCH;
            }
            case USE_REMOTE_FETCH_WITH_FALLBACK: {
                return PIndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK;
            }
        }
        throw new RecordCoreException("unknown index fetch method mapping. did you forget to add it?", new Object[0]);
    }

    @Nonnull
    public static IndexFetchMethod fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexFetchMethod indexFetchMethodProto) {
        switch (indexFetchMethodProto) {
            case SCAN_AND_FETCH: {
                return SCAN_AND_FETCH;
            }
            case USE_REMOTE_FETCH: {
                return USE_REMOTE_FETCH;
            }
            case USE_REMOTE_FETCH_WITH_FALLBACK: {
                return USE_REMOTE_FETCH_WITH_FALLBACK;
            }
        }
        throw new RecordCoreException("unknown index fetch method mapping. did you forget to add it?", new Object[0]);
    }
}

