/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PIndexScanType;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class IndexScanType
implements PlanHashable,
PlanSerializable {
    @Nonnull
    public static final IndexScanType BY_VALUE = new IndexScanType("BY_VALUE");
    @Nonnull
    public static final IndexScanType BY_VALUE_OVER_SCAN = new IndexScanType("BY_VALUE_OVER_SCAN");
    @Nonnull
    public static final IndexScanType BY_RANK = new IndexScanType("BY_RANK");
    @Nonnull
    public static final IndexScanType BY_GROUP = new IndexScanType("BY_GROUP");
    @Nonnull
    public static final IndexScanType BY_TIME_WINDOW = new IndexScanType("BY_TIME_WINDOW");
    @Nonnull
    public static final IndexScanType BY_TEXT_TOKEN = new IndexScanType("BY_TEXT_TOKEN");
    private final String name;

    public IndexScanType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexScanType that = (IndexScanType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return this.hashCode();
    }

    @Override
    @Nonnull
    public PIndexScanType toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PIndexScanType.newBuilder().setName(this.name).build();
    }

    @Nonnull
    public static IndexScanType fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexScanType indexScanTypeProto) {
        return new IndexScanType(Objects.requireNonNull(indexScanTypeProto.getName()));
    }
}

