/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreStorageException;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public enum IndexState {
    READABLE(0L, "indexesReadable"),
    WRITE_ONLY(1L, "indexesWriteOnly"),
    DISABLED(2L, "indexesDisabled"),
    READABLE_UNIQUE_PENDING(3L, "indexesReadableUniquePending");

    private final long id;
    private final String logName;
    @Nonnull
    private final Object code;

    private IndexState(long id, String logName) {
        this.id = id;
        this.code = id;
        this.logName = logName;
    }

    @Nonnull
    public Object code() {
        return this.code;
    }

    public String getLogName() {
        return this.logName;
    }

    public boolean isScannable() {
        return this.equals((Object)READABLE) || this.equals((Object)READABLE_UNIQUE_PENDING);
    }

    public boolean isWriteOnly() {
        return this.equals((Object)WRITE_ONLY);
    }

    public static IndexState fromCode(@Nonnull Object code) {
        for (IndexState state : IndexState.values()) {
            if (!state.code().equals(code)) continue;
            return state;
        }
        throw new RecordCoreStorageException("No IndexState found matching code " + String.valueOf(code));
    }
}

