/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EndpointType;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class KeyRange {
    @Nonnull
    private final byte[] lowKey;
    @Nonnull
    private final EndpointType lowEndpoint;
    @Nonnull
    private final byte[] highKey;
    @Nonnull
    private final EndpointType highEndpoint;

    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP2"})
    public KeyRange(@Nonnull byte[] lowKey, @Nonnull EndpointType lowEndpoint, @Nonnull byte[] highKey, @Nonnull EndpointType highEndpoint) {
        this.lowKey = lowKey;
        this.lowEndpoint = lowEndpoint;
        this.highKey = highKey;
        this.highEndpoint = highEndpoint;
    }

    public KeyRange(@Nonnull byte[] lowKey, @Nonnull byte[] highKey) {
        this(lowKey, EndpointType.RANGE_INCLUSIVE, highKey, EndpointType.RANGE_EXCLUSIVE);
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getLowKey() {
        return this.lowKey;
    }

    @Nonnull
    public EndpointType getLowEndpoint() {
        return this.lowEndpoint;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getHighKey() {
        return this.highKey;
    }

    @Nonnull
    public EndpointType getHighEndpoint() {
        return this.highEndpoint;
    }
}

