/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexState;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.RecordStoreState;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class MutableRecordStoreState
extends RecordStoreState {
    private static final long READ_MASK = -65536L;
    private static final long WRITE_MASK = 65535L;
    private final AtomicLong users = new AtomicLong();

    public MutableRecordStoreState(@Nullable RecordMetaDataProto.DataStoreInfo storeHeader, @Nullable Map<String, IndexState> indexStateMap) {
        super(storeHeader, indexStateMap);
    }

    MutableRecordStoreState(@Nonnull RecordStoreState recordStoreState) {
        this(recordStoreState.getStoreHeader(), recordStoreState.getIndexStates());
    }

    private static long readIncrement(long u) {
        return (u >> 32) + 1L << 32 & 0xFFFFFFFFFFFF0000L | u & 0xFFFFL;
    }

    private static long readDecrement(long u) {
        return (u >> 32) - 1L << 32 & 0xFFFFFFFFFFFF0000L | u & 0xFFFFL;
    }

    private static long writeIncrement(long u) {
        return u & 0xFFFFFFFFFFFF0000L | (u & 0xFFFFL) + 1L & 0xFFFFL;
    }

    private static long writeDecrement(long u) {
        return u & 0xFFFFFFFFFFFF0000L | (u & 0xFFFFL) - 1L & 0xFFFFL;
    }

    private void verifyWritable() {
        if ((this.users.get() & 0xFFFFL) == 0L) {
            throw new RecordCoreException("record store state is not enabled for modification", new Object[0]);
        }
    }

    @Override
    public void beginRead() {
        long inuse = this.users.updateAndGet(MutableRecordStoreState::readIncrement);
        if ((inuse & 0xFFFFL) != 0L) {
            this.users.updateAndGet(MutableRecordStoreState::readDecrement);
            throw new RecordCoreException("record store state is being modified", new Object[0]);
        }
    }

    @Override
    public void endRead() {
        this.users.updateAndGet(MutableRecordStoreState::readDecrement);
    }

    public void beginWrite() {
        long inuse;
        Map current = (Map)this.indexStateMap.get();
        if (!(current instanceof ConcurrentHashMap)) {
            this.indexStateMap.compareAndSet(current, new ConcurrentHashMap(current));
        }
        if (((inuse = this.users.updateAndGet(MutableRecordStoreState::writeIncrement)) & 0xFFFFFFFFFFFF0000L) != 0L) {
            this.users.updateAndGet(MutableRecordStoreState::writeDecrement);
            throw new RecordCoreException("record store state is being used for queries", new Object[0]);
        }
    }

    public void endWrite() {
        this.users.updateAndGet(MutableRecordStoreState::writeDecrement);
    }

    @Nonnull
    public IndexState setState(@Nonnull String indexName, @Nonnull IndexState state) {
        this.verifyWritable();
        IndexState previous = state == IndexState.READABLE ? (IndexState)((Object)((Map)this.indexStateMap.get()).remove(indexName)) : ((Map)this.indexStateMap.get()).put(indexName, state);
        return previous == null ? IndexState.READABLE : previous;
    }

    @Override
    @Nonnull
    public MutableRecordStoreState withWriteOnlyIndexes(@Nonnull List<String> writeOnlyIndexNames) {
        return new MutableRecordStoreState(this.getStoreHeader(), this.writeOnlyMap(writeOnlyIndexNames));
    }

    @Nonnull
    public RecordMetaDataProto.DataStoreInfo setStoreHeader(@Nonnull RecordMetaDataProto.DataStoreInfo storeHeader) {
        this.verifyWritable();
        return this.storeHeader.getAndSet(storeHeader);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Nonnull
    public RecordStoreState toImmutable() {
        return new RecordStoreState((RecordMetaDataProto.DataStoreInfo)this.storeHeader.get(), (Map)this.indexStateMap.get());
    }
}

