/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface PlanHashable {
    public static final PlanHashMode CURRENT_LEGACY = PlanHashMode.VL0;
    public static final PlanHashMode CURRENT_FOR_CONTINUATION = PlanHashMode.VC0;

    @Nonnull
    private static PlanHashMode currentHashMode(@Nonnull PlanHashKind kind) {
        switch (kind) {
            case LEGACY: {
                return CURRENT_LEGACY;
            }
            case FOR_CONTINUATION: {
                return CURRENT_FOR_CONTINUATION;
            }
        }
        throw new RecordCoreException("unsupported plan hash kind", new Object[0]);
    }

    public int planHash(@Nonnull PlanHashMode var1);

    @Deprecated(forRemoval=true)
    default public int planHash(@Nonnull PlanHashKind kind) {
        return this.planHash(PlanHashable.currentHashMode(kind));
    }

    @Deprecated(forRemoval=true)
    default public int planHash() {
        return this.planHash(PlanHashKind.LEGACY);
    }

    @Deprecated(forRemoval=true)
    public static int planHash(@Nonnull PlanHashKind kind, @Nonnull Iterable<? extends PlanHashable> hashables) {
        return PlanHashable.planHash(PlanHashable.currentHashMode(kind), hashables);
    }

    public static int planHash(@Nonnull PlanHashMode mode, @Nonnull Iterable<? extends PlanHashable> hashables) {
        int result = 1;
        for (PlanHashable planHashable : hashables) {
            result = 31 * result + (planHashable != null ? planHashable.planHash(mode) : 0);
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static int planHash(@Nonnull PlanHashKind kind, PlanHashable ... hashables) {
        return PlanHashable.planHash(PlanHashable.currentHashMode(kind), Arrays.asList(hashables));
    }

    public static int planHash(@Nonnull PlanHashMode mode, PlanHashable ... hashables) {
        return PlanHashable.planHash(mode, Arrays.asList(hashables));
    }

    @Deprecated(forRemoval=true)
    public static int planHashUnordered(@Nonnull PlanHashKind kind, @Nonnull Iterable<? extends PlanHashable> hashables) {
        return PlanHashable.planHashUnordered(PlanHashable.currentHashMode(kind), hashables);
    }

    public static int planHashUnordered(@Nonnull PlanHashMode hashMode, @Nonnull Iterable<? extends PlanHashable> hashables) {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        for (PlanHashable planHashable : hashables) {
            hashes.add(planHashable != null ? planHashable.planHash(hashMode) : 0);
        }
        hashes.sort(Comparator.naturalOrder());
        return PlanHashable.combineHashes(hashes);
    }

    @Deprecated(forRemoval=true)
    public static int stringHashUnordered(@Nonnull Iterable<String> strings) {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        for (String str : strings) {
            hashes.add(str != null ? str.hashCode() : 0);
        }
        hashes.sort(Comparator.naturalOrder());
        return PlanHashable.combineHashes(hashes);
    }

    public static int combineHashes(@Nonnull List<Integer> hashes) {
        int result = 1;
        for (Integer hash : hashes) {
            result = 31 * result + hash;
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static int objectPlanHash(@Nonnull PlanHashKind kind, @Nullable Object obj) {
        return PlanHashable.objectPlanHash(PlanHashable.currentHashMode(kind), obj);
    }

    public static int objectPlanHash(@Nonnull PlanHashMode mode, @Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name().hashCode();
        }
        if (mode.getKind() != PlanHashKind.LEGACY && obj instanceof Set) {
            return PlanHashable.setsPlanHash(mode, (Set)obj);
        }
        if (mode.getKind() != PlanHashKind.LEGACY && obj instanceof Map) {
            return PlanHashable.mapsPlanHash(mode, (Map)obj);
        }
        if (obj instanceof Iterable) {
            return PlanHashable.iterablePlanHash(mode, (Iterable)obj);
        }
        if (obj instanceof Object[]) {
            return PlanHashable.objectsPlanHash(mode, (Object[])obj);
        }
        if (obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive()) {
            return PlanHashable.primitiveArrayHash(obj);
        }
        if (obj instanceof PlanHashable) {
            return ((PlanHashable)obj).planHash(mode);
        }
        return obj.hashCode();
    }

    @Deprecated(forRemoval=true)
    public static int iterablePlanHash(@Nonnull PlanHashKind kind, @Nonnull Iterable<?> objects) {
        return PlanHashable.iterablePlanHash(PlanHashable.currentHashMode(kind), objects);
    }

    public static int iterablePlanHash(@Nonnull PlanHashMode mode, @Nonnull Iterable<?> objects) {
        int result = 1;
        for (Object object : objects) {
            result = 31 * result + PlanHashable.objectPlanHash(mode, object);
        }
        return result;
    }

    public static int setsPlanHash(@Nonnull PlanHashMode mode, @Nonnull Set<?> objects) {
        int result = 1;
        for (Object object : objects) {
            result += 31 * PlanHashable.objectPlanHash(mode, object);
        }
        return result;
    }

    public static int mapsPlanHash(@Nonnull PlanHashMode mode, @Nonnull Map<?, ?> map) {
        int result = 1;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result += 31 * PlanHashable.objectsPlanHash(mode, entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static int objectsPlanHash(@Nonnull PlanHashKind kind, Object ... objects) {
        return PlanHashable.objectsPlanHash(PlanHashable.currentHashMode(kind), Arrays.asList(objects));
    }

    public static int objectsPlanHash(@Nonnull PlanHashMode mode, Object ... objects) {
        return PlanHashable.objectPlanHash(mode, Arrays.asList(objects));
    }

    public static int primitiveArrayHash(Object primitiveArray) {
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((boolean[])primitiveArray);
        }
        if (Byte.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((byte[])primitiveArray);
        }
        if (Character.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((char[])primitiveArray);
        }
        if (Double.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((double[])primitiveArray);
        }
        if (Float.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((float[])primitiveArray);
        }
        if (Integer.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((int[])primitiveArray);
        }
        if (Long.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((long[])primitiveArray);
        }
        if (Short.TYPE.isAssignableFrom(componentType)) {
            return Arrays.hashCode((short[])primitiveArray);
        }
        throw new IllegalArgumentException("Unknown type for hash code: " + String.valueOf(componentType));
    }

    public static enum PlanHashKind {
        LEGACY,
        FOR_CONTINUATION;

    }

    public static enum PlanHashMode {
        VL0(PlanHashKind.LEGACY, 0),
        VC0(PlanHashKind.FOR_CONTINUATION, 0),
        VC1(PlanHashKind.FOR_CONTINUATION, 1);

        private final PlanHashKind kind;
        private final int numericVersion;

        private PlanHashMode(PlanHashKind kind, int numericVersion) {
            this.kind = kind;
            this.numericVersion = numericVersion;
        }

        public PlanHashKind getKind() {
            return this.kind;
        }

        public int getNumericVersion() {
            return this.numericVersion;
        }
    }
}

