/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.planprotos.PPlanReference;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.serialization.DefaultPlanSerializationRegistry;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerializationRegistry;
import com.google.common.base.Equivalence;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class PlanSerializationContext {
    @Nonnull
    private static final RecordTypeWithNameEquivalence recordTypeWithNameEquivalence = new RecordTypeWithNameEquivalence();
    @Nonnull
    private final PlanSerializationRegistry registry;
    @Nonnull
    private final PlanHashable.PlanHashMode mode;
    @Nonnull
    private final IdentityBiMap<RecordQueryPlan, Integer> knownPlansMap;
    @Nonnull
    private final BiMap<Equivalence.Wrapper<Type.Record>, Integer> knownRecordTypesMap;

    public PlanSerializationContext(@Nonnull PlanSerializationRegistry registry, @Nonnull PlanHashable.PlanHashMode mode) {
        this(registry, mode, IdentityBiMap.create(), HashBiMap.create());
    }

    public PlanSerializationContext(@Nonnull PlanSerializationRegistry registry, @Nonnull PlanHashable.PlanHashMode mode, @Nonnull IdentityBiMap<RecordQueryPlan, Integer> knownPlansMap, @Nonnull BiMap<Equivalence.Wrapper<Type.Record>, Integer> knownRecordTypesMap) {
        this.registry = registry;
        this.mode = mode;
        this.knownPlansMap = knownPlansMap;
        this.knownRecordTypesMap = knownRecordTypesMap;
    }

    @Nonnull
    public PlanSerializationRegistry getRegistry() {
        return this.registry;
    }

    @Nonnull
    public PlanHashable.PlanHashMode getMode() {
        return this.mode;
    }

    @Nonnull
    public static PlanSerializationContext newForCurrentMode() {
        return PlanSerializationContext.newForCurrentMode(DefaultPlanSerializationRegistry.INSTANCE);
    }

    @Nonnull
    public static PlanSerializationContext newForCurrentMode(@Nonnull PlanSerializationRegistry registry) {
        return new PlanSerializationContext(registry, PlanHashable.CURRENT_FOR_CONTINUATION);
    }

    @Nonnull
    public PPlanReference toPlanReferenceProto(@Nonnull RecordQueryPlan recordQueryPlan) {
        Integer referenceId = this.knownPlansMap.getUnwrapped(recordQueryPlan);
        if (referenceId != null) {
            return PPlanReference.newBuilder().setReferenceId(referenceId).build();
        }
        referenceId = this.knownPlansMap.size();
        this.knownPlansMap.putUnwrapped(recordQueryPlan, referenceId);
        return PPlanReference.newBuilder().setReferenceId(referenceId).setRecordQueryPlan(recordQueryPlan.toRecordQueryPlanProto(this)).build();
    }

    @Nonnull
    public RecordQueryPlan fromPlanReferenceProto(@Nonnull PPlanReference planReferenceProto) {
        BiMap inverse = this.knownPlansMap.inverse();
        Verify.verify(planReferenceProto.hasReferenceId());
        int referenceId = planReferenceProto.getReferenceId();
        if (((IdentityBiMap)inverse).containsKeyUnwrapped(referenceId)) {
            return Objects.requireNonNull((RecordQueryPlan)((IdentityBiMap)inverse).getUnwrapped(referenceId));
        }
        RecordQueryPlan recordQueryPlan = RecordQueryPlan.fromRecordQueryPlanProto(this, Objects.requireNonNull(planReferenceProto.getRecordQueryPlan()));
        Verify.verify(this.knownPlansMap.putUnwrapped(recordQueryPlan, referenceId) == null);
        return recordQueryPlan;
    }

    public int registerReferenceIdForRecordType(@Nonnull Type.Record recordType) {
        return this.registerReferenceIdForRecordType(recordType, this.knownRecordTypesMap.size());
    }

    public int registerReferenceIdForRecordType(@Nonnull Type.Record recordType, int referenceId) {
        this.knownRecordTypesMap.put(recordTypeWithNameEquivalence.wrap(recordType), referenceId);
        return referenceId;
    }

    @Nullable
    public Integer lookupReferenceIdForRecordType(@Nonnull Type.Record type) {
        return (Integer)this.knownRecordTypesMap.get(recordTypeWithNameEquivalence.wrap(type));
    }

    @Nullable
    public Type.Record lookupRecordTypeForReferenceId(int referenceId) {
        BiMap<Integer, Equivalence.Wrapper<Type.Record>> inverse = this.knownRecordTypesMap.inverse();
        Equivalence.Wrapper wrapper = (Equivalence.Wrapper)inverse.get(referenceId);
        return wrapper == null ? null : (Type.Record)wrapper.get();
    }

    private static class RecordTypeWithNameEquivalence
    extends Equivalence<Type.Record> {
        private RecordTypeWithNameEquivalence() {
        }

        @Override
        protected boolean doEquivalent(@Nonnull Type.Record a, @Nonnull Type.Record b) {
            if (!a.equals(b)) {
                return false;
            }
            return Objects.equals(a.getName(), b.getName());
        }

        @Override
        protected int doHash(@Nonnull Type.Record record) {
            return Objects.hash(record.getName(), record.hashCode());
        }
    }
}

