/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreInterruptedException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorIterator;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.cursors.AsyncIteratorCursor;
import com.apple.foundationdb.record.cursors.EmptyCursor;
import com.apple.foundationdb.record.cursors.FilterCursor;
import com.apple.foundationdb.record.cursors.FlatMapPipelinedCursor;
import com.apple.foundationdb.record.cursors.FutureCursor;
import com.apple.foundationdb.record.cursors.IteratorCursor;
import com.apple.foundationdb.record.cursors.ListCursor;
import com.apple.foundationdb.record.cursors.MapPipelinedCursor;
import com.apple.foundationdb.record.cursors.MapResultCursor;
import com.apple.foundationdb.record.cursors.OrElseCursor;
import com.apple.foundationdb.record.cursors.RowLimitedCursor;
import com.apple.foundationdb.record.cursors.SkipCursor;
import com.apple.foundationdb.record.logging.CompletionExceptionLogHelper;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface RecordCursor<T>
extends AutoCloseable {
    @Nonnull
    public CompletableFuture<RecordCursorResult<T>> onNext();

    @Nonnull
    default public RecordCursorResult<T> getNext() {
        try {
            return this.onNext().get();
        }
        catch (ExecutionException ex) {
            throw new RecordCoreException(CompletionExceptionLogHelper.asCause(ex));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RecordCoreInterruptedException(ex.getMessage(), ex);
        }
    }

    @Nonnull
    @API(value=API.Status.UNSTABLE)
    default public RecordCursorIterator<T> asIterator() {
        return new RecordCursorIterator(this);
    }

    @Override
    public void close();

    public boolean isClosed();

    @Nonnull
    public Executor getExecutor();

    public boolean accept(@Nonnull RecordCursorVisitor var1);

    @Nonnull
    default public CompletableFuture<List<T>> asList() {
        ArrayList result = new ArrayList();
        return this.forEach(result::add).thenApply(vignore -> result);
    }

    @Nonnull
    default public CompletableFuture<List<T>> asList(AtomicReference<RecordCursorResult<T>> terminatingResultRef) {
        ArrayList list = new ArrayList();
        return this.forEachResult(result -> list.add(result.get())).thenApply(finalResult -> {
            terminatingResultRef.set((RecordCursorResult)finalResult);
            return list;
        });
    }

    @Nonnull
    default public CompletableFuture<Integer> getCount() {
        int[] i = new int[]{0};
        return this.forEachResult(result -> {
            i[0] = i[0] + 1;
        }).thenApply(vignore -> i[0]);
    }

    @Nonnull
    default public CompletableFuture<Optional<T>> first() {
        return this.onNext().thenApply(result -> result.hasNext() ? Optional.ofNullable(result.get()) : Optional.empty());
    }

    @Nonnull
    default public <V> RecordCursor<V> map(@Nonnull Function<T, V> func) {
        return this.mapResult(result -> result.map(func));
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    default public <V> RecordCursor<V> mapResult(@Nonnull Function<RecordCursorResult<T>, RecordCursorResult<V>> func) {
        return new MapResultCursor<T, V>(this, func);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static <T> RecordCursor<T> mapContinuation(@Nonnull Function<byte[], RecordCursor<T>> cursorFunction, @Nonnull ContinuationConvertor convertor, @Nullable byte[] continuation) {
        byte[] innerContinuation = convertor.unwrapContinuation(continuation);
        return cursorFunction.apply(innerContinuation).mapResult(result -> result.withContinuation(convertor.wrapContinuation(result.getContinuation())));
    }

    @Nonnull
    default public RecordCursor<T> mapEffect(@Nonnull Consumer<T> consumer) {
        return this.map(rec -> {
            consumer.accept(rec);
            return rec;
        });
    }

    @Nonnull
    default public RecordCursor<T> mapEffect(@Nonnull Runnable runnable) {
        return this.mapResult(result -> {
            runnable.run();
            return result;
        });
    }

    @Nonnull
    default public RecordCursor<T> filter(@Nonnull Function<T, Boolean> pred) {
        return new FilterCursor<T>(this, pred);
    }

    @Nonnull
    default public RecordCursor<T> filterInstrumented(@Nonnull Function<T, Boolean> pred, @Nullable StoreTimer timer, @Nullable StoreTimer.Count in, @Nullable StoreTimer.Event during, @Nullable StoreTimer.Count success, @Nullable StoreTimer.Count failure) {
        Set<StoreTimer.Count> inSet = in != null ? Collections.singleton(in) : Collections.emptySet();
        Set<StoreTimer.Event> duringSet = during != null ? Collections.singleton(during) : Collections.emptySet();
        Set<StoreTimer.Count> successSet = success != null ? Collections.singleton(success) : Collections.emptySet();
        Set<StoreTimer.Count> failureSet = failure != null ? Collections.singleton(failure) : Collections.emptySet();
        return this.filterInstrumented(pred, timer, inSet, duringSet, successSet, failureSet);
    }

    @Nonnull
    default public RecordCursor<T> filterInstrumented(@Nonnull Function<T, Boolean> pred, @Nullable StoreTimer timer, @Nonnull Set<StoreTimer.Count> inSet, @Nonnull Set<StoreTimer.Event> duringSet, @Nonnull Set<StoreTimer.Count> successSet, @Nonnull Set<StoreTimer.Count> failureSet) {
        if (timer == null) {
            return this.filter(pred);
        }
        return this.filter(record -> {
            for (StoreTimer.Count in : inSet) {
                timer.increment(in);
            }
            long startTime = System.nanoTime();
            Boolean p = (Boolean)pred.apply(record);
            for (StoreTimer.Event during : duringSet) {
                timer.recordSinceNanoTime(during, startTime);
            }
            if (Boolean.TRUE.equals(p)) {
                for (StoreTimer.Count success : successSet) {
                    timer.increment(success);
                }
            } else {
                for (StoreTimer.Count failure : failureSet) {
                    timer.increment(failure);
                }
            }
            return p;
        });
    }

    default public RecordCursor<T> skip(int skip) {
        if (skip < 0) {
            throw new RecordCoreException("Invalid skip count: " + skip, new Object[0]);
        }
        if (skip == 0) {
            return this;
        }
        return new SkipCursor(this, skip);
    }

    @Nonnull
    default public RecordCursor<T> limitRowsTo(int limit) {
        if (limit < 0) {
            throw new RecordCoreException("Invalid row limit: " + limit, new Object[0]);
        }
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            return new RowLimitedCursor(this, limit);
        }
        return this;
    }

    @Nonnull
    default public RecordCursor<T> skipThenLimit(int skip, int limit) {
        return this.skip(skip).limitRowsTo(limit);
    }

    @Nonnull
    default public <V> RecordCursor<V> mapPipelined(@Nonnull Function<T, CompletableFuture<V>> func, int pipelineSize) {
        return new MapPipelinedCursor<T, V>(this, func, pipelineSize);
    }

    @Nonnull
    public static <T, V> RecordCursor<V> flatMapPipelined(@Nonnull Function<byte[], ? extends RecordCursor<T>> outerFunc, @Nonnull BiFunction<T, byte[], ? extends RecordCursor<V>> innerFunc, @Nullable byte[] continuation, int pipelineSize) {
        return RecordCursor.flatMapPipelined(outerFunc, innerFunc, null, continuation, pipelineSize);
    }

    @Nonnull
    public static <T, V> RecordCursor<V> flatMapPipelined(@Nonnull Function<byte[], ? extends RecordCursor<T>> outerFunc, @Nonnull BiFunction<T, byte[], ? extends RecordCursor<V>> innerFunc, @Nullable Function<T, byte[]> checker, @Nullable byte[] continuation, int pipelineSize) {
        RecordCursorProto.FlatMapContinuation parsed;
        if (continuation == null) {
            return new FlatMapPipelinedCursor(outerFunc.apply(null), innerFunc, checker, null, null, null, pipelineSize);
        }
        try {
            parsed = RecordCursorProto.FlatMapContinuation.parseFrom(continuation);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("error parsing continuation", ex).addLogInfo("raw_bytes", (Object)ByteArrayUtil2.loggable(continuation));
        }
        byte[] outerContinuation = parsed.hasOuterContinuation() ? parsed.getOuterContinuation().toByteArray() : null;
        byte[] innerContinuation = parsed.hasInnerContinuation() ? parsed.getInnerContinuation().toByteArray() : null;
        byte[] checkValue = parsed.hasCheckValue() ? parsed.getCheckValue().toByteArray() : null;
        RecordCursor<T> outerCursor = outerFunc.apply(outerContinuation);
        return new FlatMapPipelinedCursor(outerCursor, innerFunc, checker, outerContinuation, checkValue, innerContinuation, pipelineSize);
    }

    @Nonnull
    default public RecordCursor<T> filterAsync(@Nonnull Function<T, CompletableFuture<Boolean>> pred, int pipelineSize) {
        return this.mapPipelined(t2 -> ((CompletableFuture)pred.apply(t2)).thenApply(matches -> matches != null && matches != false ? Optional.of(t2) : Optional.empty()), pipelineSize).filter(Optional::isPresent).map(Optional::get);
    }

    @Nonnull
    default public RecordCursor<T> filterAsyncInstrumented(@Nonnull Function<T, CompletableFuture<Boolean>> pred, int pipelineSize, @Nullable StoreTimer timer, @Nullable StoreTimer.Count in, @Nullable StoreTimer.Event during, @Nullable StoreTimer.Count success, @Nullable StoreTimer.Count failure) {
        Set<StoreTimer.Count> inSet = in != null ? Collections.singleton(in) : Collections.emptySet();
        Set<StoreTimer.Event> duringSet = during != null ? Collections.singleton(during) : Collections.emptySet();
        Set<StoreTimer.Count> successSet = success != null ? Collections.singleton(success) : Collections.emptySet();
        Set<StoreTimer.Count> failureSet = failure != null ? Collections.singleton(failure) : Collections.emptySet();
        return this.filterAsyncInstrumented(pred, pipelineSize, timer, inSet, duringSet, successSet, failureSet);
    }

    @Nonnull
    default public RecordCursor<T> filterAsyncInstrumented(final @Nonnull Function<T, CompletableFuture<Boolean>> pred, int pipelineSize, final @Nullable StoreTimer timer, final @Nonnull Set<StoreTimer.Count> inSet, final @Nonnull Set<StoreTimer.Event> duringSet, final @Nonnull Set<StoreTimer.Count> successSet, final @Nonnull Set<StoreTimer.Count> failureSet) {
        if (timer == null) {
            return this.filterAsync(pred, pipelineSize);
        }
        Function mapper = new Function<T, CompletableFuture<Optional<T>>>(){

            @Override
            @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="https://github.com/spotbugs/spotbugs/issues/552")
            public CompletableFuture<Optional<T>> apply(T t2) {
                for (StoreTimer.Count in : inSet) {
                    timer.increment(in);
                }
                return timer.instrument(duringSet, ((CompletableFuture)pred.apply(t2)).thenApply(matches -> {
                    if (matches != null && matches.booleanValue()) {
                        for (StoreTimer.Count success : successSet) {
                            timer.increment(success);
                        }
                        return Optional.of(t2);
                    }
                    for (StoreTimer.Count failure : failureSet) {
                        timer.increment(failure);
                    }
                    return Optional.empty();
                }), RecordCursor.this.getExecutor());
            }
        };
        return this.mapPipelined(mapper, pipelineSize).filter(Optional::isPresent).map(Optional::get);
    }

    @Nonnull
    default public CompletableFuture<Void> forEach(Consumer<T> consumer) {
        return this.forEachResult(result -> consumer.accept(result.get())).thenApply(ignore -> null);
    }

    @Nonnull
    default public CompletableFuture<RecordCursorResult<T>> forEachResult(@Nonnull Consumer<RecordCursorResult<T>> consumer) {
        AtomicReference holder = new AtomicReference(RecordCursorResult.exhausted());
        return AsyncUtil.whileTrue(() -> this.onNext().thenApply(result -> {
            if (result.hasNext()) {
                consumer.accept((RecordCursorResult)result);
            } else {
                holder.set(result);
            }
            return result.hasNext();
        }), this.getExecutor()).thenApply(vignore -> (RecordCursorResult)holder.get());
    }

    @Nonnull
    default public CompletableFuture<Void> forEachAsync(@Nonnull Function<T, CompletableFuture<Void>> func, int pipelineSize) {
        return this.mapPipelined(func, pipelineSize).reduce(null, (v1, v2) -> null);
    }

    @Nonnull
    default public CompletableFuture<RecordCursorResult<T>> forEachResultAsync(@Nonnull Function<RecordCursorResult<T>, CompletableFuture<Void>> func) {
        AtomicReference holder = new AtomicReference(RecordCursorResult.exhausted());
        return AsyncUtil.whileTrue(() -> this.onNext().thenCompose(result -> {
            if (result.hasNext()) {
                return ((CompletableFuture)func.apply((RecordCursorResult)result)).thenApply(vignore -> true);
            }
            holder.set(result);
            return AsyncUtil.READY_FALSE;
        }), this.getExecutor()).thenApply(ignore -> (RecordCursorResult)holder.get());
    }

    @Nonnull
    public static <T> RecordCursor<T> orElse(@Nonnull Function<byte[], ? extends RecordCursor<T>> innerFunc, @Nonnull BiFunction<Executor, byte[], ? extends RecordCursor<T>> elseFunc, @Nullable byte[] continuation) {
        return new OrElseCursor(innerFunc, elseFunc, continuation);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromIterator(@Nonnull Iterator<T> iterator) {
        return RecordCursor.fromIterator(ForkJoinPool.commonPool(), iterator);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromIterator(@Nonnull Executor executor, @Nonnull Iterator<T> iterator) {
        if (iterator instanceof AsyncIterator) {
            return new AsyncIteratorCursor(executor, (AsyncIterator)iterator);
        }
        return new IteratorCursor<T>(executor, iterator);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromList(@Nonnull List<T> list) {
        return RecordCursor.fromList(ForkJoinPool.commonPool(), list);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromList(@Nonnull Executor executor, @Nonnull List<T> list) {
        return new ListCursor<T>(executor, list, 0);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromList(@Nonnull List<T> list, @Nullable byte[] continuation) {
        return RecordCursor.fromList(ForkJoinPool.commonPool(), list, continuation);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromList(@Nonnull Executor executor, @Nonnull List<T> list, @Nullable byte[] continuation) {
        int position = 0;
        if (continuation != null) {
            position = ByteBuffer.wrap(continuation).getInt();
        }
        return new ListCursor<T>(executor, list, position);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromFuture(@Nonnull CompletableFuture<T> future) {
        return RecordCursor.fromFuture(ForkJoinPool.commonPool(), future);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromFuture(@Nonnull Executor executor, @Nonnull CompletableFuture<T> future) {
        return RecordCursor.fromFuture(executor, future, null);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromFuture(@Nonnull Executor executor, @Nonnull CompletableFuture<T> future, @Nullable byte[] continuation) {
        return RecordCursor.fromFuture(executor, () -> future, continuation);
    }

    @Nonnull
    public static <T> RecordCursor<T> fromFuture(@Nonnull Executor executor, @Nonnull Supplier<CompletableFuture<T>> futureSupplier, @Nullable byte[] continuation) {
        if (continuation == null) {
            return new FutureCursor<T>(executor, futureSupplier.get());
        }
        return RecordCursor.empty(executor);
    }

    public static <T, V> RecordCursor<T> mapFuture(@Nonnull Executor executor, @Nonnull CompletableFuture<V> future, @Nullable byte[] continuation, @Nonnull BiFunction<V, byte[], ? extends RecordCursor<T>> function) {
        return RecordCursor.flatMapPipelined(outerContinuation -> RecordCursor.fromFuture(executor, future), function, null, continuation, 1);
    }

    @Nonnull
    public static <T> RecordCursor<T> empty() {
        return RecordCursor.empty(ForkJoinPool.commonPool());
    }

    @Nonnull
    public static <T> RecordCursor<T> empty(@Nonnull Executor executor) {
        return new EmptyCursor(executor);
    }

    @Nullable
    default public <U> CompletableFuture<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator) {
        AtomicReference holder = new AtomicReference(identity);
        return this.forEachResult(result -> holder.set(accumulator.apply((Object)holder.get(), (Object)result.get()))).thenApply(vignore -> holder.get());
    }

    @Nullable
    default public <U> CompletableFuture<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator, Predicate<U> stopCondition) {
        AtomicReference holder = new AtomicReference(identity);
        return AsyncUtil.whileTrue(() -> this.onNext().thenApply(result -> {
            if (result.hasNext()) {
                Object nextResult = accumulator.apply((Object)holder.get(), (Object)result.get());
                holder.set(nextResult);
                return !stopCondition.test(nextResult);
            }
            return false;
        }), this.getExecutor()).thenApply(vignore -> holder.get());
    }

    @Nonnull
    default public Stream<T> asStream() {
        return this.asStream(this::close);
    }

    @Nonnull
    default public Stream<T> asStream(Runnable closeHandler) {
        Iterable iterable = this::asIterator;
        return (Stream)StreamSupport.stream(iterable.spliterator(), false).onClose(closeHandler);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static interface ContinuationConvertor {
        @Nullable
        public byte[] unwrapContinuation(@Nullable byte[] var1);

        public RecordCursorContinuation wrapContinuation(@Nonnull RecordCursorContinuation var1);
    }

    public static enum NoNextReason {
        SOURCE_EXHAUSTED(false),
        RETURN_LIMIT_REACHED(false),
        TIME_LIMIT_REACHED(true),
        SCAN_LIMIT_REACHED(true),
        BYTE_LIMIT_REACHED(true);

        final boolean outOfBand;

        private NoNextReason(boolean outOfBand) {
            this.outOfBand = outOfBand;
        }

        public boolean isOutOfBand() {
            return this.outOfBand;
        }

        public boolean isSourceExhausted() {
            return this == SOURCE_EXHAUSTED;
        }

        public boolean isLimitReached() {
            return this != SOURCE_EXHAUSTED;
        }
    }
}

