/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreInterruptedException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.cursors.IllegalContinuationAccessChecker;
import com.apple.foundationdb.record.logging.CompletionExceptionLogHelper;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordCursorIterator<T>
implements AsyncIterator<T>,
AutoCloseable {
    @Nonnull
    private final RecordCursor<T> cursor;
    @Nullable
    private CompletableFuture<Boolean> onHasNextFuture;
    @Nullable
    private RecordCursorResult<T> nextResult;
    private boolean mayGetContinuation = false;

    RecordCursorIterator(@Nonnull RecordCursor<T> cursor) {
        this.cursor = cursor;
    }

    @Override
    @Nonnull
    public CompletableFuture<Boolean> onHasNext() {
        if (this.nextResult != null && !this.nextResult.hasNext()) {
            return AsyncUtil.READY_FALSE;
        }
        if (this.onHasNextFuture == null) {
            this.mayGetContinuation = false;
            this.onHasNextFuture = this.cursor.onNext().thenApply(result -> {
                this.nextResult = result;
                this.mayGetContinuation = !this.nextResult.hasNext();
                return this.nextResult.hasNext();
            });
        }
        return this.onHasNextFuture;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.onHasNext().get();
        }
        catch (ExecutionException ex) {
            throw new RecordCoreException(CompletionExceptionLogHelper.asCause(ex));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RecordCoreInterruptedException(ex.getMessage(), ex);
        }
    }

    @Override
    @Nullable
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.onHasNextFuture = null;
        this.mayGetContinuation = true;
        return this.nextResult.get();
    }

    @Nullable
    public byte[] getContinuation() {
        IllegalContinuationAccessChecker.check(this.mayGetContinuation);
        return this.nextResult.getContinuation().toBytes();
    }

    @Nonnull
    public RecordCursor.NoNextReason getNoNextReason() {
        return this.nextResult.getNoNextReason();
    }

    @Override
    public void close() {
        if (this.onHasNextFuture != null) {
            this.onHasNextFuture.cancel(false);
        }
        this.cursor.close();
    }

    @Override
    public void cancel() {
        this.close();
    }
}

