/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordCursorResult<T> {
    @Nonnull
    private static final RecordCursorResult<Object> EXHAUSTED = new RecordCursorResult(RecordCursorEndContinuation.END, RecordCursor.NoNextReason.SOURCE_EXHAUSTED);
    private final boolean hasNext;
    @Nullable
    private final T nextValue;
    @Nonnull
    private final RecordCursorContinuation continuation;
    @Nullable
    private final RecordCursor.NoNextReason noNextReason;

    private RecordCursorResult(@Nullable T nextValue, @Nonnull RecordCursorContinuation continuation) {
        this.hasNext = true;
        this.nextValue = nextValue;
        this.continuation = continuation;
        this.noNextReason = null;
    }

    private RecordCursorResult(@Nonnull RecordCursorContinuation continuation, @Nonnull RecordCursor.NoNextReason noNextReason) {
        this.hasNext = false;
        this.nextValue = null;
        this.continuation = continuation;
        this.noNextReason = noNextReason;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    @Nullable
    public T get() {
        if (!this.hasNext()) {
            throw new IllegalResultValueAccessException(this.continuation, this.noNextReason);
        }
        return this.nextValue;
    }

    @Nonnull
    public RecordCursorContinuation getContinuation() {
        return this.continuation;
    }

    @Nonnull
    public RecordCursor.NoNextReason getNoNextReason() {
        if (this.hasNext()) {
            throw new IllegalResultNoNextReasonAccessException(this.nextValue, this.continuation);
        }
        return this.noNextReason;
    }

    public String toString() {
        if (this.hasNext()) {
            return "Result(value=" + String.valueOf(this.nextValue) + ", cont=" + String.valueOf(this.continuation) + ")";
        }
        return "Result(cont=" + String.valueOf(this.continuation) + ", reason=" + String.valueOf((Object)this.noNextReason) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordCursorResult that = (RecordCursorResult)o;
        return this.hasNext == that.hasNext && Objects.equals(this.nextValue, that.nextValue) && Objects.equals(this.continuation, that.continuation) && this.noNextReason == that.noNextReason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hasNext, this.nextValue, this.continuation, this.noNextReason});
    }

    @Nonnull
    public <U> RecordCursorResult<U> map(Function<? super T, ? extends U> func) {
        if (this.hasNext()) {
            return RecordCursorResult.withNextValue(func.apply(this.get()), this.getContinuation());
        }
        return this;
    }

    @Nonnull
    public <U> CompletableFuture<RecordCursorResult<U>> mapAsync(Function<? super T, ? extends CompletableFuture<? extends U>> func) {
        if (this.hasNext()) {
            return func.apply(this.nextValue).thenApply(mappedValue -> RecordCursorResult.withNextValue(mappedValue, this.continuation));
        }
        return CompletableFuture.completedFuture(this);
    }

    @Nonnull
    public RecordCursorResult<T> withContinuation(@Nonnull RecordCursorContinuation newContinuation) {
        if (this.hasNext()) {
            return RecordCursorResult.withNextValue(this.nextValue, newContinuation);
        }
        return RecordCursorResult.withoutNextValue(newContinuation, this.noNextReason);
    }

    public boolean hasStoppedBeforeEnd() {
        return !this.hasNext && !this.continuation.isEnd();
    }

    @Nonnull
    public static <T> RecordCursorResult<T> withNextValue(@Nullable T nextValue, @Nonnull RecordCursorContinuation continuation) {
        if (continuation.isEnd()) {
            throw new RecordCoreException("cannot return end continuation with next value", new Object[0]);
        }
        return new RecordCursorResult<T>(nextValue, continuation);
    }

    @Nonnull
    public static <T> RecordCursorResult<T> withoutNextValue(@Nonnull RecordCursorContinuation continuation, @Nonnull RecordCursor.NoNextReason noNextReason) {
        if (continuation.isEnd() && !noNextReason.isSourceExhausted()) {
            throw new RecordCoreException("attempted to return a result with an end continuation and NoNextReason other than SOURCE_EXHAUSTED", new Object[0]);
        }
        if (noNextReason.isSourceExhausted() && !continuation.isEnd()) {
            throw new RecordCoreException("attempted to return a result with NoNextReason of SOURCE_EXHAUSTED but a non-end continuation", new Object[0]);
        }
        if (noNextReason.isSourceExhausted()) {
            return RecordCursorResult.exhausted();
        }
        return new RecordCursorResult<T>(continuation, noNextReason);
    }

    @Nonnull
    public static <T, U> RecordCursorResult<T> withoutNextValue(@Nonnull RecordCursorResult<U> withoutNext) {
        if (withoutNext.hasNext()) {
            throw new RecordCoreException("tried to build record cursor result without next from a result with next", new Object[0]);
        }
        return withoutNext;
    }

    @Nonnull
    public static <T> RecordCursorResult<T> exhausted() {
        return EXHAUSTED;
    }

    public static class IllegalResultValueAccessException
    extends RecordCoreException {
        private static final long serialVersionUID = 1L;

        public IllegalResultValueAccessException(@Nonnull RecordCursorContinuation continuation, @Nonnull RecordCursor.NoNextReason noNextReason) {
            super("Tried to call get() on a RecordCoreResult that did not have a next value.", new Object[0]);
            this.addLogInfo("continuation", (Object)continuation);
            this.addLogInfo("noNextReason", (Object)noNextReason);
        }
    }

    public static class IllegalResultNoNextReasonAccessException
    extends RecordCoreException {
        private static final long serialVersionUID = 1L;

        public IllegalResultNoNextReasonAccessException(@Nullable Object value, @Nonnull RecordCursorContinuation continuation) {
            super("Tried to call noNextReason() on a RecordCoreResult that had a next value.", new Object[0]);
            this.addLogInfo("value", value);
            this.addLogInfo("continuation", (Object)continuation);
        }
    }
}

