/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.google.protobuf.Descriptors;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public abstract class RecordFunction<T>
implements PlanHashable {
    @Nonnull
    private final String name;

    protected RecordFunction(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordFunction that = (RecordFunction)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.name.hashCode();
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, baseHash, this.name, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

